/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;
import org.apache.ctakes.ytex.kernel.metric.SimilarityMetric;

public abstract class BaseSimilarityMetric
implements SimilarityMetric {
    protected ConceptSimilarityService simSvc;

    public ConceptSimilarityService getConceptSimilarityService() {
        return this.simSvc;
    }

    public void setConceptSimilarityService(ConceptSimilarityService conceptSimilarityService) {
        this.simSvc = conceptSimilarityService;
    }

    protected void initLCSes(String concept1, String concept2, SimilarityInfo simInfo) {
        if (simInfo.getLcsDist() == null) {
            simInfo.setLcsDist(this.simSvc.getLCS(concept1, concept2, simInfo.getLcses(), simInfo.getLcsPaths()));
        }
    }

    protected double initLcsIC(Map<String, Double> conceptFilter, SimilarityInfo simInfo, boolean intrinsicIC) {
        Double lcsIC;
        Double d = lcsIC = intrinsicIC ? simInfo.getIntrinsicLcsIC() : simInfo.getCorpusLcsIC();
        if (lcsIC == null) {
            String lcs = null;
            lcsIC = 0.0;
            Object[] bestLCSArr = this.simSvc.getBestLCS(simInfo.getLcses(), intrinsicIC, conceptFilter);
            if (bestLCSArr != null) {
                lcs = (String)bestLCSArr[0];
                lcsIC = (Double)bestLCSArr[1];
                if (intrinsicIC) {
                    simInfo.setIntrinsicLcs(lcs);
                    simInfo.setIntrinsicLcsIC(lcsIC);
                } else {
                    simInfo.setCorpusLcs(lcs);
                    simInfo.setCorpusLcsIC(lcsIC);
                }
            }
        }
        return lcsIC;
    }

    protected double initLcsIC(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo, boolean intrinsicIC) {
        this.initLCSes(concept1, concept2, simInfo);
        return this.initLcsIC(conceptFilter, simInfo, intrinsicIC);
    }

    public BaseSimilarityMetric(ConceptSimilarityService simSvc) {
        this.simSvc = simSvc;
    }
}

