/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.tree;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.tree.InstanceTreeBuilder;
import org.apache.ctakes.ytex.kernel.tree.Node;
import org.apache.ctakes.ytex.kernel.tree.NodeKey;
import org.apache.ctakes.ytex.kernel.tree.NodeMappingInfo;
import org.apache.ctakes.ytex.kernel.tree.QueryMappingInfo;
import org.apache.ctakes.ytex.kernel.tree.TreeMappingInfo;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class InstanceTreeBuilderImpl
implements InstanceTreeBuilder {
    static final Log log = LogFactory.getLog(InstanceTreeBuilderImpl.class);
    SimpleJdbcTemplate simpleJdbcTemplate;
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    Node nodeFromRow(NodeMappingInfo nodeInfo, Map<String, Object> nodeValues) {
        Node n = null;
        HashMap<String, Serializable> values = new HashMap<String, Serializable>(nodeInfo.getValues().size());
        for (String valueName : nodeInfo.getValues()) {
            if (!nodeValues.containsKey(valueName) || nodeValues.get(valueName) == null) continue;
            values.put(valueName, (Serializable)nodeValues.get(valueName));
        }
        if (!values.isEmpty()) {
            n = new Node();
            n.setType(nodeInfo.getNodeType());
            n.setValue(values);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Node> loadInstanceTrees(String filename) throws IOException, ClassNotFoundException {
        try (ObjectInputStream os = null;){
            os = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename)));
            Map map = (Map)os.readObject();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeInstanceTrees(TreeMappingInfo mappingInfo, String filename) throws IOException {
        try (ObjectOutputStream os = null;){
            os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            os.writeObject(this.loadInstanceTrees(mappingInfo));
        }
    }

    @Override
    public Map<Long, Node> loadInstanceTrees(TreeMappingInfo mappingInfo) {
        HashMap<NodeKey, Node> nodeKeyMap = new HashMap<NodeKey, Node>();
        this.prepare(mappingInfo.getPrepareScript(), mappingInfo.getPrepareScriptStatementDelimiter());
        Map<Long, Node> instanceMap = this.loadInstanceTrees(mappingInfo.getInstanceIDField(), mappingInfo.getInstanceQueryMappingInfo(), nodeKeyMap);
        if (mappingInfo.getNodeQueryMappingInfos() != null) {
            for (QueryMappingInfo qInfo : mappingInfo.getNodeQueryMappingInfos()) {
                this.addChildrenToNodes(nodeKeyMap, qInfo);
            }
        }
        return instanceMap;
    }

    protected void prepare(String prepareScript, String prepareScriptDelimiter) {
        if (prepareScript != null && prepareScript.length() > 0) {
            String[] statements = prepareScript.split(prepareScriptDelimiter);
            ArrayList<String> listStatements = new ArrayList<String>(statements.length);
            for (String sql : statements) {
                if (sql == null || sql.trim().length() <= 0) continue;
                listStatements.add(sql);
            }
            JdbcTemplate jt = new JdbcTemplate(this.getDataSource());
            jt.batchUpdate(listStatements.toArray(new String[0]));
        }
    }

    protected Map<Long, Node> loadInstanceTrees(String instanceIDField, QueryMappingInfo qInfo, Map<NodeKey, Node> nodeKeyMap) {
        Node[] currentPath = new Node[qInfo.getNodeTypes().size()];
        HashMap<Long, Node> instanceMap = new HashMap<Long, Node>();
        List rowData = this.simpleJdbcTemplate.queryForList(qInfo.getQuery(), qInfo.getQueryArgs());
        for (Map row : rowData) {
            for (int i = 0; i < qInfo.getNodeTypes().size(); ++i) {
                Node newNode = this.nodeFromRow(qInfo.getNodeTypes().get(i), row);
                if (newNode == null || newNode.equals(currentPath[i])) continue;
                if (i > 0) {
                    currentPath[i - 1].getChildren().add(newNode);
                } else {
                    instanceMap.put(((Number)row.get(instanceIDField)).longValue(), newNode);
                }
                currentPath[i] = newNode;
                if (nodeKeyMap == null) continue;
                nodeKeyMap.put(new NodeKey(newNode), newNode);
            }
        }
        return instanceMap;
    }

    public void addChildrenToNodes(Map<NodeKey, Node> nodeKeyMap, QueryMappingInfo qInfo) {
        List rowData = this.simpleJdbcTemplate.queryForList(qInfo.getQuery(), qInfo.getQueryArgs());
        for (Map row : rowData) {
            Object[] currentPath = new Node[qInfo.getNodeTypes().size()];
            Node parentTmp = this.nodeFromRow(qInfo.getNodeTypes().get(0), row);
            if (parentTmp == null) continue;
            Node parent = nodeKeyMap.get(new NodeKey(parentTmp));
            if (parent == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("couldn't find node for key: " + parentTmp));
                continue;
            }
            currentPath[0] = parent;
            for (int i = 1; i < qInfo.getNodeTypes().size(); ++i) {
                Node newNode = this.nodeFromRow(qInfo.getNodeTypes().get(i), row);
                if (newNode == null || newNode.equals(currentPath[i])) continue;
                Arrays.fill(currentPath, i, currentPath.length - 1, null);
                ((Node)currentPath[i - 1]).getChildren().add(newNode);
                currentPath[i] = newNode;
                if (nodeKeyMap == null) continue;
                nodeKeyMap.put(new NodeKey(newNode), newNode);
            }
        }
    }
}

