/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.dictionary.lookup.ae.UmlsToSnomedConsumerImpl;
import org.apache.uima.UimaContext;

public class UmlsToSnomedDbConsumerImpl
extends UmlsToSnomedConsumerImpl {
    private static final String DB_CONN_RESRC_KEY_PRP_KEY = "dbConnExtResrcKey";
    private static final String MAP_PREP_STMT_PRP_KEY = "mapPrepStmt";
    private static int _maxListSize;
    private final PreparedStatement _preparedStatement;

    public UmlsToSnomedDbConsumerImpl(UimaContext uimaContext, Properties properties, int maxListSize) throws Exception {
        super(uimaContext, properties);
        _maxListSize = maxListSize;
        String resourceName = this.props.getProperty(DB_CONN_RESRC_KEY_PRP_KEY);
        JdbcConnectionResource resrc = (JdbcConnectionResource)uimaContext.getResourceObject(resourceName);
        String sqlStatement = this.props.getProperty(MAP_PREP_STMT_PRP_KEY);
        Connection connection = resrc.getConnection();
        this._preparedStatement = connection.prepareStatement(sqlStatement);
    }

    public UmlsToSnomedDbConsumerImpl(UimaContext uimaContext, Properties properties) throws Exception {
        this(uimaContext, properties, Integer.MAX_VALUE);
    }

    public void close() {
        try {
            if (this._preparedStatement != null && !this._preparedStatement.isClosed()) {
                this._preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected Set<String> getSnomedCodes(String umlsCode) throws SQLException {
        HashSet<String> codeSet = new HashSet<String>();
        this._preparedStatement.setString(1, umlsCode);
        try (ResultSet rs = this._preparedStatement.executeQuery();){
            while (rs.next()) {
                String snomedCode = rs.getString(1).trim();
                codeSet.add(snomedCode);
            }
        }
        return codeSet;
    }
}

