/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.lucene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.dictionary.lookup.AbstractBaseMetaDataHit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

@Immutable
public final class LuceneDocumentMetaDataHitImpl
extends AbstractBaseMetaDataHit {
    private final Document _luceneDoc;
    private final Set<String> _nameSet;
    private final Collection<String> _valueList;

    public LuceneDocumentMetaDataHitImpl(Document luceneDoc) {
        this._luceneDoc = luceneDoc;
        List fieldEnumList = this._luceneDoc.getFields();
        HashSet<String> nameSet = new HashSet<String>(fieldEnumList.size());
        ArrayList<String> valueList = new ArrayList<String>(fieldEnumList.size());
        for (IndexableField field : fieldEnumList) {
            nameSet.add(field.name());
            valueList.add(field.stringValue());
        }
        this._nameSet = Collections.unmodifiableSet(nameSet);
        this._valueList = Collections.unmodifiableList(valueList);
    }

    @Override
    public String getMetaFieldValue(String metaFieldName) {
        return this._luceneDoc.get(metaFieldName);
    }

    @Override
    public Set<String> getMetaFieldNames() {
        return this._nameSet;
    }

    @Override
    public Collection<String> getMetaFieldValues() {
        return this._valueList;
    }
}

