/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperation;

class BulkOperationPacked
extends BulkOperation {
    private final int bitsPerValue;
    private final int blockCount;
    private final int valueCount;
    private final long mask;

    public BulkOperationPacked(int bitsPerValue) {
        this.bitsPerValue = bitsPerValue;
        assert (bitsPerValue > 0 && bitsPerValue <= 64);
        int blocks = bitsPerValue;
        while ((blocks & 1) == 0) {
            blocks >>>= 1;
        }
        this.blockCount = blocks;
        this.valueCount = 64 * this.blockCount / bitsPerValue;
        this.mask = bitsPerValue == 64 ? -1L : (1L << bitsPerValue) - 1L;
        assert (this.valueCount * bitsPerValue == 64 * this.blockCount);
    }

    @Override
    public int blockCount() {
        return this.blockCount;
    }

    @Override
    public int valueCount() {
        return this.valueCount;
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) < 0) {
                values[valuesOffset++] = (blocks[blocksOffset++] & (1L << this.bitsPerValue + bitsLeft) - 1L) << -bitsLeft | blocks[blocksOffset] >>> 64 + bitsLeft;
                bitsLeft += 64;
                continue;
            }
            values[valuesOffset++] = blocks[blocksOffset] >>> bitsLeft & this.mask;
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int blockBitsLeft = 8;
        int valueBitsLeft = this.bitsPerValue;
        long nextValue = 0L;
        int end = valuesOffset + iterations * this.valueCount;
        while (valuesOffset < end) {
            if (valueBitsLeft > blockBitsLeft) {
                nextValue |= ((long)blocks[blocksOffset++] & (1L << blockBitsLeft) - 1L) << valueBitsLeft - blockBitsLeft;
                valueBitsLeft -= blockBitsLeft;
                blockBitsLeft = 8;
                continue;
            }
            values[valuesOffset++] = nextValue |= ((long)blocks[blocksOffset] & 0xFFL) >>> blockBitsLeft - valueBitsLeft & (1L << valueBitsLeft) - 1L;
            nextValue = 0L;
            blockBitsLeft -= valueBitsLeft;
            valueBitsLeft = this.bitsPerValue;
        }
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        if (this.bitsPerValue > 32) {
            throw new UnsupportedOperationException("Cannot decode " + this.bitsPerValue + "-bits values into an int[]");
        }
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) < 0) {
                values[valuesOffset++] = (int)((blocks[blocksOffset++] & (1L << this.bitsPerValue + bitsLeft) - 1L) << -bitsLeft | blocks[blocksOffset] >>> 64 + bitsLeft);
                bitsLeft += 64;
                continue;
            }
            values[valuesOffset++] = (int)(blocks[blocksOffset] >>> bitsLeft & this.mask);
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        if (this.bitsPerValue > 32) {
            throw new UnsupportedOperationException("Cannot decode " + this.bitsPerValue + "-bits values into an int[]");
        }
        int blockBitsLeft = 8;
        int valueBitsLeft = this.bitsPerValue;
        int nextValue = 0;
        int end = valuesOffset + iterations * this.valueCount;
        while (valuesOffset < end) {
            if (valueBitsLeft > blockBitsLeft) {
                nextValue = (int)((long)nextValue | ((long)blocks[blocksOffset++] & (1L << blockBitsLeft) - 1L) << valueBitsLeft - blockBitsLeft);
                valueBitsLeft -= blockBitsLeft;
                blockBitsLeft = 8;
                continue;
            }
            nextValue = (int)((long)nextValue | ((long)blocks[blocksOffset] & 0xFFL) >>> blockBitsLeft - valueBitsLeft & (1L << valueBitsLeft) - 1L);
            values[valuesOffset++] = nextValue;
            nextValue = 0;
            blockBitsLeft -= valueBitsLeft;
            valueBitsLeft = this.bitsPerValue;
        }
    }

    @Override
    public void encode(long[] values, int valuesOffset, long[] blocks, int blocksOffset, int iterations) {
        long nextBlock = 0L;
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= values[valuesOffset++] << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocks[blocksOffset++] = nextBlock |= values[valuesOffset++];
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocks[blocksOffset++] = nextBlock |= values[valuesOffset] >>> -bitsLeft;
            nextBlock = (values[valuesOffset++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }

    @Override
    public void encode(int[] values, int valuesOffset, long[] blocks, int blocksOffset, int iterations) {
        long nextBlock = 0L;
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= ((long)values[valuesOffset++] & 0xFFFFFFFFL) << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocks[blocksOffset++] = nextBlock |= (long)values[valuesOffset++] & 0xFFFFFFFFL;
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocks[blocksOffset++] = nextBlock |= ((long)values[valuesOffset] & 0xFFFFFFFFL) >>> -bitsLeft;
            nextBlock = ((long)values[valuesOffset++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }

    @Override
    public void encode(long[] values, int valuesOffset, byte[] blocks, int blocksOffset, int iterations) {
        long nextBlock = 0L;
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= values[valuesOffset++] << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocksOffset = this.writeLong(nextBlock |= values[valuesOffset++], blocks, blocksOffset);
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocksOffset = this.writeLong(nextBlock |= values[valuesOffset] >>> -bitsLeft, blocks, blocksOffset);
            nextBlock = (values[valuesOffset++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }

    @Override
    public void encode(int[] values, int valuesOffset, byte[] blocks, int blocksOffset, int iterations) {
        long nextBlock = 0L;
        int bitsLeft = 64;
        for (int i = 0; i < this.valueCount * iterations; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= ((long)values[valuesOffset++] & 0xFFFFFFFFL) << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocksOffset = this.writeLong(nextBlock |= (long)values[valuesOffset++] & 0xFFFFFFFFL, blocks, blocksOffset);
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocksOffset = this.writeLong(nextBlock |= ((long)values[valuesOffset] & 0xFFFFFFFFL) >>> -bitsLeft, blocks, blocksOffset);
            nextBlock = ((long)values[valuesOffset++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }
}

