/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.preprocessor.ae;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.ctakes.core.ci.HyphenTextModifierImpl;
import org.apache.ctakes.core.ci.TextModification;
import org.apache.ctakes.core.ci.TextModifier;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.preprocessor.ClinicalNotePreProcessor;
import org.apache.ctakes.preprocessor.DocumentMetaData;
import org.apache.ctakes.preprocessor.SegmentMetaData;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.util.Pair;
import org.apache.ctakes.typesystem.type.util.Pairs;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="CDA View Sectionizer", description="Transforms CDA text into plain text, inserts hyphens into words, stores the resulting text in a new View and creates Sections.", dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID}, products={PipeBitInfo.TypeProduct.SECTION})
public class CdaCasInitializer
extends JCasAnnotator_ImplBase {
    protected static final String DEFAULT_HYPHEN_FILE = "org/apache/ctakes/preprocessor/tokenizer/hyphenated.txt";
    protected static final String DEFAULT_DTD_FILE = "org/apache/ctakes/preprocessor/cda/NotesIIST_RTF.DTD";
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private Boolean includeSectionMarkers;
    private TextModifier tm;
    private UimaContext uimaContext;
    public static final String PARAM_DTD_FILE = "DtdFile";
    @ConfigurationParameter(name="DtdFile", description="Path to File that contains the DTD file", defaultValue={"org/apache/ctakes/preprocessor/cda/NotesIIST_RTF.DTD"}, mandatory=false)
    protected String dtdfilepath;
    public static final String PARAM_HYPHEN_FILE = "HyphenFile";
    @ConfigurationParameter(name="HyphenFile", description="Path to File that contains the hypenated file", defaultValue={"org/apache/ctakes/preprocessor/tokenizer/hyphenated.txt"}, mandatory=false)
    protected String hyphenfilepath;

    public void initialize(UimaContext aCtx) throws ResourceInitializationException {
        super.initialize(aCtx);
        this.uimaContext = aCtx;
        this.initialize();
    }

    public void initialize() throws ResourceInitializationException {
        this.includeSectionMarkers = new Boolean(false);
        int hyphWindow = 3;
        try {
            this.logger.info((Object)("Hyphen dictionary: " + this.hyphenfilepath));
            this.tm = new HyphenTextModifierImpl(this.hyphenfilepath, hyphWindow);
            this.logger.info((Object)("DTD: " + this.dtdfilepath));
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void applyTextModifier(String text, StringBuffer sb) throws Exception {
        TextModification[] textModArr = this.tm.modify(text);
        for (int i = 0; i < textModArr.length; ++i) {
            TextModification textMod = textModArr[i];
            if (textMod.getOrigStartOffset() != textMod.getNewStartOffset() || textMod.getOrigEndOffset() != textMod.getNewEndOffset()) {
                this.logger.warn((Object)"UNSUPPORTED: TextModification with offset changes.");
                continue;
            }
            sb.replace(textMod.getOrigStartOffset(), textMod.getOrigEndOffset(), textMod.getNewText());
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.logger.info((Object)" process(JCas)");
        String originalText = null;
        try {
            JCas originalView = jcas.getView("_InitialView");
            originalText = originalView.getSofaDataString();
            ClinicalNotePreProcessor pp = new ClinicalNotePreProcessor(FileLocator.getAsStream((String)this.dtdfilepath), this.includeSectionMarkers);
            DocumentMetaData dmd = pp.process(originalText);
            String text = dmd.getText();
            StringBuffer sb = new StringBuffer(text);
            this.applyTextModifier(text, sb);
            JCas plaintextView = jcas.createView("plaintext");
            plaintextView.setDocumentText(sb.toString());
            for (String segmentID : dmd.getSegmentIdentifiers()) {
                SegmentMetaData smd = dmd.getSegment(segmentID);
                Segment sa = new Segment(plaintextView);
                sa.setBegin(smd.span.start);
                sa.setEnd(smd.span.end);
                sa.setId(smd.id);
                sa.addToIndexes();
            }
            Pairs propAnnot = new Pairs(plaintextView);
            Map metaDataMap = dmd.getMetaData();
            String docID = (String)metaDataMap.get("DOC_ID");
            if (docID != null) {
                DocumentID newDocId = new DocumentID(plaintextView);
                newDocId.setDocumentID(docID);
                newDocId.addToIndexes();
            }
            FSArray fsArr = new FSArray(plaintextView, metaDataMap.size());
            Iterator keyItr = metaDataMap.keySet().iterator();
            int pos = 0;
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                Object value = metaDataMap.get(key);
                if (value instanceof String) {
                    Pair prop = new Pair(plaintextView);
                    prop.setAttribute(key);
                    prop.setValue((String)value);
                    fsArr.set(pos++, (FeatureStructure)prop);
                    continue;
                }
                if (!(value instanceof HashSet)) continue;
            }
            propAnnot.setPairs(fsArr);
            propAnnot.addToIndexes();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

