/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputrichtext;

import com.icesoft.faces.component.inputrichtext.InputRichText;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.ResourceRegistryLocator;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.net.URI;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class InputRichTextRenderer
extends DomBasicInputRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        InputRichText inputRichText = (InputRichText)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            root.setAttribute("id", ClientIdPool.get(clientId + "container"));
            Element div = domContext.createElement("div");
            root.setAttribute("class", inputRichText.getStyleClass());
            if (inputRichText.getStyle() != null) {
                root.setAttribute("style", inputRichText.getStyle());
            }
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            Element lib = domContext.createElement("script");
            lib.setAttribute("type", "text/javascript");
            lib.setAttribute("src", CoreUtils.resolveResourceURL(facesContext, inputRichText.getBaseURI().toString()));
            root.appendChild(lib);
            URI icelibURI = ResourceRegistryLocator.locate(facesContext).loadJavascriptCode(InputRichText.ICE_FCK_EDITOR_JS);
            Element icelib = domContext.createElement("script");
            icelib.setAttribute("type", "text/javascript");
            icelib.setAttribute("src", CoreUtils.resolveResourceURL(facesContext, icelibURI.toString()));
            root.appendChild(icelib);
            root.appendChild(div);
            div.setAttribute("id", ClientIdPool.get(clientId + "editor"));
            StringBuffer call = new StringBuffer();
            boolean partialSubmit = inputRichText.getPartialSubmit();
            if (inputRichText.isSaveOnSubmit()) {
                partialSubmit = false;
            }
            call.append("Ice.FCKeditor.register ('" + clientId + "', new Ice.FCKeditor('" + clientId + "', '" + inputRichText.getLanguage() + "', '" + inputRichText.getFor() + "', '" + CoreUtils.resolveResourceURL(facesContext, inputRichText.getBaseURI().getPath()) + "','" + inputRichText.getWidth() + "', '" + inputRichText.getHeight() + "', '" + inputRichText.getToolbar() + "', '" + inputRichText.getCustomConfigPath() + "', '" + inputRichText.getSkin() + "'," + partialSubmit + "));");
            call.append("Ice.Prototype.$('" + clientId + "')[\"focus\"]= function(){handleApplicationFocus('" + clientId + "');};");
            String value = "";
            if (inputRichText.getValue() != null) {
                value = inputRichText.getValue().toString();
            }
            this.addHiddenField(domContext, root, ClientIdPool.get(clientId + "valueHolder"), value);
            this.addHiddenField(domContext, root, ClientIdPool.get(clientId + "Disabled"), String.valueOf(inputRichText.isDisabled()));
            Element scriptHolder = domContext.createElement("div");
            scriptHolder.setAttribute("id", ClientIdPool.get(clientId + "script"));
            scriptHolder.setAttribute("style", "display:none");
            Element script = domContext.createElement("script");
            script.setAttribute("type", "text/javascript");
            script.appendChild(domContext.createTextNodeUnescaped(call.toString()));
            scriptHolder.appendChild(script);
            root.appendChild(scriptHolder);
            if (inputRichText.isSaveOnSubmit()) {
                Element saveOnSubmit = domContext.createElement("input");
                saveOnSubmit.setAttribute("id", clientId + "saveOnSubmit");
                saveOnSubmit.setAttribute("name", clientId + "saveOnSubmit");
                saveOnSubmit.setAttribute("type", "hidden");
                root.appendChild(saveOnSubmit);
            }
            Element onCompleteInvoked = domContext.createElement("input");
            onCompleteInvoked.setAttribute("id", clientId + "onCompleteInvoked");
            onCompleteInvoked.setAttribute("name", clientId + "onCompleteInvoked");
            onCompleteInvoked.setAttribute("type", "hidden");
            root.appendChild(onCompleteInvoked);
            div.setAttribute("onmouseout", "Ice.FCKeditorUtility.updateFields('" + clientId + "');");
            div.setAttribute("onmouseover", "Ice.FCKeditorUtility.activeEditor ='" + clientId + "';");
            JavascriptContext.addJavascriptCall(facesContext, "Ice.FCKeditorUtility && Ice.FCKeditorUtility.updateValue ('" + clientId + "');");
            domContext.stepOver();
        }
    }

    private void addHiddenField(DOMContext domContext, Element root, String fieldName, String value) {
        Element hiddenFld = domContext.createElement("input");
        hiddenFld.setAttribute("type", "hidden");
        hiddenFld.setAttribute("id", fieldName);
        hiddenFld.setAttribute("name", fieldName);
        if (value != null) {
            hiddenFld.setAttribute("value", value);
        }
        root.appendChild(hiddenFld);
    }
}

