/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.paneltabset;

import com.icesoft.faces.component.panelseries.UISeries;
import com.icesoft.faces.component.paneltabset.PanelTab;
import com.icesoft.faces.component.paneltabset.PanelTabSet;
import com.icesoft.faces.component.paneltabset.TabChangeEvent;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.HTML;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.CSSNamePool;
import com.icesoft.util.pooling.ClientIdPool;
import java.beans.Beans;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PanelTabSetRenderer
extends DomBasicRenderer {
    private static final String HIDDEN_FIELD_NAME = "cl";
    private static final Log log = LogFactory.getLog(PanelTabSetRenderer.class);
    private static final String SPACER_IMG = "/xmlhttp/css/xp/css-images/spacer.gif";

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PanelTabSetRenderer.validateParameters(facesContext, uiComponent, PanelTabSet.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        PanelTabSet tabSet = (PanelTabSet)uiComponent;
        if (!domContext.isInitialized()) {
            Element divWrapper = domContext.createRootElement("div");
            Element table = domContext.createElement("table");
            table.setAttribute("cellpadding", "0");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("id", tabSet.getClientIdForRootElement(facesContext));
            divWrapper.appendChild(table);
        }
        FormRenderer.addHiddenField(facesContext, PanelTabSetRenderer.deriveCommonHiddenFieldName(facesContext, uiComponent));
        String baseClass = tabSet.getStyleClass();
        int selectedIndex = tabSet.getSelectedIndex();
        UIComponent parentForm = PanelTabSetRenderer.findForm((UIComponent)tabSet);
        if (parentForm == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)" TabbedPane::must be in a FORM");
            }
            return;
        }
        if (tabSet.getValue() != null) {
            if (tabSet.getChildCount() < 1) {
                if (log.isErrorEnabled()) {
                    log.error((Object)" TabbedPane:a panelTab element is required");
                }
                return;
            }
            if (tabSet.getChildCount() > 1 || !(tabSet.getChildren().get(0) instanceof PanelTab)) {
                if (log.isErrorEnabled()) {
                    log.error((Object)" TabbedPane::only one panelTab element allowed when using value atttibute");
                }
                return;
            }
        }
        if (tabSet.getWidth() != null) {
            Element divWrapper = (Element)domContext.getRootNode();
            divWrapper.setAttribute("style", "width:" + tabSet.getWidth() + "px;overflow:hidden;");
        }
        Element table = (Element)domContext.getRootNode().getFirstChild();
        for (int i = 0; i < HTML.TABLE_PASSTHROUGH_ATTRIBUTES.length; ++i) {
            if (HTML.TABLE_PASSTHROUGH_ATTRIBUTES[i].equalsIgnoreCase("styleClass")) {
                PanelTabSetRenderer.renderAttribute((UIComponent)tabSet, table, HTML.TABLE_PASSTHROUGH_ATTRIBUTES[i], "class");
                continue;
            }
            PanelTabSetRenderer.renderAttribute((UIComponent)tabSet, table, HTML.TABLE_PASSTHROUGH_ATTRIBUTES[i], HTML.TABLE_PASSTHROUGH_ATTRIBUTES[i]);
        }
        Boolean visible = (Boolean)uiComponent.getAttributes().get("visible");
        if (visible != null && !visible.booleanValue()) {
            String style = table.getAttribute("style");
            if (style == null) {
                style = "";
            } else if (style.trim().length() > 0 && !style.trim().endsWith(";")) {
                style = style + ";";
            }
            style = style + "display:none;";
            table.setAttribute("style", style);
        }
        DOMContext.removeChildrenByTagName(table, "tr");
        Element headerRow = domContext.createElement("tr");
        int tabIdx = 0;
        int visibleTabCount = 0;
        List children = tabSet.getChildren();
        List tabList = null;
        if (tabSet.getValue() != null) {
            tabList = (List)tabSet.getValue();
        }
        if (tabSet.getTabPlacement().equalsIgnoreCase("bottom")) {
            if (tabList != null) {
                visibleTabCount = tabList.size();
            } else {
                int len = children.size();
                for (int i = 0; i < len; ++i) {
                    UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof PanelTab) || !child.isRendered()) continue;
                    ++visibleTabCount;
                }
            }
            Element contentRow = domContext.createElement("tr");
            table.appendChild(contentRow);
            table.appendChild(headerRow);
            Element headerTd = domContext.createElement("td");
            headerRow.appendChild(headerTd);
            Element tabsTable = domContext.createElement("table");
            tabsTable.setAttribute("cellpadding", "0");
            tabsTable.setAttribute("cellspacing", "0");
            headerTd.appendChild(tabsTable);
            Element tabsTableRow = domContext.createElement("tr");
            tabsTable.appendChild(tabsTableRow);
            contentRow.setAttribute("height", "100%");
            this.writeTabCell(domContext, facesContext, tabSet, visibleTabCount, selectedIndex, contentRow, tabSet);
            if (tabSet.getValue() != null) {
                int rowIndex = tabSet.getFirst();
                int rowsToBeDisplayed = tabSet.getRows();
                tabSet.setRowIndex(rowIndex);
                for (int rowsDisplayed = 0; tabSet.isRowAvailable() && (rowsToBeDisplayed <= 0 || rowsDisplayed < rowsToBeDisplayed); ++rowsDisplayed) {
                    UIComponent child = this.getUIComponent((UIComponent)tabSet.getChildren().get(0));
                    if (child instanceof PanelTab) {
                        if (child.isRendered()) {
                            this.writeHeaderCell(domContext, facesContext, tabSet, (PanelTab)child, tabIdx, tabIdx == selectedIndex, ((PanelTab)child).isDisabled(), tabsTableRow);
                            ++visibleTabCount;
                        }
                        ++tabIdx;
                    }
                    tabSet.setRowIndex(++rowIndex);
                }
                tabSet.setRowIndex(-1);
            } else {
                int len = children.size();
                for (int i = 0; i < len; ++i) {
                    UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof PanelTab)) continue;
                    if (child.isRendered()) {
                        this.writeHeaderCell(domContext, facesContext, tabSet, (PanelTab)child, tabIdx, tabIdx == selectedIndex, ((PanelTab)child).isDisabled(), tabsTableRow);
                        ++visibleTabCount;
                    }
                    ++tabIdx;
                }
            }
            Element td = domContext.createElement("td");
            String className = tabSet.getSpacerClass();
            td.setAttribute("class", className);
            Text text = domContext.createTextNodeUnescaped("&#160;");
            td.appendChild(text);
            tabsTableRow.appendChild(td);
            domContext.stepOver();
        } else {
            table.appendChild(headerRow);
            Element headerTd = domContext.createElement("td");
            headerRow.appendChild(headerTd);
            Element tabsTable = domContext.createElement("table");
            tabsTable.setAttribute("cellpadding", "0");
            tabsTable.setAttribute("cellspacing", "0");
            headerTd.appendChild(tabsTable);
            Element tabsTableRow = domContext.createElement("tr");
            tabsTable.appendChild(tabsTableRow);
            if (tabSet.getValue() != null) {
                int rowIndex = tabSet.getFirst();
                int rowsToBeDisplayed = tabSet.getRows();
                tabSet.setRowIndex(rowIndex);
                for (int rowsDisplayed = 0; tabSet.isRowAvailable() && (rowsToBeDisplayed <= 0 || rowsDisplayed < rowsToBeDisplayed); ++rowsDisplayed) {
                    UIComponent child = this.getUIComponent((UIComponent)tabSet.getChildren().get(0));
                    if (child instanceof PanelTab) {
                        if (child.isRendered()) {
                            this.writeHeaderCell(domContext, facesContext, tabSet, (PanelTab)child, tabIdx, tabIdx == selectedIndex, ((PanelTab)child).isDisabled(), tabsTableRow);
                            ++visibleTabCount;
                        }
                        ++tabIdx;
                    }
                    tabSet.setRowIndex(++rowIndex);
                }
                tabSet.setRowIndex(-1);
            } else {
                int len = children.size();
                for (int i = 0; i < len; ++i) {
                    UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                    if (!(child instanceof PanelTab)) continue;
                    if (child.isRendered()) {
                        this.writeHeaderCell(domContext, facesContext, tabSet, (PanelTab)child, tabIdx, tabIdx == selectedIndex, ((PanelTab)child).isDisabled(), tabsTableRow);
                        ++visibleTabCount;
                    }
                    ++tabIdx;
                }
            }
            Element td = domContext.createElement("td");
            String className = tabSet.getSpacerClass();
            td.setAttribute("class", className);
            Text text = domContext.createTextNodeUnescaped("&#160;");
            td.appendChild(text);
            tabsTableRow.appendChild(td);
            Element contentRow = domContext.createElement("tr");
            contentRow.setAttribute("height", "100%");
            table.appendChild(contentRow);
            this.writeTabCell(domContext, facesContext, tabSet, visibleTabCount, selectedIndex, contentRow, tabSet);
            domContext.stepOver();
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        PanelTabSetRenderer.validateParameters(facesContext, uiComponent, PanelTabSet.class);
        PanelTabSet tabSet = (PanelTabSet)uiComponent;
        tabSet.saveConsistentSelectedIndex();
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        int tabIdx = 0;
        if (tabSet.getValue() != null) {
            int rowIndex = tabSet.getFirst();
            tabSet.setRowIndex(rowIndex);
            int rowsToBeDisplayed = tabSet.getRows();
            UIComponent child = this.getUIComponent((UIComponent)tabSet.getChildren().get(0));
            for (int rowsDisplayed = 0; tabSet.isRowAvailable() && (rowsToBeDisplayed <= 0 || rowsDisplayed < rowsToBeDisplayed); ++rowsDisplayed) {
                if (child instanceof PanelTab) {
                    String paramName = tabSet.getClientId(facesContext) + "." + tabIdx;
                    String paramValue = (String)paramMap.get(paramName);
                    if (paramValue != null && paramValue.length() > 0) {
                        int oldTabIdx = tabSet.getSelectedIndex();
                        tabSet.setSubmittedSelectedIndex(tabIdx);
                        tabSet.queueEvent(new TabChangeEvent((UIComponent)tabSet, oldTabIdx, tabIdx));
                        JavascriptContext.addJavascriptCall(facesContext, "document.getElementById('" + paramName + "').focus();");
                        return;
                    }
                    ++tabIdx;
                }
                tabSet.setRowIndex(++rowIndex);
            }
            tabSet.setRowIndex(-1);
        } else {
            List children = tabSet.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                if (!(child instanceof PanelTab)) continue;
                String paramName = tabSet.getClientId(facesContext) + "." + tabIdx;
                String paramValue = (String)paramMap.get(paramName);
                if (paramValue != null && paramValue.length() > 0) {
                    int oldTabIdx = tabSet.getSelectedIndex();
                    tabSet.setSubmittedSelectedIndex(tabIdx);
                    tabSet.queueEvent(new TabChangeEvent((UIComponent)tabSet, oldTabIdx, tabIdx));
                    JavascriptContext.addJavascriptCall(facesContext, "document.getElementById('" + paramName + "').focus();");
                    return;
                }
                ++tabIdx;
            }
        }
    }

    protected void writeHeaderCell(DOMContext domContext, FacesContext facesContext, PanelTabSet tabSet, PanelTab tab, int tabIndex, boolean active, boolean disabled, Element tr) throws IOException {
        String tabStyleClass;
        String disableStyleClassSuffix;
        String baseClass = tabSet.getStyleClass();
        Element td = domContext.createElement("td");
        td.setAttribute("id", ClientIdPool.get(tabSet.getClientId(facesContext) + "ht" + tabIndex));
        tr.appendChild(td);
        String styleClass = tab.getStyleClass();
        String label = tab.getLabel();
        if (label == null || label.length() == 0) {
            label = "Tab " + tabIndex;
        }
        String tabPlacement = "";
        if (tabSet.getTabPlacement().equalsIgnoreCase("bottom")) {
            tabPlacement = "Btm";
            td.setAttribute("style", "vertical-align:top;");
        } else {
            td.setAttribute("style", "vertical-align:bottom;");
        }
        Element table = domContext.createElement("table");
        td.appendChild(table);
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        Element tr_top = domContext.createElement("tr");
        Element tr_mid = domContext.createElement("tr");
        Element tr_bot = domContext.createElement("tr");
        Element td_top_left = domContext.createElement("td");
        Element td_top_mid = domContext.createElement("td");
        Element td_top_right = domContext.createElement("td");
        this.renderSpacerImage(domContext, td_top_left);
        this.renderSpacerImage(domContext, td_top_mid);
        this.renderSpacerImage(domContext, td_top_right);
        Element td_mid_left = domContext.createElement("td");
        Element td_mid_mid = domContext.createElement("td");
        Element td_mid_right = domContext.createElement("td");
        this.renderSpacerImage(domContext, td_mid_left);
        this.renderSpacerImage(domContext, td_mid_right);
        Element td_bot_left = domContext.createElement("td");
        Element td_bot_mid = domContext.createElement("td");
        Element td_bot_right = domContext.createElement("td");
        this.renderSpacerImage(domContext, td_bot_left);
        this.renderSpacerImage(domContext, td_bot_mid);
        this.renderSpacerImage(domContext, td_bot_right);
        UIComponent labelFacet = tab.getLabelFacet();
        if (disabled) {
            disableStyleClassSuffix = "-dis";
            if (labelFacet == null) {
                Text text = domContext.createTextNode(label);
                td_mid_mid.appendChild(text);
            } else {
                Node cursor = domContext.getCursorParent();
                domContext.setCursorParent(td_mid_mid);
                CustomComponentUtils.renderChild(facesContext, labelFacet);
                domContext.setCursorParent(cursor);
            }
        } else {
            disableStyleClassSuffix = "";
            Element link = domContext.createElement("a");
            String linkId = ClientIdPool.get(tabSet.getClientId(facesContext) + "." + tabIndex);
            link.setAttribute("name", linkId);
            link.setAttribute("id", linkId);
            link.setAttribute("href", "javascript:;");
            link.setAttribute("class", "icePnlTbLblLnk");
            if (labelFacet == null) {
                td_mid_mid.appendChild(link);
                if (tabSet.isKeyboardNavigationEnabled()) {
                    link.setAttribute("onfocus", "return Ice.pnlTabOnFocus(this, false, true);");
                    link.setAttribute("onblur", "return Ice.pnlTabOnBlur(this, false, true);");
                } else {
                    link.setAttribute("onfocus", "return Ice.pnlTabOnFocus(this, false, false);");
                    link.setAttribute("onblur", "return Ice.pnlTabOnBlur(this, false, false);");
                }
                this.renderLinkText(label, domContext, link, tab, tabSet);
            } else {
                if (tabSet.isKeyboardNavigationEnabled()) {
                    link.setAttribute("onfocus", "return Ice.pnlTabOnFocus(this, true, true);");
                    link.setAttribute("onblur", "return Ice.pnlTabOnBlur(this, true, true);");
                } else {
                    link.setAttribute("onfocus", "return Ice.pnlTabOnFocus(this, true, false);");
                    link.setAttribute("onblur", "return Ice.pnlTabOnBlur(this, true, false);");
                }
                link.setAttribute("style", "position:relative; top:0px;");
                Element div = domContext.createElement("div");
                td_mid_mid.appendChild(div);
                div.setAttribute("onclick", "if(!Ice.isEventSourceInputElement(event)) document.getElementById('" + linkId + "').onclick();");
                div.setAttribute("class", "ptfd");
                if (active) {
                    PanelTabSetRenderer.renderAttribute((UIComponent)tabSet, div, "tabindex", "tabindex");
                }
                div.appendChild(link);
                Node cursor = domContext.getCursorParent();
                domContext.setCursorParent(div);
                CustomComponentUtils.renderChild(facesContext, labelFacet);
                domContext.setCursorParent(cursor);
                label = "<img src='" + CoreUtils.resolveResourceURL(facesContext, SPACER_IMG) + "' />";
                Text spacer = domContext.createTextNodeUnescaped(label);
                link.appendChild(spacer);
            }
            Map parameterMap = PanelTabSetRenderer.getParameterMap(facesContext, (UIComponent)tab);
            this.renderOnClick(facesContext, (UIComponent)tabSet, tab, link, parameterMap);
            for (String nextKey : parameterMap.keySet()) {
                FormRenderer.addHiddenField(facesContext, nextKey);
            }
        }
        if (active) {
            tabStyleClass = tab.getTabOnClass(tabPlacement);
            table.setAttribute("class", tabStyleClass);
        } else {
            tabStyleClass = tab.getTabOffClass(tabPlacement);
            table.setAttribute("class", tabStyleClass);
            if (!disabled) {
                table.setAttribute("onmouseover", "this.className='" + tab.getTabOverClass(tabPlacement) + "';");
                table.setAttribute("onmouseout", "this.className='" + tab.getTabOffClass(tabPlacement) + "';");
            } else {
                table.removeAttribute("onmouseover");
                table.removeAttribute("onmouseout");
            }
        }
        td_top_left.setAttribute("class", CSSNamePool.get("LftTop" + disableStyleClassSuffix));
        td_top_mid.setAttribute("class", CSSNamePool.get("MidTop" + disableStyleClassSuffix));
        td_top_right.setAttribute("class", CSSNamePool.get("RtTop" + disableStyleClassSuffix));
        td_mid_left.setAttribute("class", CSSNamePool.get("LftMid" + disableStyleClassSuffix));
        td_mid_mid.setAttribute("class", CSSNamePool.get("MidMid" + disableStyleClassSuffix));
        td_mid_right.setAttribute("class", CSSNamePool.get("RtMid" + disableStyleClassSuffix));
        td_bot_left.setAttribute("class", CSSNamePool.get("LftBtm" + disableStyleClassSuffix));
        td_bot_mid.setAttribute("class", CSSNamePool.get("MidBtm" + disableStyleClassSuffix));
        td_bot_right.setAttribute("class", CSSNamePool.get("RtBtm" + disableStyleClassSuffix));
        tr_top.appendChild(td_top_left);
        tr_top.appendChild(td_top_mid);
        tr_top.appendChild(td_top_right);
        table.appendChild(tr_top);
        tr_mid.appendChild(td_mid_left);
        tr_mid.appendChild(td_mid_mid);
        tr_mid.appendChild(td_mid_right);
        table.appendChild(tr_mid);
        tr_bot.appendChild(td_bot_left);
        tr_bot.appendChild(td_bot_mid);
        tr_bot.appendChild(td_bot_right);
        table.appendChild(tr_bot);
        if (styleClass != null) {
            td.setAttribute("class", styleClass);
        }
        if (tab.getTitle() != null) {
            td.setAttribute("title", tab.getTitle());
        }
    }

    protected static String deriveCommonHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        if (Beans.isDesignTime()) {
            return "";
        }
        try {
            UIComponent parentNamingContainer = PanelTabSetRenderer.findNamingContainer(uiComponent);
            String parentClientId = parentNamingContainer.getClientId(facesContext);
            return parentClientId + ':' + "j_id" + HIDDEN_FIELD_NAME;
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Panel Tab Set must be in a <ice:form>", e);
        }
    }

    private void renderLinkText(String linkText, DOMContext domContext, Element link, PanelTab tab, PanelTabSet tabSet) {
        if (linkText != null && linkText.length() != 0) {
            Text labelNode = (Text)link.getFirstChild();
            if (labelNode == null) {
                labelNode = domContext.createTextNode(linkText);
                tab.addHeaderText(domContext, link, labelNode, tabSet);
            } else {
                labelNode.setData(linkText);
            }
        }
    }

    static Map getParameterMap(FacesContext facesContext, UIComponent uiComponent) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (UIComponent nextChild : uiComponent.getChildren()) {
            if (!(nextChild instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)nextChild;
            parameterMap.put(uiParam.getName(), uiParam.getValue());
        }
        return parameterMap;
    }

    private void renderOnClick(FacesContext facesContext, UIComponent tabSet, PanelTab tab, Element root, Map parameters) {
        UIComponent uiForm = PanelTabSetRenderer.findForm(tabSet);
        if (uiForm == null) {
            throw new FacesException("CommandLink must be contained in a form");
        }
        String uiFormClientId = uiForm.getClientId(facesContext);
        String onclick = tab.getOnclick();
        root.setAttribute("onclick", PanelTabSetRenderer.combinedPassThru(onclick, this.getJavaScriptOnClickString(facesContext, tabSet, uiFormClientId, parameters)));
    }

    private String getJavaScriptOnClickString(FacesContext facesContext, UIComponent uiComponent, String formClientId, Map parameters) {
        String submit = "iceSubmitPartial(";
        if (!((PanelTabSet)uiComponent).isPartialSubmit()) {
            submit = "iceSubmit(";
        }
        return this.getJavascriptHiddenFieldSetters(facesContext, uiComponent, formClientId, parameters) + submit + " document.forms['" + formClientId + "']," + " this,event); " + this.getJavascriptHiddenFieldReSetters(facesContext, uiComponent, formClientId, parameters) + "return false;";
    }

    private String getJavascriptHiddenFieldSetters(FacesContext facesContext, UIComponent uiComponent, String formClientId, Map parameters) {
        StringBuffer buffer = new StringBuffer("document.forms['" + formClientId + "']['");
        buffer.append(PanelTabSetRenderer.deriveCommonHiddenFieldName(facesContext, uiComponent));
        buffer.append("'].value='");
        buffer.append(uiComponent.getClientId(facesContext));
        buffer.append("';");
        for (String nextParamName : parameters.keySet()) {
            Object nextParamValue = parameters.get(nextParamName);
            buffer.append("document.forms['");
            buffer.append(formClientId);
            buffer.append("']['");
            buffer.append(nextParamName);
            buffer.append("'].value='");
            buffer.append((String)nextParamValue);
            buffer.append("';");
        }
        return buffer.toString();
    }

    private String getJavascriptHiddenFieldReSetters(FacesContext facesContext, UIComponent uiComponent, String formClientId, Map parameters) {
        StringBuffer buffer = new StringBuffer("document.forms['" + formClientId + "']['");
        buffer.append(PanelTabSetRenderer.deriveCommonHiddenFieldName(facesContext, uiComponent));
        buffer.append("'].value='");
        buffer.append("';");
        for (String nextParamName : parameters.keySet()) {
            Object nextParamValue = parameters.get(nextParamName);
            buffer.append("document.forms['");
            buffer.append(formClientId);
            buffer.append("']['");
            buffer.append(nextParamName);
            buffer.append("'].value='");
            buffer.append("';");
        }
        return buffer.toString();
    }

    private void renderSpacerImage(DOMContext domContext, Element td) {
        Element img = domContext.createElement("img");
        img.setAttribute("src", CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), SPACER_IMG));
        img.setAttribute("height", "1");
        img.setAttribute("width", "4");
        img.setAttribute("alt", "");
        td.appendChild(img);
    }

    protected void writeTabCell(DOMContext domContext, FacesContext facesContext, PanelTabSet tabSet, int tabCount, int selectedIndex, Element tr, UISeries uiList) throws IOException {
        Element td = domContext.createElement("td");
        td.setAttribute("id", ClientIdPool.get(tabSet.getClientId(facesContext) + "td" + tabCount));
        tr.appendChild(td);
        td.setAttribute("class", tabSet.getContentClass());
        domContext.setCursorParent(td);
        int tabIdx = 0;
        if (uiList.getValue() != null) {
            int rowIndex = uiList.getFirst();
            uiList.setRowIndex(rowIndex);
            int rowsToBeDisplayed = uiList.getRows();
            UIComponent child = this.getUIComponent((UIComponent)tabSet.getChildren().get(0));
            for (int rowsDisplayed = 0; uiList.isRowAvailable() && (rowsToBeDisplayed <= 0 || rowsDisplayed < rowsToBeDisplayed); ++rowsDisplayed) {
                if (child instanceof PanelTab) {
                    if (tabIdx == selectedIndex) {
                        CustomComponentUtils.renderChild(facesContext, child);
                    }
                    ++tabIdx;
                }
                uiList.setRowIndex(++rowIndex);
            }
            uiList.setRowIndex(-1);
        } else {
            List children = tabSet.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.getUIComponent((UIComponent)children.get(i));
                if (child instanceof PanelTab) {
                    if (tabIdx == selectedIndex) {
                        CustomComponentUtils.renderChild(facesContext, child);
                    }
                    ++tabIdx;
                    continue;
                }
                CustomComponentUtils.renderChild(facesContext, child);
            }
        }
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UIForm || uiComponent instanceof UINamingContainer) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }
}

