/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.SelectManyCheckboxListRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RadioRenderer
extends SelectManyCheckboxListRenderer {
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(23);

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean renderVertically, Element rootTable, Element rootTR, int counter, Object[] submittedValue, Object componentValue) throws IOException {
        String itemLabel;
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, (UIComponent)uiSelectOne);
        if (renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        String labelClass = null;
        boolean disabled = false;
        if (uiSelectOne.getAttributes().get("disabled") != null && uiSelectOne.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            disabled = true;
        }
        if (selectItem.isDisabled()) {
            disabled = true;
        }
        if ((labelClass = (String)uiSelectOne.getAttributes().get("styleClass")) != null && disabled) {
            labelClass = labelClass + "-dis";
        }
        Element td = domContext.createElement("td");
        rootTR.appendChild(td);
        Element input = domContext.createElement("input");
        td.appendChild(input);
        input.setAttribute("type", "radio");
        if (disabled) {
            input.setAttribute("disabled", "disabled");
        }
        boolean readonly = false;
        if (uiComponent.getAttributes().get("readonly") != null && uiComponent.getAttributes().get("readonly").equals(Boolean.TRUE)) {
            readonly = true;
        }
        if (readonly) {
            input.setAttribute("readonly", "readonly");
        }
        HashSet<String> excludes = new HashSet<String>();
        String accesskey = (String)uiComponent.getAttributes().get("accesskey");
        if (accesskey != null) {
            input.setAttribute("accesskey", accesskey);
            excludes.add("accesskey");
        }
        if (this.isValueSelected(facesContext, selectItem, (UIComponent)uiSelectOne, submittedValue, componentValue)) {
            input.setAttribute("checked", "checked");
        } else {
            input.removeAttribute("checked");
        }
        input.setAttribute("name", uiSelectOne.getClientId(facesContext));
        String inputID = ClientIdPool.get(uiComponent.getClientId(facesContext) + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "_" + counter);
        input.setAttribute("id", inputID);
        input.setAttribute("value", this.formatComponentValue(facesContext, (UIComponent)uiSelectOne, selectItem.getValue()));
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, passThruAttributes);
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, input, null, new String[]{"tabindex", "onclick"});
        input.setAttribute("onkeypress", RadioRenderer.combinedPassThru((String)uiSelectOne.getAttributes().get("onkeypress"), "Ice.util.radioCheckboxEnter(form,this,event);"));
        Element label = domContext.createElement("label");
        td.appendChild(label);
        label.setAttribute("for", inputID);
        if (labelClass != null) {
            label.setAttribute("class", labelClass);
        }
        if ((itemLabel = selectItem.getLabel()) != null) {
            Text labelText = domContext.createTextNode(itemLabel);
            label.appendChild(labelText);
        }
    }

    protected void renderOption(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String labelClass;
        boolean disabled;
        RadioRenderer.validateParameters(facesContext, uiComponent, null);
        UIComponent forComponent = RadioRenderer.findForComponent(facesContext, uiComponent);
        if (!(forComponent instanceof UISelectOne)) {
            throw new IllegalStateException("Could not find UISelectOne component for radio button.");
        }
        String layout = (String)forComponent.getAttributes().get("layout");
        if (layout == null || !layout.equals("spread")) {
            return;
        }
        List selectItemList = this.getSelectItemList(forComponent);
        if (selectItemList.isEmpty()) {
            throw new IllegalStateException("Could not find select items for UISelectOne component.");
        }
        Object[] submittedValue = this.getSubmittedSelectedValues(forComponent);
        Object componentValue = submittedValue != null ? null : this.getCurrentSelectedValues(forComponent);
        UISelectOne selectOne = (UISelectOne)forComponent;
        int radioIndex = (Integer)uiComponent.getAttributes().get("index");
        if (radioIndex < 0) {
            radioIndex = 0;
        }
        if (radioIndex >= selectItemList.size()) {
            radioIndex = selectItemList.size() - 1;
        }
        SelectItem selectItem = (SelectItem)selectItemList.get(radioIndex);
        String selectOneClientId = selectOne.getClientId(facesContext);
        String radioClientId = ClientIdPool.get(selectOneClientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "_" + radioIndex);
        String selectItemValue = this.formatComponentValue(facesContext, (UIComponent)selectOne, selectItem.getValue());
        String selectItemLabel = selectItem.getLabel();
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (domContext.isInitialized()) {
            DOMContext.removeChildren(domContext.getRootNode());
        } else {
            domContext.createRootElement("span");
        }
        Node rootNode = domContext.getRootNode();
        HashSet excludes = new HashSet();
        Object attrObj = selectOne.getAttributes().get("disabled");
        boolean bl = disabled = attrObj != null && Boolean.valueOf(attrObj.toString()) != false;
        if (!disabled) {
            disabled = selectItem.isDisabled();
        }
        Element input = domContext.createElement("input");
        input.setAttribute("type", "radio");
        input.setAttribute("id", radioClientId);
        input.setAttribute("name", selectOneClientId);
        input.setAttribute("value", selectItemValue);
        if (disabled) {
            input.setAttribute("disabled", "disabled");
        }
        if (this.isValueSelected(facesContext, selectItem, (UIComponent)selectOne, submittedValue, componentValue)) {
            input.setAttribute("checked", "checked");
        }
        this.addJavaScript(facesContext, (UIComponent)selectOne, input, excludes);
        Element label = domContext.createElement("label");
        label.setAttribute("for", radioClientId);
        attrObj = selectOne.getAttributes().get("styleClass");
        String string = labelClass = attrObj == null ? "" : attrObj.toString().trim();
        if (labelClass.length() > 0) {
            if (disabled) {
                String[] styleClasses = labelClass.split("\\s");
                labelClass = "";
                for (int i = 0; i < styleClasses.length; ++i) {
                    if (i > 0) {
                        labelClass = labelClass + " ";
                    }
                    if ((labelClass = labelClass + styleClasses[i]).endsWith("-dis")) continue;
                    labelClass = labelClass + "-dis";
                }
            }
            label.setAttribute("class", labelClass);
        }
        if (selectItemLabel != null) {
            label.appendChild(domContext.createTextNode(selectItemLabel));
        }
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, (UIComponent)selectOne, input, label, passThruAttributes);
        PassThruAttributeRenderer.renderBooleanAttributes(facesContext, (UIComponent)selectOne, input, new String[]{"disabled"});
        input.setAttribute("onkeypress", RadioRenderer.combinedPassThru((String)selectOne.getAttributes().get("onkeypress"), "Ice.util.radioCheckboxEnter(form,this,event);"));
        rootNode.appendChild(input);
        rootNode.appendChild(label);
        domContext.stepOver();
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiSelectOne, Element input, Set excludes) {
    }
}

