/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import cc.mallet.fst.SimpleTagger;
import cc.mallet.fst.Transducer;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.jar.SequenceClassifierBuilder_ImplBase;
import org.cleartk.ml.mallet.MalletCrfStringOutcomeClassifier;

public class MalletCrfStringOutcomeClassifierBuilder
extends SequenceClassifierBuilder_ImplBase<MalletCrfStringOutcomeClassifier, List<NameNumber>, String, String> {
    private static final String MODEL_NAME = "model.malletcrf";
    protected Transducer transducer;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.malletcrf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trainClassifier(File dir, String ... args) throws Exception {
        String[] malletArgs = new String[args.length + 5];
        System.arraycopy(args, 0, malletArgs, 0, args.length);
        malletArgs[malletArgs.length - 5] = "--train";
        malletArgs[malletArgs.length - 4] = "true";
        malletArgs[malletArgs.length - 3] = "--model-file";
        malletArgs[malletArgs.length - 2] = new File(dir, MODEL_NAME).getPath();
        malletArgs[malletArgs.length - 1] = this.getTrainingDataFile(dir).getPath();
        String leaveMyLoggingAloneMallet = "java.util.logging.config.file";
        String propValue = System.getProperty(leaveMyLoggingAloneMallet);
        System.setProperty(leaveMyLoggingAloneMallet, "anything-but-null");
        try {
            SimpleTagger.main((String[])malletArgs);
        }
        finally {
            System.getProperties().remove(leaveMyLoggingAloneMallet);
            if (propValue != null) {
                System.setProperty(leaveMyLoggingAloneMallet, propValue);
            }
        }
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)MODEL_NAME, (File)new File(dir, MODEL_NAME));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)MODEL_NAME);
        ObjectInputStream objectStream = new ObjectInputStream(modelStream);
        try {
            this.transducer = (Transducer)objectStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected MalletCrfStringOutcomeClassifier newClassifier() {
        return new MalletCrfStringOutcomeClassifier((FeaturesEncoder<List<NameNumber>>)this.featuresEncoder, (OutcomeEncoder<String, String>)this.outcomeEncoder, this.transducer);
    }
}

