/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet.grmm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.NameNumberFeaturesEncoder;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.encoder.outcome.StringArrayToStringArrayEncoder;
import org.cleartk.ml.jar.SequenceDataWriter_ImplBase;
import org.cleartk.ml.mallet.grmm.GrmmClassifierBuilder;

public class GrmmDataWriter
extends SequenceDataWriter_ImplBase<GrmmClassifierBuilder, List<NameNumber>, String[], String[]> {
    public GrmmDataWriter(File outputDirectory) throws IOException {
        super(outputDirectory);
        NameNumberFeaturesEncoder fe = new NameNumberFeaturesEncoder();
        fe.addEncoder((FeatureEncoder)new NumberEncoder());
        fe.addEncoder((FeatureEncoder)new BooleanEncoder());
        fe.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)fe);
        this.setOutcomeEncoder((OutcomeEncoder)new StringArrayToStringArrayEncoder());
    }

    public void writeEncoded(List<NameNumber> features, String[] outcome) {
        GrmmDataWriter.writeEncoded(features, outcome, this.trainingDataWriter);
    }

    public void writeEndSequence() {
        this.trainingDataWriter.println();
    }

    protected GrmmClassifierBuilder newClassifierBuilder() {
        return new GrmmClassifierBuilder();
    }

    public static void writeEncoded(List<NameNumber> features, String[] outcome, PrintWriter writer) {
        for (int i = 0; i < outcome.length; ++i) {
            if (i > 0) {
                writer.print(" ");
            }
            writer.print(outcome[i]);
        }
        writer.print(" ");
        writer.print("---- ");
        for (NameNumber nameNumber : features) {
            writer.print(nameNumber.name);
            writer.print(":");
            writer.print(nameNumber.number);
            writer.print(" ");
        }
        writer.println();
    }
}

