/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight.rank;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Instance;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.outcome.DoubleToDoubleOutcomeEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.svmlight.SvmLightDataWriter_ImplBase;
import org.cleartk.ml.svmlight.rank.QidInstance;
import org.cleartk.ml.svmlight.rank.SvmLightRankBuilder;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightRankDataWriter
extends SvmLightDataWriter_ImplBase<SvmLightRankBuilder, Double, Double> {
    private Map<String, Integer> instQidToEncodedQidMap;
    private int lastEncodedQid;

    public SvmLightRankDataWriter(File outputDirectory) throws IOException {
        super(outputDirectory);
        this.setOutcomeEncoder((OutcomeEncoder)new DoubleToDoubleOutcomeEncoder());
        this.instQidToEncodedQidMap = new HashMap<String, Integer>();
        this.lastEncodedQid = 0;
    }

    @Override
    protected String outcomeToString(Double outcome) {
        return outcome.toString();
    }

    public void write(Instance<Double> instance) throws CleartkProcessingException {
        if (!(instance instanceof QidInstance)) {
            throw new CleartkProcessingException("", "Unable to write non-QidInstance", new Object[0]);
        }
        String qid = ((QidInstance)instance).getQid();
        this.writeEncoded(this.getEncodedQid(qid), (FeatureVector)((SvmLightRankBuilder)this.classifierBuilder).getFeaturesEncoder().encodeAll((Iterable)instance.getFeatures()), (Double)((SvmLightRankBuilder)this.classifierBuilder).getOutcomeEncoder().encode(instance.getOutcome()));
    }

    protected SvmLightRankBuilder newClassifierBuilder() {
        return new SvmLightRankBuilder();
    }

    public void writeEncoded(int qid, FeatureVector features, Double outcome) throws CleartkProcessingException {
        StringBuffer output = new StringBuffer();
        output.append(this.outcomeToString(outcome));
        output.append(String.format(Locale.US, " qid:%d", qid));
        for (FeatureVector.Entry entry : features) {
            if (Double.isInfinite(entry.value) || Double.isNaN(entry.value)) {
                throw CleartkEncoderException.invalidFeatureVectorValue((int)entry.index, (double)entry.value);
            }
            output.append(String.format(Locale.US, " %d:%.7f", entry.index, entry.value));
        }
        this.trainingDataWriter.println(output);
    }

    private int getEncodedQid(String qid) {
        if (this.instQidToEncodedQidMap.containsKey(qid)) {
            return this.instQidToEncodedQidMap.get(qid);
        }
        ++this.lastEncodedQid;
        this.instQidToEncodedQidMap.put(qid, this.lastEncodedQid);
        return this.lastEncodedQid;
    }
}

