/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.ace2005;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ne.type.Ace2005Document;
import org.cleartk.ne.type.NamedEntity;
import org.cleartk.ne.type.NamedEntityMention;
import org.cleartk.util.ViewUriUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class Ace2005Writer
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = "outputDirectoryName";
    @ConfigurationParameter(name="outputDirectoryName", mandatory=true, description="provides the path of the directory where the XML files should be written.")
    private String outputDirectoryName;
    private File outputDirectory;
    private int idIndex = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private Element createExtentElement(String elementName, Annotation annotation) {
        Element extent = new Element(elementName);
        Element charseq = new Element("charseq");
        charseq.setAttribute("START", "" + annotation.getBegin());
        charseq.setAttribute("END", "" + (annotation.getEnd() - 1));
        charseq.setText(annotation.getCoveredText());
        extent.addContent((Content)charseq);
        return extent;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String uri = new File(ViewUriUtil.getURI((JCas)jCas)).getName();
        String docId = uri.substring(0, uri.indexOf(".sgm"));
        Ace2005Document document = (Ace2005Document)JCasUtil.select((JCas)jCas, Ace2005Document.class).iterator().next();
        Document xml = new Document();
        Element sourceFileElement = new Element("source_file");
        sourceFileElement.setAttribute("URI", uri);
        sourceFileElement.setAttribute("SOURCE", document.getAceSource());
        sourceFileElement.setAttribute("TYPE", document.getAceType());
        xml.addContent((Content)sourceFileElement);
        Element documentElement = new Element("document");
        documentElement.setAttribute("DOCID", docId);
        sourceFileElement.addContent((Content)documentElement);
        FSIterator namedEntities = jCas.getFSIndexRepository().getAllIndexedFS(jCas.getCasType(NamedEntity.type));
        while (namedEntities.hasNext()) {
            String entityClass;
            NamedEntity namedEntity = (NamedEntity)namedEntities.next();
            Element namedEntityElement = new Element("entity");
            namedEntityElement.setAttribute("ID", "" + this.idIndex++);
            namedEntityElement.setAttribute("TYPE", namedEntity.getEntityType());
            String entitySubtype = namedEntity.getEntitySubtype();
            if (entitySubtype != null) {
                namedEntityElement.setAttribute("SUBTYPE", entitySubtype);
            }
            if ((entityClass = namedEntity.getEntityClass()) != null) {
                namedEntityElement.setAttribute("CLASS", entityClass);
            }
            FSArray namedEntityMentions = namedEntity.getMentions();
            for (int i = 0; i < namedEntityMentions.size(); ++i) {
                NamedEntityMention namedEntityMention = (NamedEntityMention)namedEntityMentions.get(i);
                Element namedEntityMentionElement = new Element("entity_mention");
                namedEntityMentionElement.setAttribute("ID", "" + this.idIndex++);
                namedEntityMentionElement.setAttribute("TYPE", namedEntityMention.getMentionType());
                namedEntityMentionElement.addContent((Content)this.createExtentElement("extent", namedEntityMention.getAnnotation()));
                namedEntityMentionElement.addContent((Content)this.createExtentElement("head", namedEntityMention.getHead()));
                namedEntityElement.addContent((Content)namedEntityMentionElement);
            }
            documentElement.addContent((Content)namedEntityElement);
        }
        XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
        try {
            FileOutputStream stream = new FileOutputStream(new File(this.outputDirectory, docId + ".cleartk.xml"));
            xmlOut.output(xml, (OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void setOutputDirectoryName(String outputDirectoryName) {
        this.outputDirectoryName = outputDirectoryName;
    }
}

