/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank.util;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.cleartk.corpus.propbank.util.PropbankFormatException;
import org.cleartk.corpus.propbank.util.PropbankRelation;
import org.cleartk.corpus.propbank.util.Proplabel;
import org.cleartk.srl.type.Predicate;
import org.cleartk.srl.type.SemanticArgument;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.token.type.Sentence;

@Beta
public class Propbank {
    protected String filename;
    protected int sentenceNumber;
    protected PropbankRelation terminal;
    protected String taggerName;
    protected String baseForm;
    protected String frameSet;
    protected String inflectionValue;
    protected List<Proplabel> proplabels = new ArrayList<Proplabel>();
    protected String propTxt;

    public static Propbank fromString(String propTxt) {
        String[] columns = propTxt.split(" ");
        Propbank propbank = new Propbank();
        try {
            int labelsStart;
            propbank.setPropTxt(propTxt);
            propbank.setFilename(columns[0]);
            propbank.setSentenceNumber(Integer.parseInt(columns[1]));
            propbank.setTerminal(PropbankRelation.fromString(columns[2]));
            if (columns[5].indexOf(58) >= 0) {
                labelsStart = 5;
                propbank.setBaseForm(columns[3]);
                propbank.setFrameSet(columns[4]);
            } else {
                labelsStart = 6;
                propbank.setTaggerName(columns[3]);
                String[] baseFormAndFrameSet = columns[4].split("\\.");
                propbank.setBaseForm(baseFormAndFrameSet[0]);
                propbank.setFrameSet(baseFormAndFrameSet[1]);
                propbank.setInflectionValue(columns[5]);
            }
            for (int i = labelsStart; i < columns.length; ++i) {
                propbank.addProplabel(Proplabel.fromString(columns[i]));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PropbankFormatException("invalid Propbank entry: " + propTxt);
        }
        catch (NumberFormatException e) {
            throw new PropbankFormatException("invalid Propbank entry: " + propTxt);
        }
        return propbank;
    }

    public static String filenameFromString(String propTxt) {
        return propTxt.split(" ")[0];
    }

    public String getPropTxt() {
        return this.propTxt;
    }

    public void setPropTxt(String propTxt) {
        this.propTxt = propTxt;
    }

    protected Propbank() {
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBaseForm() {
        return this.baseForm;
    }

    public void setBaseForm(String baseForm) {
        this.baseForm = baseForm;
    }

    public String getFrameSet() {
        return this.frameSet;
    }

    public void setFrameSet(String frameSet) {
        this.frameSet = frameSet;
    }

    public String getInflectionValue() {
        return this.inflectionValue;
    }

    public void setInflectionValue(String inflectionValue) {
        this.inflectionValue = inflectionValue;
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public void setSentenceNumber(int sentenceNumber) {
        this.sentenceNumber = sentenceNumber;
    }

    public String getTaggerName() {
        return this.taggerName;
    }

    public void setTaggerName(String taggerName) {
        this.taggerName = taggerName;
    }

    public PropbankRelation getTerminal() {
        return this.terminal;
    }

    public void setTerminal(PropbankRelation terminal) {
        this.terminal = terminal;
    }

    public List<Proplabel> getPropLabels() {
        return Collections.unmodifiableList(this.proplabels);
    }

    public void setPropLabels(List<Proplabel> proplabels) {
        this.proplabels.clear();
        if (proplabels != null) {
            this.proplabels.addAll(proplabels);
        }
    }

    public void addProplabel(Proplabel proplabel) {
        this.proplabels.add(proplabel);
    }

    public Predicate convert(JCas view, TopTreebankNode topNode, Sentence sentence) {
        Predicate p = new Predicate(view);
        p.setPropTxt(this.propTxt);
        p.setAnnotation(this.terminal.convert(view, topNode));
        p.setBegin(p.getAnnotation().getBegin());
        p.setEnd(p.getAnnotation().getEnd());
        p.setSentence(sentence);
        p.setFrameSet(this.frameSet);
        p.setBaseForm(this.baseForm);
        ArrayList<SemanticArgument> aList = new ArrayList<SemanticArgument>();
        for (Proplabel proplabel : this.proplabels) {
            aList.add(proplabel.convert(view, topNode));
        }
        p.setArguments(new FSArray(view, aList.size()));
        FSCollectionFactory.fillArrayFS((ArrayFS)p.getArguments(), aList);
        p.addToIndexes();
        return p;
    }

    public String displayText() {
        StringBuffer text = new StringBuffer(String.format("filename = %s\nsentence number = %s\nterminal = %s\nbase form = %s\nframe set = %s\ntagger = %s\ninflection value = %s\n", this.getFilename(), this.getSentenceNumber(), this.getTerminal(), this.getBaseForm(), this.getFrameSet(), this.getTaggerName(), this.getInflectionValue()));
        for (Proplabel label : this.getPropLabels()) {
            text.append(String.format("proplabel = %s %s\ntext = %s\n", label.getLabel(), label.getFeature(), label.getRelation()));
        }
        return text.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("%s %s %s", this.getFilename(), this.getSentenceNumber(), this.getTerminal()));
        if (this.getTaggerName() == null) {
            buffer.append(String.format(" %s %s", this.getBaseForm(), this.getFrameSet()));
        } else {
            buffer.append(String.format(" %s %s.%s %s", this.getTaggerName(), this.getBaseForm(), this.getFrameSet(), this.getInflectionValue()));
        }
        for (Proplabel label : this.getPropLabels()) {
            buffer.append(' ');
            buffer.append(label);
        }
        return buffer.toString();
    }
}

