/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank.util;

import com.google.common.annotations.Beta;
import org.apache.uima.jcas.JCas;
import org.cleartk.corpus.propbank.util.PropbankRelation;
import org.cleartk.syntax.constituent.type.TerminalTreebankNode;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;

@Beta
public class PropbankNodeRelation
extends PropbankRelation {
    protected int terminalNumber;
    protected int height;

    public static PropbankNodeRelation fromString(String s) {
        String[] fields = s.split(":");
        if (fields.length != 2) {
            throw new IllegalArgumentException();
        }
        return new PropbankNodeRelation(Integer.valueOf(fields[0]), Integer.valueOf(fields[1]));
    }

    public PropbankNodeRelation(int terminalNumber, int height) {
        this.terminalNumber = terminalNumber;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getTerminalNumber() {
        return this.terminalNumber;
    }

    public void setTerminalNumber(int terminalNumber) {
        this.terminalNumber = terminalNumber;
    }

    public TreebankNode convert(JCas jCas, TopTreebankNode topNode) {
        TerminalTreebankNode node = topNode.getTerminals(this.terminalNumber);
        for (int i = 0; i < this.height; ++i) {
            node = node.getParent();
        }
        return node;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTerminalNumber()) + ":" + String.valueOf(this.getHeight());
    }
}

