/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.timeml;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Time;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.ViewUriUtil;

public class TempEval2010Writer
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputDirectory", mandatory=true, description="The directory where the TempEval .tab files should be written.")
    private File outputDirectory;
    @ConfigurationParameter(name="textView", mandatory=true, description="View containing the document text.")
    private String textView;
    @ConfigurationParameter(name="documentCreationTimeView", mandatory=false, description="View containing DocumentCreationTime annotations. If provided, the document creation times file will be written.")
    private String documentCreationTimeView;
    @ConfigurationParameter(name="timeExtentView", mandatory=false, description="View containing Time annotations. If provided, the time extents file will be written.")
    private String timeExtentView;
    @ConfigurationParameter(name="timeAttributeView", mandatory=false, description="View containing Time annotations with their attributes. If provided, the time attributes file will be written.")
    private String timeAttributeView;
    @ConfigurationParameter(name="eventExtentView", mandatory=false, description="View containing Event annotations. If provided, the event extents will be written.")
    private String eventExtentView;
    @ConfigurationParameter(name="eventAttributeView", mandatory=false, description="View containing Event annotations with their attributes. If provided, the event attributes file will be written.")
    private String eventAttributeView;
    @ConfigurationParameter(name="temporalLinkEventToDocumentCreationTimeView", mandatory=false, description="View containing TemporalLink annotations between events and the document creation time. If provided, the corresponding temporal links file will be written.")
    private String temporalLinkEventToDocumentCreationTimeView;
    @ConfigurationParameter(name="temporalLinkEventToSameSentenceTimeView", mandatory=false, description="View containing TemporalLink annotations between events and times within the same sentence. If provided, the corresponding temporal links file will be written.")
    private String temporalLinkEventToSameSentenceTimeView;
    @ConfigurationParameter(name="temporalLinkEventToSubordinatedEventView", mandatory=false, description="View containing TemporalLink annotations between events and syntactically dominated events. If provided, the corresponding temporal links file will be written.")
    private String temporalLinkEventToSubordinatedEventView;
    @ConfigurationParameter(name="temporalLinkMainEventToNextSentenceMainEventView", mandatory=false, description="View containing TemporalLink annotations between main events in adjacent sentences. If provided, the corresponding temporal links file will be written.")
    private String temporalLinkMainEventToNextSentenceMainEventView;
    public static final String PARAM_OUTPUT_DIRECTORY = "outputDirectory";
    public static final String PARAM_TEXT_VIEW = "textView";
    public static final String PARAM_DOCUMENT_CREATION_TIME_VIEW = "documentCreationTimeView";
    public static final String PARAM_TIME_EXTENT_VIEW = "timeExtentView";
    public static final String PARAM_TIME_ATTRIBUTE_VIEW = "timeAttributeView";
    public static final String PARAM_EVENT_EXTENT_VIEW = "eventExtentView";
    public static final String PARAM_EVENT_ATTRIBUTE_VIEW = "eventAttributeView";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_DOCUMENT_CREATION_TIME_VIEW = "temporalLinkEventToDocumentCreationTimeView";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_SAME_SENTENCE_TIME_VIEW = "temporalLinkEventToSameSentenceTimeView";
    public static final String PARAM_TEMPORAL_LINK_EVENT_TO_SUBORDINATED_EVENT_VIEW = "temporalLinkEventToSubordinatedEventView";
    public static final String PARAM_TEMPORAL_LINK_MAIN_EVENT_TO_NEXT_SENTENCE_MAIN_EVENT_VIEW = "temporalLinkMainEventToNextSentenceMainEventView";
    private List<PrintWriter> writers;
    private PrintWriter baseWriter;
    private PrintWriter dctWriter;
    private PrintWriter timexExtentWriter;
    private PrintWriter timexAttributeWriter;
    private PrintWriter eventExtentWriter;
    private PrintWriter eventAttributeWriter;
    private PrintWriter tlinkDCTEventWriter;
    private PrintWriter tlinkMainEventsWriter;
    private PrintWriter tlinkSubordinatedEventsWriter;
    private PrintWriter tlinkTimexEventWriter;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TempEval2010Writer.class, (Object[])new Object[0]);
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.writers = new ArrayList<PrintWriter>();
        this.baseWriter = this.createWriter("base-segmentation.tab", this.textView);
        this.dctWriter = this.createWriter("dct.txt", this.documentCreationTimeView);
        this.timexExtentWriter = this.createWriter("timex-extents.tab", this.timeExtentView);
        this.timexAttributeWriter = this.createWriter("timex-attributes.tab", this.timeAttributeView);
        this.eventExtentWriter = this.createWriter("event-extents.tab", this.eventExtentView);
        this.eventAttributeWriter = this.createWriter("event-attributes.tab", this.eventAttributeView);
        this.tlinkDCTEventWriter = this.createWriter("tlinks-dct-event.tab", this.temporalLinkEventToDocumentCreationTimeView);
        this.tlinkTimexEventWriter = this.createWriter("tlinks-timex-event.tab", this.temporalLinkEventToSameSentenceTimeView);
        this.tlinkSubordinatedEventsWriter = this.createWriter("tlinks-subordinated-events.tab", this.temporalLinkEventToSubordinatedEventView);
        this.tlinkMainEventsWriter = this.createWriter("tlinks-main-events.tab", this.temporalLinkMainEventToNextSentenceMainEventView);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        URI uri = ViewUriUtil.getURI((JCas)jCas);
        String fileName = uri.getFragment();
        if (fileName == null) {
            fileName = new File(uri.getPath()).getName();
        }
        JCas textJCas = JCasUtil.getView((JCas)jCas, (String)this.textView, (boolean)false);
        if (this.documentCreationTimeView != null) {
            JCas dctJCas = JCasUtil.getView((JCas)jCas, (String)this.documentCreationTimeView, (boolean)false);
            for (DocumentCreationTime time : JCasUtil.select((JCas)dctJCas, DocumentCreationTime.class)) {
                this.write(this.dctWriter, fileName, time.getValue().replaceAll("-", ""));
            }
        }
        HashMap<Token, Time> tokenTimeExtents = new HashMap<Token, Time>();
        if (this.timeExtentView != null) {
            JCas timeExtentJCas = JCasUtil.getView((JCas)jCas, (String)this.timeExtentView, (boolean)false);
            for (Time time : JCasUtil.select((JCas)timeExtentJCas, Time.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)textJCas, Token.class, (AnnotationFS)time)) {
                    tokenTimeExtents.put(token, time);
                }
            }
        }
        HashMap<Token, Time> tokenTimeAttributes = new HashMap<Token, Time>();
        if (this.timeAttributeView != null) {
            JCas timeAttributeJCas = JCasUtil.getView((JCas)jCas, (String)this.timeAttributeView, (boolean)false);
            for (Time time : JCasUtil.select((JCas)timeAttributeJCas, Time.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)textJCas, Token.class, (AnnotationFS)time)) {
                    tokenTimeAttributes.put(token, time);
                }
            }
        }
        HashMap<Token, Event> tokenEventExtents = new HashMap<Token, Event>();
        if (this.eventExtentView != null) {
            JCas eventExtentJCas = JCasUtil.getView((JCas)jCas, (String)this.eventExtentView, (boolean)false);
            for (Event event : JCasUtil.select((JCas)eventExtentJCas, Event.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)textJCas, Token.class, (AnnotationFS)event)) {
                    tokenEventExtents.put(token, event);
                }
            }
        }
        HashMap<Token, Event> tokenEventAttributes = new HashMap<Token, Event>();
        if (this.eventAttributeView != null) {
            JCas eventAttributeJCas = JCasUtil.getView((JCas)jCas, (String)this.eventAttributeView, (boolean)false);
            for (Event event : JCasUtil.select((JCas)eventAttributeJCas, Event.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)textJCas, Token.class, (AnnotationFS)event)) {
                    tokenEventAttributes.put(token, event);
                }
            }
        }
        int sentIndex = -1;
        for (Sentence sentence : JCasUtil.select((JCas)textJCas, Sentence.class)) {
            ++sentIndex;
            int tokenIndex = -1;
            for (Token token : JCasUtil.selectCovered((JCas)textJCas, Token.class, (AnnotationFS)sentence)) {
                this.write(this.baseWriter, fileName, sentIndex, ++tokenIndex, token.getCoveredText());
                this.writeAnchors(this.timexExtentWriter, this.timexAttributeWriter, tokenTimeExtents, tokenTimeAttributes, "timex3", token, fileName, sentIndex, tokenIndex, new AttributeGetter<Time>(){

                    @Override
                    public List<Attribute> getAttributes(Time time) {
                        Attribute value = new Attribute("value", time.getValue());
                        Attribute type = new Attribute("type", time.getTimeType());
                        return Arrays.asList(value, type);
                    }
                });
                this.writeAnchors(this.eventExtentWriter, this.eventAttributeWriter, tokenEventExtents, tokenEventAttributes, "event", token, fileName, sentIndex, tokenIndex, new AttributeGetter<Event>(){

                    @Override
                    public List<Attribute> getAttributes(Event event) {
                        Attribute polarity = new Attribute("polarity", event.getPolarity());
                        Attribute modality = new Attribute("modality", event.getModality());
                        Attribute pos = new Attribute("pos", event.getPos());
                        Attribute tense = new Attribute("tense", event.getTense());
                        Attribute aspect = new Attribute("aspect", event.getAspect());
                        Attribute eventClass = new Attribute("class", event.getEventClass());
                        return Arrays.asList(polarity, modality, pos, tense, aspect, eventClass);
                    }
                });
            }
        }
        this.writeTemporalLinks(this.tlinkDCTEventWriter, jCas, this.temporalLinkEventToDocumentCreationTimeView, fileName);
        this.writeTemporalLinks(this.tlinkTimexEventWriter, jCas, this.temporalLinkEventToSameSentenceTimeView, fileName);
        this.writeTemporalLinks(this.tlinkSubordinatedEventsWriter, jCas, this.temporalLinkEventToSubordinatedEventView, fileName);
        this.writeTemporalLinks(this.tlinkMainEventsWriter, jCas, this.temporalLinkMainEventToNextSentenceMainEventView, fileName);
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        for (PrintWriter writer : this.writers) {
            writer.flush();
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        for (PrintWriter writer : this.writers) {
            writer.close();
        }
    }

    private PrintWriter createWriter(String tabFileName, String viewParam) throws ResourceInitializationException {
        PrintWriter writer;
        if (viewParam != null) {
            try {
                writer = new PrintWriter(new FileWriter(new File(this.outputDirectory, tabFileName)));
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        } else {
            writer = new PrintWriter(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
        }
        this.writers.add(writer);
        return writer;
    }

    private void write(PrintWriter writer, Object ... columns) {
        writer.println(Joiner.on((char)'\t').join(columns));
    }

    private <T extends Anchor> void writeAnchors(PrintWriter extentWriter, PrintWriter attrWriter, Map<Token, T> tokenAnchorExtents, Map<Token, T> tokenAnchorAttributes, String anchorType, Token token, String fileName, int sentIndex, int tokenIndex, AttributeGetter<T> attributeGetter) {
        String id;
        Anchor anchor = (Anchor)tokenAnchorExtents.get(token);
        if (anchor != null) {
            id = anchor.getId();
            this.write(extentWriter, fileName, sentIndex, tokenIndex, anchorType, id, "1");
        }
        if ((anchor = (Anchor)tokenAnchorAttributes.get(token)) != null) {
            boolean isFirstToken;
            id = anchor.getId();
            boolean bl = isFirstToken = token.getBegin() == anchor.getBegin();
            if (isFirstToken) {
                for (Attribute attr : attributeGetter.getAttributes(anchor)) {
                    if (attr.value == null) continue;
                    this.write(attrWriter, fileName, sentIndex, tokenIndex, anchorType, id, "1", attr.name, attr.value);
                }
            }
        }
    }

    private void writeTemporalLinks(PrintWriter writer, JCas jCas, String viewName, String fileName) {
        if (viewName != null) {
            JCas view = JCasUtil.getView((JCas)jCas, (String)viewName, (boolean)false);
            for (TemporalLink tlink : JCasUtil.select((JCas)view, TemporalLink.class)) {
                String relation = tlink.getRelationType();
                if (relation == null) {
                    relation = "NONE";
                }
                this.write(writer, fileName, tlink.getSource().getId(), tlink.getTarget().getId(), relation);
            }
        }
    }

    private static interface AttributeGetter<T extends Anchor> {
        public List<Attribute> getAttributes(T var1);
    }

    private static class Attribute {
        public String name;
        public Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

