/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.impl.push.DynamicResourceRegistry;
import org.icefaces.impl.push.http.DynamicResource;
import org.icefaces.impl.push.http.DynamicResourceLinker;
import org.icefaces.impl.util.Base64;
import org.icefaces.impl.util.Util;
import org.icefaces.util.EnvUtils;

public class DynamicResourceDispatcher
extends ResourceHandlerWrapper
implements DynamicResourceRegistry {
    private static Logger log = Logger.getLogger("org.icefaces.resourcedispatcher");
    private static final Pattern ICEfacesBridgeRequestPattern = Pattern.compile(".*\\.icefaces\\.jsf$");
    private static final Pattern ICEfacesResourceRequestPattern = Pattern.compile(".*/icefaces/.*");
    private static final String RESOURCE_PREFIX = "/icefaces/resource";
    private static final DynamicResourceLinker.Handler NOOPHandler = new DynamicResourceLinker.Handler(){

        public void linkWith(DynamicResourceLinker linker) {
        }
    };
    private HashMap mappings = new HashMap();
    private ResourceHandler wrapped;

    public DynamicResourceDispatcher(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.getApplicationMap().put(DynamicResourceDispatcher.class.getName(), this);
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        String path = this.getFullPath(externalContext);
        if (!this.shouldHandle(path)) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        for (Mapping mapping : this.mappings.values()) {
            if (mapping == null || !mapping.matches(path)) continue;
            mapping.handleResourceRequest(facesContext);
            return;
        }
        externalContext.responseSendError(404, "Could not find requested dynamic resource.");
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String path = this.getFullPath(externalContext);
        if (this.shouldHandle(path)) {
            return true;
        }
        return this.wrapped.isResourceRequest(facesContext);
    }

    private String getFullPath(ExternalContext externalContext) {
        String path = externalContext.getRequestServletPath();
        String pathInfo = externalContext.getRequestPathInfo();
        if (null != pathInfo) {
            path = path + pathInfo;
        }
        return path;
    }

    public Resource createResource(String resourceName) {
        String resourcePart = resourceName;
        if (resourceName.contains("?")) {
            int queryIndex = resourceName.indexOf("?");
            resourcePart = resourceName.substring(0, queryIndex);
        }
        return this.wrapped.createResource(resourcePart);
    }

    private boolean shouldHandle(String path) {
        if (null == path) {
            return false;
        }
        return ICEfacesBridgeRequestPattern.matcher(path).find() || ICEfacesResourceRequestPattern.matcher(path).find();
    }

    public URI registerResource(DynamicResource resource) {
        return this.registerResource(resource, NOOPHandler);
    }

    public URI registerResource(DynamicResource resource, DynamicResourceLinker.Handler handler) {
        String dispatchFilename;
        String uriFilename;
        if (handler == null) {
            handler = NOOPHandler;
        }
        FileNameOption options = new FileNameOption();
        try {
            resource.withOptions(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = options.getFileName();
        if (filename == null || filename.trim().equals("")) {
            uriFilename = "";
            dispatchFilename = "";
        } else {
            dispatchFilename = DynamicResourceDispatcher.convertToEscapedUnicode(filename);
            try {
                uriFilename = URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                uriFilename = filename;
                log.info(e.getMessage());
            }
        }
        String name = "/icefaces/resource/" + DynamicResourceDispatcher.encode(resource) + "/";
        String fullName = name + uriFilename;
        this.dispatchOn(fullName, ".*" + name.replaceAll("\\/", "\\/") + dispatchFilename + "$", resource);
        if (handler != NOOPHandler) {
            handler.linkWith(new RelativeResourceLinker(name));
        }
        return URI.create(fullName);
    }

    public void shutdown() {
        this.mappings.clear();
    }

    private static String encode(DynamicResource resource) {
        return Base64.encode(String.valueOf(resource.calculateDigest().hashCode()));
    }

    public static String convertToEscapedUnicode(String s) {
        char[] chars = s.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(chars.length * 6);
        String[] leadingZeros = new String[]{"0000", "000", "00", "0", ""};
        for (int i = 0; i < chars.length; ++i) {
            String hexStr = Integer.toHexString(chars[i]).toUpperCase();
            stringBuffer.append("\\u");
            stringBuffer.append(leadingZeros[hexStr.length()]);
            stringBuffer.append(hexStr);
        }
        return stringBuffer.toString();
    }

    private void dispatchOn(String name, String expression, DynamicResource resource) {
        if (this.mappings.get(name) == null) {
            this.mappings.put(name, new Mapping(expression, resource));
        }
    }

    private class Mapping {
        Pattern pattern;
        private ResourceServer server;

        private Mapping(String expression, DynamicResource resource) {
            this.pattern = Pattern.compile(expression);
            this.server = new ResourceServer(resource);
        }

        public boolean matches(String path) {
            return this.pattern.matcher(path).find();
        }

        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            this.server.handleResourceRequest(facesContext);
        }
    }

    public static interface ExtendedResourceOptions
    extends DynamicResource.Options {
        public void setContentDispositionFileName(String var1);
    }

    private class FileNameOption
    implements DynamicResource.Options {
        private String fileName;

        private FileNameOption() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setAsAttachement() {
        }

        public void setExpiresBy(Date date) {
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setLastModified(Date date) {
        }

        public void setMimeType(String mimeType) {
        }
    }

    private class RelativeResourceLinker
    implements DynamicResourceLinker {
        private final String name;

        public RelativeResourceLinker(String name) {
            this.name = name;
        }

        public void registerRelativeResource(String path, DynamicResource relativeResource) {
            String fullName = this.name + path;
            String pathExpression = fullName.replaceAll("\\/", "\\/").replaceAll("\\.", "\\.");
            DynamicResourceDispatcher.this.dispatchOn(fullName, ".*" + pathExpression + "$", relativeResource);
        }
    }

    private class ResourceServer {
        private final Date lastModified = new Date();
        private final DynamicResource resource;

        public ResourceServer(DynamicResource resource) {
            this.resource = resource;
        }

        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            ExternalContext externalContext = facesContext.getExternalContext();
            try {
                Date modifiedSince = Util.HTTP_DATE.parse((String)externalContext.getRequestHeaderMap().get("If-Modified-Since"));
                if (this.lastModified.getTime() > modifiedSince.getTime() + 1000L) {
                    this.respond(facesContext);
                } else {
                    externalContext.setResponseStatus(304);
                    externalContext.setResponseHeader("ETag", DynamicResourceDispatcher.encode(this.resource));
                    externalContext.setResponseHeader("Date", Util.HTTP_DATE.format(new Date()));
                    externalContext.setResponseHeader("Last-Modified", Util.HTTP_DATE.format(this.lastModified));
                }
            }
            catch (Exception e) {
                this.respond(facesContext);
            }
        }

        public void respond(FacesContext facesContext) throws IOException {
            InputStream inputStream;
            ExternalContext externalContext = facesContext.getExternalContext();
            ResourceOptions options = new ResourceOptions();
            this.resource.withOptions(options);
            if (options.mimeType == null && options.fileName != null) {
                options.mimeType = externalContext.getMimeType(options.fileName);
            }
            externalContext.setResponseHeader("ETag", DynamicResourceDispatcher.encode(this.resource));
            externalContext.setResponseHeader("Cache-Control", "public");
            externalContext.setResponseHeader("Content-Type", options.mimeType);
            externalContext.setResponseHeader("Last-Modified", Util.HTTP_DATE.format(options.lastModified));
            if (options.expiresBy != null) {
                externalContext.setResponseHeader("Expires", Util.HTTP_DATE.format(options.expiresBy));
            }
            if (options.attachement && options.contentDispositionFileName != null) {
                externalContext.setResponseHeader("Content-Disposition", "attachment; filename" + options.contentDispositionFileName);
            }
            if ((inputStream = this.resource.open()) == null) {
                throw new IOException("Resource of type " + this.resource.getClass().getName() + "[digest: " + this.resource.calculateDigest() + "; mime-type: " + options.mimeType + (options.attachement ? "; attachment: " + options.fileName : "") + "] returned a null input stream.");
            }
            InputStream in = this.resource.open();
            OutputStream out = externalContext.getResponseOutputStream();
            try {
                if (Util.acceptGzip(externalContext) && EnvUtils.isCompressResources(facesContext) && Util.shouldCompress(options.mimeType)) {
                    externalContext.setResponseHeader("Content-Encoding", "gzip");
                    Util.compressStream(in, out);
                } else {
                    Util.copyStream(in, out);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to serve resource " + externalContext.getRequestServletPath(), e);
            }
        }

        public void shutdown() {
        }

        private class ResourceOptions
        implements ExtendedResourceOptions {
            private Date lastModified = new Date();
            private Date expiresBy;
            private String mimeType;
            private String fileName;
            private boolean attachement;
            private String contentDispositionFileName;

            private ResourceOptions() {
            }

            public void setMimeType(String type) {
                this.mimeType = type;
            }

            public void setLastModified(Date date) {
                this.lastModified = date;
            }

            public void setFileName(String name) {
                this.fileName = name;
            }

            public void setExpiresBy(Date date) {
                this.expiresBy = date;
            }

            public void setAsAttachement() {
                this.attachement = true;
            }

            public void setContentDispositionFileName(String contentDispositionFileName) {
                this.contentDispositionFileName = contentDispositionFileName;
            }
        }
    }
}

