/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessagesRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.MESSAGESMESSAGES);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessages)component).getFor();
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            writer.startElement("div", component);
            if (mustRender) {
                this.writeIdAttributeIfNecessary(context, writer, component);
            } else {
                writer.writeAttribute("id", (Object)component.getClientId(), "id");
            }
            writer.endElement("div");
            return;
        }
        String layout = (String)component.getAttributes().get("layout");
        boolean showSummary = messages.isShowSummary();
        boolean showDetail = messages.isShowDetail();
        String styleClass = (String)component.getAttributes().get("styleClass");
        boolean wroteTable = false;
        writer.startElement("div", component);
        if (!mustRender) {
            writer.writeAttribute("id", (Object)component.getClientId(), "id");
        } else {
            this.writeIdAttributeIfNecessary(context, writer, component);
        }
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", component);
            wroteTable = true;
        } else {
            writer.startElement("ul", component);
        }
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
        while (messageIter.hasNext()) {
            Object val;
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            curMessage.rendered();
            String severityStyle = null;
            String severityStyleClass = null;
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            String string = detail = null != detail ? detail : summary;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyle = (String)component.getAttributes().get("infoStyle");
                severityStyleClass = (String)component.getAttributes().get("infoClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyle = (String)component.getAttributes().get("warnStyle");
                severityStyleClass = (String)component.getAttributes().get("warnClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyle = (String)component.getAttributes().get("errorStyle");
                severityStyleClass = (String)component.getAttributes().get("errorClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyle = (String)component.getAttributes().get("fatalStyle");
                severityStyleClass = (String)component.getAttributes().get("fatalClass");
            }
            if (wroteTable) {
                writer.startElement("tr", component);
            } else {
                writer.startElement("li", component);
            }
            if (severityStyle != null) {
                writer.writeAttribute("style", (Object)severityStyle, "style");
            }
            if (severityStyleClass != null) {
                styleClass = severityStyleClass;
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (wroteTable) {
                writer.startElement("td", component);
            }
            boolean isTooltip = (val = component.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                writer.startElement("span", component);
                String title = (String)component.getAttributes().get("title");
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", (Object)summary, "title");
                }
                writer.flush();
                writer.writeText((Object)"\t", component, null);
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText((Object)"\t", component, null);
                writer.writeText((Object)summary, component, null);
                writer.writeText((Object)" ", component, null);
            }
            if (showDetail) {
                writer.writeText((Object)detail, component, null);
            }
            if (wroteTooltip) {
                writer.endElement("span");
            }
            if (wroteTable) {
                writer.endElement("td");
                writer.endElement("tr");
                continue;
            }
            writer.endElement("li");
        }
        if (wroteTable) {
            writer.endElement("table");
        } else {
            writer.endElement("ul");
        }
        writer.endElement("div");
    }
}

