/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.AdjMarker;
import edu.mit.jwi.item.ILexFile;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVerbFrame;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Word;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Synset
implements ISynset {
    private final ISynsetID id;
    private final String gloss;
    private final ILexFile lexFile;
    private final List<IWord> words;
    private final boolean isAdjSat;
    private final boolean isAdjHead;
    private final List<ISynsetID> related;
    private final Map<IPointer, List<ISynsetID>> relatedMap;

    public Synset(ISynsetID id, ILexFile lexFile, boolean isAdjSat, boolean isAdjHead, String gloss, List<IWordBuilder> wordBuilders, Map<IPointer, ? extends List<ISynsetID>> ids) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (lexFile == null) {
            throw new NullPointerException();
        }
        if (gloss == null) {
            throw new NullPointerException();
        }
        if (wordBuilders == null) {
            throw new NullPointerException();
        }
        if (wordBuilders.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (isAdjSat && isAdjHead) {
            throw new IllegalArgumentException();
        }
        if ((isAdjSat || isAdjHead) && lexFile.getNumber() != 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.lexFile = lexFile;
        this.gloss = gloss;
        this.isAdjSat = isAdjSat;
        this.isAdjHead = isAdjHead;
        ArrayList<IWord> words = new ArrayList<IWord>(wordBuilders.size());
        for (IWordBuilder wordBuilder : wordBuilders) {
            words.add(wordBuilder.toWord(this));
        }
        this.words = Collections.unmodifiableList(words);
        LinkedHashSet hiddenSet = null;
        HashMap hiddenMap = null;
        if (ids != null) {
            hiddenSet = new LinkedHashSet();
            hiddenMap = new HashMap(ids.size());
            for (Map.Entry<IPointer, ? extends List<ISynsetID>> entry : ids.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                hiddenMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
                hiddenSet.addAll(entry.getValue());
            }
        }
        this.related = hiddenSet != null && !hiddenSet.isEmpty() ? Collections.unmodifiableList(new ArrayList(hiddenSet)) : Collections.emptyList();
        this.relatedMap = hiddenMap != null && !hiddenMap.isEmpty() ? Collections.unmodifiableMap(hiddenMap) : Collections.emptyMap();
    }

    @Override
    public ISynsetID getID() {
        return this.id;
    }

    @Override
    public int getOffset() {
        return this.id.getOffset();
    }

    @Override
    public POS getPOS() {
        return this.id.getPOS();
    }

    @Override
    public int getType() {
        POS pos = this.getPOS();
        if (pos != POS.ADJECTIVE) {
            return pos.getNumber();
        }
        return this.isAdjectiveSatellite() ? 5 : 3;
    }

    @Override
    public String getGloss() {
        return this.gloss;
    }

    @Override
    public List<IWord> getWords() {
        return this.words;
    }

    @Override
    public IWord getWord(int wordNumber) {
        return this.words.get(wordNumber - 1);
    }

    @Override
    public ILexFile getLexicalFile() {
        return this.lexFile;
    }

    @Override
    public Map<IPointer, List<ISynsetID>> getRelatedMap() {
        return this.relatedMap;
    }

    @Override
    public List<ISynsetID> getRelatedSynsets(IPointer type) {
        if (this.relatedMap == null) {
            return Collections.emptyList();
        }
        List<ISynsetID> result = this.relatedMap.get(type);
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public List<ISynsetID> getRelatedSynsets() {
        return this.related;
    }

    @Override
    public boolean isAdjectiveSatellite() {
        return this.isAdjSat;
    }

    @Override
    public boolean isAdjectiveHead() {
        return this.isAdjHead;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.gloss.hashCode();
        result = 31 * result + (this.isAdjSat ? 1231 : 1237);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + ((Object)this.words).hashCode();
        result = 31 * result + ((Object)this.relatedMap).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Synset)) {
            return false;
        }
        Synset other = (Synset)obj;
        if (!this.id.equals(other.getID())) {
            return false;
        }
        if (!((Object)this.words).equals(other.getWords())) {
            return false;
        }
        if (!this.gloss.equals(other.getGloss())) {
            return false;
        }
        if (this.isAdjSat != other.isAdjectiveSatellite()) {
            return false;
        }
        return ((Object)this.relatedMap).equals(other.getRelatedMap());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SYNSET{");
        sb.append(this.id.toString());
        sb.append(" : Words[");
        for (IWord word : this.words) {
            sb.append(word.toString());
            sb.append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "]}");
        return sb.toString();
    }

    public static String zeroFillOffset(int offset) {
        Synset.checkOffset(offset);
        StringBuilder sb = new StringBuilder(8);
        String offsetStr = Integer.toString(offset);
        int numZeros = 8 - offsetStr.length();
        for (int i = 0; i < numZeros; ++i) {
            sb.append('0');
        }
        sb.append(offsetStr);
        return sb.toString();
    }

    public static int checkOffset(int offset) {
        if (!Synset.isLegalOffset(offset)) {
            throw new IllegalArgumentException("'" + offset + "' is not a valid offset; offsets must be in the closed range [0,99999999]");
        }
        return offset;
    }

    public static boolean isLegalOffset(int offset) {
        if (offset < 0) {
            return false;
        }
        return offset <= 99999999;
    }

    public static class WordBuilder
    implements IWordBuilder {
        private final int num;
        protected final int lexID;
        private final String lemma;
        private final AdjMarker marker;
        private final Map<IPointer, ArrayList<IWordID>> relatedWords = new HashMap<IPointer, ArrayList<IWordID>>();
        private final ArrayList<IVerbFrame> verbFrames = new ArrayList();

        public WordBuilder(int num, String lemma, int lexID, AdjMarker marker) {
            this.num = num;
            this.lemma = lemma;
            this.lexID = lexID;
            this.marker = marker;
        }

        @Override
        public void addRelatedWord(IPointer type, IWordID id) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (id == null) {
                throw new NullPointerException();
            }
            ArrayList<IWordID> words = this.relatedWords.get(type);
            if (words == null) {
                words = new ArrayList();
                this.relatedWords.put(type, words);
            }
            words.add(id);
        }

        @Override
        public void addVerbFrame(IVerbFrame frame) {
            if (frame == null) {
                throw new NullPointerException();
            }
            this.verbFrames.add(frame);
        }

        @Override
        public IWord toWord(ISynset synset) {
            return new Word(synset, this.num, this.lemma, this.lexID, this.marker, this.verbFrames, this.relatedWords);
        }
    }

    public static interface IWordBuilder {
        public IWord toWord(ISynset var1);

        public void addVerbFrame(IVerbFrame var1);

        public void addRelatedWord(IPointer var1, IWordID var2);
    }
}

