/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cr;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.assertion.cr.ArgumentInfo;
import org.apache.ctakes.assertion.cr.Span;
import org.apache.ctakes.assertion.cr.XMLReader;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.Mapper;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@PipeBitInfo(name="Knowtator XML Reader (Generic)", description="Read named entity annotations from knowtator xml files into the CAS.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.GENERIC_RELATION})
public class GoldEntityAndAttributeReader
extends JCasAnnotator_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static String inputDirectory;
    public int identifiedAnnotationId;
    private boolean VERBOSE = true;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        inputDirectory = (String)aContext.getConfigParameterValue(PARAM_INPUTDIR);
        this.identifiedAnnotationId = 0;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Document document;
        JCas initView;
        try {
            initView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        String goldFilePath = inputDirectory + DocumentIDAnnotationUtil.getDocumentID((JCas)jCas) + ".knowtator.xml";
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(new File(goldFilePath));
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        HashMap<String, ArrayList<Span>> allMentions = XMLReader.getEntityMentions(document);
        HashMap<String, String> entityTypes = XMLReader.getEntityTypes(document);
        HashMap<String, List<String>> mentionAttr = XMLReader.getEntityAttributes(document);
        String[] complexSlotMention = new String[]{"complexSlotMention"};
        HashMap<String, ArgumentInfo> attrPtr = XMLReader.getAttributes(document, complexSlotMention);
        HashMap<String, ArgumentInfo> attrs = XMLReader.getAttributes(document);
        System.out.println("What's in attrPtr -- the mention-attribute ids to attributes....");
        for (Map.Entry<String, ArgumentInfo> e : attrPtr.entrySet()) {
            System.out.println("attrPtr: " + e.getKey() + " with role " + e.getValue().role + " and value " + e.getValue().value);
        }
        System.out.println("\nWhat's in attrs -- the knowtator attribute ids....");
        for (Map.Entry<String, ArgumentInfo> e : attrs.entrySet()) {
            System.out.println("attrs: " + e.getKey() + " with role " + e.getValue().role + " and value " + e.getValue().value);
        }
        HashMap<String, ArrayList<Span>> neMentions = this.filterToNamedEntitiesOnly(allMentions, entityTypes);
        for (Map.Entry<String, ArrayList<Span>> mention : neMentions.entrySet()) {
            String mentionId = mention.getKey();
            Span first = null;
            Span last = null;
            first = mention.getValue().get(0);
            last = mention.getValue().get(mention.getValue().size() - 1);
            int type = Mapper.getEntityTypeId((String)entityTypes.get(mentionId));
            Object eMention = type == 6 ? new EntityMention(initView, first.start, last.end) : (type == 2 || type == 1 || type == 3 || type == 5 || type == 6 ? new EventMention(initView, first.start, last.end) : new IdentifiedAnnotation(initView, first.start, last.end));
            eMention.setTypeID(Mapper.getEntityTypeId((String)entityTypes.get(mentionId)));
            eMention.setId(this.identifiedAnnotationId++);
            eMention.setDiscoveryTechnique(2);
            eMention.setConfidence(1.0f);
            if (mentionId.endsWith("4351")) {
                System.out.println();
            }
            List<ArgumentInfo> assocAttributes = this.getLeafAttributes(mentionId, mentionAttr, attrPtr, attrs, new ArrayList<ArgumentInfo>());
            for (ArgumentInfo a : assocAttributes) {
                this.checkForAttrValue((IdentifiedAnnotation)eMention, a.role, a.value);
            }
            eMention.addToIndexes();
        }
    }

    private List<ArgumentInfo> getLeafAttributes(String id, HashMap<String, List<String>> mentionAttr, HashMap<String, ArgumentInfo> attrPtr, HashMap<String, ArgumentInfo> attrs, List<ArgumentInfo> output) {
        if (mentionAttr.containsKey(id)) {
            for (String attrId : mentionAttr.get(id)) {
                ArgumentInfo a;
                if (attrPtr.containsKey(attrId)) {
                    a = attrPtr.get(attrId);
                    if (this.isRelationArgument(attrPtr.get((Object)attrId).role)) continue;
                    this.getLeafAttributes(attrPtr.get((Object)attrId).value, mentionAttr, attrPtr, attrs, output);
                    continue;
                }
                if (!attrs.containsKey(attrId)) continue;
                a = attrs.get(attrId);
                if (this.isRelationArgument(attrs.get((Object)attrId).role)) continue;
                output.add(attrs.get(attrId));
            }
        } else if (attrPtr.containsKey(id)) {
            if (!attrPtr.get((Object)id).role.equals("Related_to_CU") & !attrPtr.get((Object)id).role.equals("Argument_CU")) {
                this.getLeafAttributes(attrPtr.get((Object)id).value, mentionAttr, attrPtr, attrs, output);
            }
        } else if (attrs.containsKey(id) && !attrs.get((Object)id).role.equals("Related_to_CU") && !attrs.get((Object)id).role.equals("Argument_CU")) {
            output.add(attrs.get(id));
        }
        return output;
    }

    private boolean isRelationArgument(String role) {
        if (GoldEntityAndAttributeReader.normalizeRoleName(role).equals("Related_to")) {
            return true;
        }
        return GoldEntityAndAttributeReader.normalizeRoleName(role).equals("Argument");
    }

    private void checkForAttrValue(IdentifiedAnnotation eMention, String role, String value) {
        if (role.contains("_normalization")) {
            if (role.startsWith("conditional")) {
                eMention.setConditional(Boolean.valueOf(value).booleanValue());
            } else if (role.startsWith("generic")) {
                eMention.setGeneric(Boolean.valueOf(value).booleanValue());
            } else if (role.startsWith("negation_indicator")) {
                if (value.equals("negation_present")) {
                    eMention.setPolarity(-1);
                } else {
                    eMention.setPolarity(1);
                }
            } else if (role.startsWith("subject")) {
                eMention.setSubject(value);
            } else if (role.startsWith("uncertainty_indicator")) {
                if (value.equals("indicator_present")) {
                    eMention.setUncertainty(1);
                } else {
                    eMention.setUncertainty(0);
                }
            } else if (role.startsWith("generic")) {
                eMention.setGeneric(Boolean.valueOf(value).booleanValue());
            }
        }
    }

    private HashMap<String, ArrayList<Span>> filterToNamedEntitiesOnly(HashMap<String, ArrayList<Span>> entityMentions, HashMap<String, String> entityTypes) {
        HashMap<String, ArrayList<Span>> newEntityMentions = new HashMap<String, ArrayList<Span>>();
        for (Map.Entry<String, String> etype : entityTypes.entrySet()) {
            if (!etype.getValue().equals("Anatomical_site") && !etype.getValue().equals("Disease_Disorder") && !etype.getValue().equals("Lab") && !etype.getValue().equals("Medications") && !etype.getValue().equals("Procedure") && !etype.getValue().equals("Sign_symptom") || !entityMentions.containsKey(etype.getKey())) continue;
            newEntityMentions.put(etype.getKey(), entityMentions.get(etype.getKey()));
        }
        return newEntityMentions;
    }

    private boolean filterToNamedEntitiesOnly(HashMap<String, ArrayList<Span>> entityMentions, String typeKey, String typeValue) {
        return (typeValue.toLowerCase().equals("Anatomical_site") || typeValue.toLowerCase().equals("Disease_Disorder") || typeValue.toLowerCase().equals("Lab") || typeValue.toLowerCase().equals("Medications") || typeValue.toLowerCase().equals("Procedure") || typeValue.toLowerCase().equals("Sign_symptom")) && entityMentions.containsKey(typeKey);
    }

    private static String normalizeRoleName(String role) {
        if (role.equals("Argument_CU")) {
            return "Argument";
        }
        if (role.equals("Related_to_CU")) {
            return "Related_to";
        }
        return role;
    }
}

