/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.eval;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.eval.util.ConfusionMatrix;

public class AnnotationStatisticsCompact<OUTCOME_TYPE extends Comparable<? super OUTCOME_TYPE>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Multiset<OUTCOME_TYPE> referenceOutcomes = HashMultiset.create();
    private Multiset<OUTCOME_TYPE> predictedOutcomes = HashMultiset.create();
    private Multiset<OUTCOME_TYPE> correctOutcomes = HashMultiset.create();
    private ConfusionMatrix<OUTCOME_TYPE> confusionMatrix = new ConfusionMatrix();

    public static <ANNOTATION_TYPE extends Annotation> Function<ANNOTATION_TYPE, Span> annotationToSpan() {
        return new Function<ANNOTATION_TYPE, Span>(){

            public Span apply(ANNOTATION_TYPE annotation) {
                return new Span((Annotation)annotation);
            }
        };
    }

    public static <ANNOTATION_TYPE extends TOP> Function<ANNOTATION_TYPE, String> annotationToFeatureValue(final String featureName) {
        return new Function<ANNOTATION_TYPE, String>(){

            public String apply(ANNOTATION_TYPE annotation) {
                Feature feature = annotation.getType().getFeatureByBaseName(featureName);
                return annotation.getFeatureValueAsString(feature);
            }
        };
    }

    public static <ANNOTATION_TYPE, OUTCOME_TYPE> Function<ANNOTATION_TYPE, OUTCOME_TYPE> annotationToNull() {
        return new Function<ANNOTATION_TYPE, OUTCOME_TYPE>(){

            public OUTCOME_TYPE apply(ANNOTATION_TYPE annotation) {
                return null;
            }
        };
    }

    public static <OUTCOME_TYPE extends Comparable<? super OUTCOME_TYPE>> AnnotationStatisticsCompact<OUTCOME_TYPE> addAll(Iterable<AnnotationStatisticsCompact<OUTCOME_TYPE>> statistics) {
        AnnotationStatisticsCompact<OUTCOME_TYPE> result = new AnnotationStatisticsCompact<OUTCOME_TYPE>();
        for (AnnotationStatisticsCompact<OUTCOME_TYPE> item : statistics) {
            result.addAll(item);
        }
        return result;
    }

    public <ANNOTATION_TYPE extends Annotation> void add(Collection<? extends ANNOTATION_TYPE> referenceAnnotations, Collection<? extends ANNOTATION_TYPE> predictedAnnotations) {
        this.add(referenceAnnotations, predictedAnnotations, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToNull());
    }

    public <ANNOTATION_TYPE, SPAN_TYPE> void add(Collection<? extends ANNOTATION_TYPE> referenceAnnotations, Collection<? extends ANNOTATION_TYPE> predictedAnnotations, Function<ANNOTATION_TYPE, SPAN_TYPE> annotationToSpan, Function<ANNOTATION_TYPE, OUTCOME_TYPE> annotationToOutcome) {
        HashMap<Object, Object> referenceSpanOutcomes = new HashMap<Object, Object>();
        for (Object ann : referenceAnnotations) {
            referenceSpanOutcomes.put(annotationToSpan.apply(ann), annotationToOutcome.apply(ann));
        }
        HashMap<Object, Object> predictedSpanOutcomes = new HashMap<Object, Object>();
        for (Object ann : predictedAnnotations) {
            predictedSpanOutcomes.put(annotationToSpan.apply(ann), annotationToOutcome.apply(ann));
        }
        this.referenceOutcomes.addAll(referenceSpanOutcomes.values());
        this.predictedOutcomes.addAll(predictedSpanOutcomes.values());
        HashSet intersection = new HashSet();
        intersection.addAll(referenceSpanOutcomes.keySet());
        intersection.retainAll(predictedSpanOutcomes.keySet());
        for (Object span : intersection) {
            Comparable systemOutcome;
            Comparable goldOutcome = (Comparable)referenceSpanOutcomes.get(span);
            if (!Objects.equal((Object)goldOutcome, (Object)(systemOutcome = (Comparable)predictedSpanOutcomes.get(span)))) continue;
            this.correctOutcomes.add((Object)goldOutcome);
        }
        HashSet union = new HashSet();
        union.addAll(referenceSpanOutcomes.keySet());
        union.addAll(predictedSpanOutcomes.keySet());
        for (Object span : union) {
            Comparable goldOutcome = (Comparable)referenceSpanOutcomes.get(span);
            Comparable systemOutcome = (Comparable)predictedSpanOutcomes.get(span);
            this.confusionMatrix.add(goldOutcome, systemOutcome);
        }
    }

    public void addAll(AnnotationStatisticsCompact<OUTCOME_TYPE> that) {
        this.referenceOutcomes.addAll(that.referenceOutcomes);
        this.predictedOutcomes.addAll(that.predictedOutcomes);
        this.correctOutcomes.addAll(that.correctOutcomes);
        this.confusionMatrix.add(that.confusionMatrix);
    }

    public int countCorrectOutcomes() {
        return this.correctOutcomes.size();
    }

    public int countCorrectOutcomes(OUTCOME_TYPE outcome) {
        return this.correctOutcomes.count(outcome);
    }

    public int countPredictedOutcomes() {
        return this.predictedOutcomes.size();
    }

    public int countPredictedOutcomes(OUTCOME_TYPE outcome) {
        return this.predictedOutcomes.count(outcome);
    }

    public int countReferenceOutcomes() {
        return this.referenceOutcomes.size();
    }

    public int countReferenceOutcomes(OUTCOME_TYPE outcome) {
        return this.referenceOutcomes.count(outcome);
    }

    public int countFalseNegatives(OUTCOME_TYPE ... positiveOutcomes) {
        int numPredictedOutcomes;
        int numReferenceOutcomes = this.countReferenceOutcomes();
        if (numReferenceOutcomes != (numPredictedOutcomes = this.countPredictedOutcomes())) {
            throw new IllegalStateException(String.format("Expected number equal number of references outcomes and predicted outcomes.  Had reference outcomes=%d, predicted outcomes=%d", numReferenceOutcomes, numPredictedOutcomes, this.countPredictedOutcomes()));
        }
        int totalFalseNegatives = 0;
        for (OUTCOME_TYPE positiveOutcome : positiveOutcomes) {
            totalFalseNegatives += this.countReferenceOutcomes(positiveOutcome) - this.countCorrectOutcomes(positiveOutcome);
        }
        return totalFalseNegatives;
    }

    public int countFalsePositives(OUTCOME_TYPE ... positiveOutcomes) {
        int numPredictedOutcomes;
        int numReferenceOutcomes = this.countReferenceOutcomes();
        if (numReferenceOutcomes != (numPredictedOutcomes = this.countPredictedOutcomes())) {
            throw new IllegalStateException(String.format("Expected number equal number of references outcomes and predicted outcomes.  Had reference outcomes=%d, predicted outcomes=%d", numReferenceOutcomes, numPredictedOutcomes, this.countPredictedOutcomes()));
        }
        int totalFalsePositives = 0;
        for (OUTCOME_TYPE positiveOutcome : positiveOutcomes) {
            totalFalsePositives += this.countPredictedOutcomes(positiveOutcome) - this.countCorrectOutcomes(positiveOutcome);
        }
        return totalFalsePositives;
    }

    public int countTrueNegatives(OUTCOME_TYPE ... positiveOutcomes) {
        int numPredictedOutcomes;
        int numReferenceOutcomes = this.countReferenceOutcomes();
        if (numReferenceOutcomes != (numPredictedOutcomes = this.countPredictedOutcomes())) {
            throw new IllegalStateException(String.format("Expected number equal number of references outcomes and predicted outcomes.  Had reference outcomes=%d, predicted outcomes=%d", numReferenceOutcomes, numPredictedOutcomes, this.countPredictedOutcomes()));
        }
        int totalTrueNegatives = this.countCorrectOutcomes();
        for (OUTCOME_TYPE positiveOutcome : positiveOutcomes) {
            totalTrueNegatives -= this.countCorrectOutcomes(positiveOutcome);
        }
        return totalTrueNegatives;
    }

    public int countTruePositives(OUTCOME_TYPE ... positiveOutcomes) {
        int numPredictedOutcomes;
        int numReferenceOutcomes = this.countReferenceOutcomes();
        if (numReferenceOutcomes != (numPredictedOutcomes = this.countPredictedOutcomes())) {
            throw new IllegalStateException(String.format("Expected number equal number of references outcomes and predicted outcomes.  Had reference outcomes=%d, predicted outcomes=%d", numReferenceOutcomes, numPredictedOutcomes, this.countPredictedOutcomes()));
        }
        int totalTruePositives = 0;
        for (OUTCOME_TYPE positiveOutcome : positiveOutcomes) {
            totalTruePositives += this.countCorrectOutcomes(positiveOutcome);
        }
        return totalTruePositives;
    }

    public ConfusionMatrix<OUTCOME_TYPE> confusions() {
        return this.confusionMatrix;
    }

    public double precision() {
        int nSystem = this.countPredictedOutcomes();
        return nSystem == 0 ? 1.0 : (double)this.countCorrectOutcomes() / (double)nSystem;
    }

    public double precision(OUTCOME_TYPE outcome) {
        int nSystem = this.countPredictedOutcomes(outcome);
        return nSystem == 0 ? 1.0 : (double)this.countCorrectOutcomes(outcome) / (double)nSystem;
    }

    public double recall() {
        int nGold = this.countReferenceOutcomes();
        return nGold == 0 ? 1.0 : (double)this.countCorrectOutcomes() / (double)nGold;
    }

    public double recall(OUTCOME_TYPE outcome) {
        int nGold = this.countReferenceOutcomes(outcome);
        return nGold == 0 ? 1.0 : (double)this.countCorrectOutcomes(outcome) / (double)nGold;
    }

    public double f(double beta) {
        double p = this.precision();
        double r = this.recall();
        double num = (1.0 + beta * beta) * p * r;
        double den = beta * beta * p + r;
        return den == 0.0 ? 0.0 : num / den;
    }

    public double f(double beta, OUTCOME_TYPE outcome) {
        double p = this.precision(outcome);
        double r = this.recall(outcome);
        double num = (1.0 + beta * beta) * p * r;
        double den = beta * beta * p + r;
        return den == 0.0 ? 0.0 : num / den;
    }

    public double f1() {
        return this.f(1.0);
    }

    public double f1(OUTCOME_TYPE outcome) {
        return this.f(1.0, outcome);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("P\tR\tF1\t#gold\t#system\t#correct\n");
        result.append(String.format("%.3f\t%.3f\t%.3f\t%d\t%d\t%d\tOVERALL\n", this.precision(), this.recall(), this.f1(), this.referenceOutcomes.size(), this.predictedOutcomes.size(), this.correctOutcomes.size()));
        ArrayList outcomes = new ArrayList(this.referenceOutcomes.elementSet());
        if (outcomes.size() > 1) {
            Collections.sort(outcomes);
            for (Comparable outcome : outcomes) {
                result.append(String.format("%.3f\t%.3f\t%.3f\t%d\t%d\t%d\t%s\n", this.precision(outcome), this.recall(outcome), this.f1(outcome), this.referenceOutcomes.count((Object)outcome), this.predictedOutcomes.count((Object)outcome), this.correctOutcomes.count((Object)outcome), outcome));
            }
        }
        return result.toString();
    }

    public String toTsv() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("%s\t%.3f\t%s\t%.3f\t%s\t%.3f\t", "All", this.precision(), "All", this.recall(), "All", this.f1()));
        ArrayList outcomes = new ArrayList(this.referenceOutcomes.elementSet());
        if (outcomes.size() > 1) {
            Collections.sort(outcomes);
            for (Comparable outcome : outcomes) {
                result.append(String.format("%s\t%.3f\t%s\t%.3f\t%s\t%.3f\t", outcome, this.precision(outcome), outcome, this.recall(outcome), outcome, this.f1(outcome)));
            }
        }
        result.append("\n");
        return result.toString();
    }

    private static class Span {
        public int end;
        public int begin;

        public Span(Annotation annotation) {
            this.begin = annotation.getBegin();
            this.end = annotation.getEnd();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.begin, this.end});
        }

        public boolean equals(Object obj) {
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Span that = (Span)obj;
            return this.begin == that.begin && this.end == that.end;
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
            helper.add("begin", (Object)this.begin);
            helper.add("end", (Object)this.end);
            return helper.toString();
        }
    }
}

