/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.eval;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.assertion.eval.XMIReader;
import org.apache.ctakes.assertion.util.AssertionConst;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.NoOpAnnotator;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

@PipeBitInfo(name="Gold View Merger", description="Read in gold annotations from XMI and create a view within the current CAS, and copy the gold annotations into the new view within the current CAS.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas
extends JCasAnnotator_ImplBase {
    static final Logger LOGGER = Logger.getLogger((String)MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.class.getName());
    private static final String dirWithGoldViews = AssertionConst.testDirectories.get("polarity");
    private static final File goldViewDir;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (!goldViewDir.exists()) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("Directory with gold view annotations not found:" + dirWithGoldViews));
        }
        if (!goldViewDir.isDirectory()) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("What is supposed to be a directory with gold view annotations is not a directory:" + dirWithGoldViews));
        }
        String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        JCas correspondingCasThatHasGoldAnnotations = MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.getCorrespondingCasThatHasGoldAnnotations(docId);
        JCas viewWithPreexistingGoldAnnotations = null;
        JCas newGoldView = null;
        viewWithPreexistingGoldAnnotations = MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.getViewWithGoldAnnotations(correspondingCasThatHasGoldAnnotations);
        newGoldView = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)"GoldView");
        try {
            newGoldView.setSofaDataString(jCas.getSofaDataString(), jCas.getSofaMimeType());
        }
        catch (CASRuntimeException e) {
            LOGGER.info((Object)"Warning, error setting sofa string - ignore if using TestAttributeModels");
        }
        int countCopied = 0;
        int countSkipped = 0;
        if (viewWithPreexistingGoldAnnotations == null) {
            throw new RuntimeException("viewWithPreexistingGoldAnnotations is null");
        }
        Collection annotations = JCasUtil.select((JCas)viewWithPreexistingGoldAnnotations, Annotation.class);
        LOGGER.debug((Object)("Found " + annotations.size() + " annotations."));
        for (Annotation a : annotations) {
            if (MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.isInstanceOfOneOfClassesToCopy(a)) {
                MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.copyAnnotation(a, newGoldView);
                ++countCopied;
                continue;
            }
            ++countSkipped;
        }
        LOGGER.debug((Object)("Copied " + countCopied + " gold annotations out of " + (countSkipped + countCopied) + " to cas, which now has " + newGoldView.getAnnotationIndex().size() + " indexed annotations in " + newGoldView.getViewName()));
        LOGGER.debug((Object)(" and has " + jCas.getAnnotationIndex().size() + " indexed annotations in " + jCas.getViewName()));
    }

    private static JCas getViewWithGoldAnnotations(JCas correspondingCasThatHasGoldAnnotations) {
        JCas viewWithPreexistingGoldAnnotations = null;
        try {
            viewWithPreexistingGoldAnnotations = correspondingCasThatHasGoldAnnotations.getView("GoldView");
        }
        catch (CASRuntimeException cASRuntimeException) {
        }
        catch (CASException cASException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (viewWithPreexistingGoldAnnotations == null) {
            viewWithPreexistingGoldAnnotations = correspondingCasThatHasGoldAnnotations;
            LOGGER.debug((Object)("Using view " + viewWithPreexistingGoldAnnotations.getViewName()));
            int n = viewWithPreexistingGoldAnnotations.getAnnotationIndex().size();
            LOGGER.debug((Object)("With " + n + " annotations"));
            if (n == 0) {
                Iterator iter = viewWithPreexistingGoldAnnotations.getCas().getViewIterator();
                while (iter.hasNext()) {
                    CAS cas = (CAS)iter.next();
                    LOGGER.debug((Object)("view " + cas.getViewName() + " has " + cas.getAnnotationIndex().size() + " indexed annotations."));
                }
                throw new RuntimeException("n==0");
            }
        }
        return viewWithPreexistingGoldAnnotations;
    }

    private static void copyAnnotation(Annotation goldAnnotation, JCas jcas) {
        if (!(goldAnnotation instanceof IdentifiedAnnotation)) {
            throw new RuntimeException("Unexpected class of object " + goldAnnotation.getClass());
        }
        IdentifiedAnnotation ia = new IdentifiedAnnotation(jcas);
        ia.setConditional(((IdentifiedAnnotation)goldAnnotation).getConditional());
        ia.setConfidence(((IdentifiedAnnotation)goldAnnotation).getConfidence());
        ia.setDiscoveryTechnique(((IdentifiedAnnotation)goldAnnotation).getDiscoveryTechnique());
        ia.setGeneric(((IdentifiedAnnotation)goldAnnotation).getGeneric());
        ia.setHistoryOf(((IdentifiedAnnotation)goldAnnotation).getHistoryOf());
        ia.setPolarity(((IdentifiedAnnotation)goldAnnotation).getPolarity());
        ia.setSegmentID(((IdentifiedAnnotation)goldAnnotation).getSegmentID());
        ia.setSentenceID(((IdentifiedAnnotation)goldAnnotation).getSentenceID());
        ia.setSubject(((IdentifiedAnnotation)goldAnnotation).getSubject());
        ia.setTypeID(((IdentifiedAnnotation)goldAnnotation).getTypeID());
        ia.setUncertainty(((IdentifiedAnnotation)goldAnnotation).getUncertainty());
        IdentifiedAnnotation newAnno = ia;
        newAnno.setBegin(goldAnnotation.getBegin());
        newAnno.setEnd(goldAnnotation.getEnd());
        newAnno.addToIndexes();
    }

    private static boolean isInstanceOfOneOfClassesToCopy(Annotation a) {
        if (a instanceof EventMention) {
            return true;
        }
        return a instanceof EntityMention;
    }

    private static JCas getCorrespondingCasThatHasGoldAnnotations(String docId) {
        File f = new File(goldViewDir, docId);
        if (!f.exists()) {
            f = new File(goldViewDir, docId + ".xml");
        }
        if (!f.exists()) {
            f = new File(goldViewDir, docId + ".xcas");
        }
        if (!f.exists()) {
            f = new File(goldViewDir, docId + ".xmi");
        }
        if (!f.exists()) {
            f = new File(goldViewDir, docId + ".xcas.xml");
        }
        if (!f.exists()) {
            f = new File(goldViewDir, docId + ".xmi.xml");
        }
        if (!f.exists()) {
            try {
                throw new RuntimeException("Unable to find file for doc ID " + docId + " in " + goldViewDir.getName() + " aka " + goldViewDir.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find file for doc ID " + docId + " in " + goldViewDir.getName());
            }
        }
        return MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.getJcas(f);
    }

    private static JCas getJcas(File f) {
        AggregateBuilder builder;
        CollectionReader cr;
        ArrayList<File> list = new ArrayList<File>();
        list.add(f);
        try {
            cr = MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.getCollectionReader(list);
            builder = new AggregateBuilder();
            TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
            AnalysisEngineDescription noOp = AnalysisEngineFactory.createEngineDescription(NoOpAnnotator.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[0]);
            builder.add(noOp, new String[0]);
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
        try {
            AnalysisEngine engine = builder.createAggregate();
            ArrayList<ResourceMetaData> metaData = new ArrayList<ResourceMetaData>();
            metaData.add(cr.getMetaData());
            metaData.add(engine.getMetaData());
            CAS cas = CasCreationUtils.createCas(metaData);
            if (cr.hasNext()) {
                cr.getNext(cas);
                engine.process(cas);
            }
            engine.collectionProcessComplete();
            return cas.getJCas();
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
        catch (UIMAException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CollectionReader getCollectionReader(List<File> items) throws ResourceInitializationException {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath((String[])new String[0]), (Object[])new Object[]{"files", paths});
    }

    static {
        LOGGER.info((Object)("Copying information from gold views in " + dirWithGoldViews));
        goldViewDir = new File(dirWithGoldViews);
    }
}

