/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.assertion.medfacts.CasIndexer;
import org.apache.ctakes.assertion.medfacts.i2b2.api.CharacterOffsetToLineTokenConverterCtakesImpl;
import org.apache.ctakes.assertion.medfacts.i2b2.api.SingleDocumentProcessorCtakes;
import org.apache.ctakes.assertion.medfacts.types.Concept;
import org.apache.ctakes.assertion.stub.ApiConcept;
import org.apache.ctakes.assertion.stub.AssertionDecoderConfiguration;
import org.apache.ctakes.assertion.stub.BatchRunner;
import org.apache.ctakes.assertion.stub.JarafeMEDecoder;
import org.apache.ctakes.assertion.stub.PartOfSpeechTagger;
import org.apache.ctakes.assertion.stub.ScopeParser;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Assertion Engine", description="Adds Negation, Uncertainty, Conditional and Subject to annotations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class AssertionAnalysisEngine
extends JCasAnnotator_ImplBase {
    private static Logger logger = Logger.getLogger((String)AssertionAnalysisEngine.class.getName());
    AssertionDecoderConfiguration assertionDecoderConfiguration;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        File enabledFeaturesFile;
        String posModelFilePath;
        String cueModelFilePath;
        String scopeModelFilePath;
        super.initialize(uimaContext);
        File assertionModelFile = null;
        try {
            String assertionModelResourceKey = "assertionModelResource";
            String assertionModelFilePath = this.getContext().getResourceFilePath(assertionModelResourceKey);
            assertionModelFile = new File(assertionModelFilePath);
            String scopeModelResourceKey = "scopeModelResource";
            scopeModelFilePath = this.getContext().getResourceFilePath(scopeModelResourceKey);
            String cueModelResourceKey = "cueModelResource";
            cueModelFilePath = this.getContext().getResourceFilePath(cueModelResourceKey);
            String posModelResourceKey = "posModelResource";
            posModelFilePath = this.getContext().getResourceFilePath(posModelResourceKey);
            String enabledFeaturesResourceKey = "enabledFeaturesResource";
            String enabledFeaturesFilePath = this.getContext().getResourceFilePath(enabledFeaturesResourceKey);
            enabledFeaturesFile = new File(enabledFeaturesFilePath);
        }
        catch (ResourceAccessException e) {
            String message = String.format("problem accessing resource", new Object[0]);
            throw new RuntimeException(message, e);
        }
        AssertionDecoderConfiguration assertionDecoderConfiguration = new AssertionDecoderConfiguration();
        logger.info((Object)String.format("scope model file: %s", scopeModelFilePath));
        logger.info((Object)String.format("cue model file: %s", cueModelFilePath));
        ScopeParser scopeParser = new ScopeParser(scopeModelFilePath, cueModelFilePath);
        assertionDecoderConfiguration.setScopeParser(scopeParser);
        logger.info((Object)String.format("pos model file: %s", posModelFilePath));
        PartOfSpeechTagger posTagger = new PartOfSpeechTagger(posModelFilePath);
        assertionDecoderConfiguration.setPosTagger(posTagger);
        Set<String> enabledFeatureIdSet = null;
        enabledFeatureIdSet = BatchRunner.loadEnabledFeaturesFromFile(enabledFeaturesFile);
        assertionDecoderConfiguration.setEnabledFeatureIdSet(enabledFeatureIdSet);
        JarafeMEDecoder assertionDecoder = null;
        assertionDecoder = new JarafeMEDecoder(assertionModelFile);
        assertionDecoderConfiguration.setAssertionDecoder(assertionDecoder);
        this.assertionDecoderConfiguration = assertionDecoderConfiguration;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        logger.debug((Object)"(logging statement) AssertionAnalysisEngine.process() BEGIN");
        String contents = jcas.getDocumentText();
        int conceptType = Concept.type;
        AnnotationIndex conceptAnnotationIndex = jcas.getAnnotationIndex(conceptType);
        ArrayList<ApiConcept> apiConceptList = new ArrayList<ApiConcept>();
        for (Annotation annotation : conceptAnnotationIndex) {
            Concept conceptAnnotation = (Concept)annotation;
            ApiConcept apiConcept = new ApiConcept();
            int begin = conceptAnnotation.getBegin();
            int end = conceptAnnotation.getEnd();
            String conceptText = contents.substring(begin, end);
            apiConcept.setBegin(begin);
            apiConcept.setEnd(end);
            apiConcept.setText(conceptText);
            apiConcept.setType(conceptAnnotation.getConceptType());
            apiConcept.setExternalId(conceptAnnotation.getAddress());
            apiConceptList.add(apiConcept);
        }
        SingleDocumentProcessorCtakes p = new SingleDocumentProcessorCtakes();
        p.setJcas(jcas);
        p.setAssertionDecoderConfiguration(this.assertionDecoderConfiguration);
        p.setContents(contents);
        CharacterOffsetToLineTokenConverterCtakesImpl converter = new CharacterOffsetToLineTokenConverterCtakesImpl(jcas);
        p.setConverter2(converter);
        for (ApiConcept apiConcept : apiConceptList) {
            p.addConcept(apiConcept);
        }
        logger.debug((Object)"(logging statement) AssertionAnalysisEngine.process() BEFORE CALLING p.processSingleDocument()");
        p.processSingleDocument();
        logger.debug((Object)"(logging statement) AssertionAnalysisEngine.process() AFTER CALLING p.processSingleDocument()");
        Map<Integer, String> assertionTypeMap = p.getAssertionTypeMap();
        CasIndexer indexer = new CasIndexer(jcas, null);
        for (Map.Entry<Integer, String> current : assertionTypeMap.entrySet()) {
            String currentAssertionType = current.getValue();
            Integer currentIndex = current.getKey();
            ApiConcept originalConcept = (ApiConcept)apiConceptList.get(currentIndex);
            Concept associatedConcept = (Concept)indexer.lookupByAddress(originalConcept.getExternalId());
            int entityAddress = associatedConcept.getOriginalEntityExternalId();
            IdentifiedAnnotation annotation = (IdentifiedAnnotation)indexer.lookupByAddress(entityAddress);
            AssertionAnalysisEngine.mapI2B2AssertionValueToCtakes(currentAssertionType, annotation);
        }
        logger.debug((Object)"(logging statement) AssertionAnalysisEngine.process() END");
    }

    public static void mapI2B2AssertionValueToCtakes(String assertionType, IdentifiedAnnotation annotation) throws AnalysisEngineProcessException {
        if (assertionType == null) {
            String message = "current assertion type is null; this is a problem!!";
            System.err.println(message);
            logger.log((Priority)Level.ERROR, (Object)message);
            annotation.setSubject("skipped");
            annotation.setPolarity(-2);
            annotation.setConfidence(-2.0f);
            annotation.setUncertainty(-2);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else if (assertionType.equals("present")) {
            annotation.setSubject("patient");
            annotation.setPolarity(1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(0);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else if (assertionType.equals("absent")) {
            annotation.setSubject("patient");
            annotation.setPolarity(-1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(0);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else if (assertionType.equals("associated_with_someone_else")) {
            annotation.setSubject("CONST.ATTR_SUBJECT_FAMILY_MEMBER");
            annotation.setPolarity(1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(0);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else if (assertionType.equals("conditional")) {
            annotation.setSubject("patient");
            annotation.setPolarity(1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(0);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else if (assertionType.equals("hypothetical")) {
            annotation.setSubject("patient");
            annotation.setPolarity(1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(0);
            annotation.setConditional(true);
            annotation.setGeneric(false);
        } else if (assertionType.equals("possible")) {
            annotation.setSubject("patient");
            annotation.setPolarity(1);
            annotation.setConfidence(1.0f);
            annotation.setUncertainty(1);
            annotation.setConditional(false);
            annotation.setGeneric(false);
        } else {
            String message = String.format("unexpected assertion value returned!! \"%s\"", assertionType);
            logger.log((Priority)Level.ERROR, (Object)message);
            RuntimeException runtimeException = new RuntimeException(message);
            throw new AnalysisEngineProcessException((Throwable)runtimeException);
        }
    }

    public void debugAnnotationsInCas(JCas jcas, IdentifiedAnnotation annotation, String label) {
        CasIndexer<IdentifiedAnnotation> i = new CasIndexer<IdentifiedAnnotation>(jcas, annotation.getType());
        StringBuilder b = new StringBuilder();
        b.append(String.format("<<<<<%n### TARGET ###%nclass: %s%naddress: %d%nvalue: %s%n### END TARGET ###%n>>>>>%n%n", annotation.getClass().getName(), annotation.getAddress(), annotation.toString()));
        String debugOutput = i.convertToDebugOutput(label, annotation);
        b.append(debugOutput);
        logger.debug((Object)b.toString());
    }

    public Map<Integer, Annotation> generateAnnotationMap(JCas jcas) {
        return this.generateAnnotationMap(jcas, null);
    }

    public Map<Integer, Annotation> generateAnnotationMap(JCas jcas, Integer typeId) {
        HashMap<Integer, Annotation> annotationMap = new HashMap<Integer, Annotation>();
        AnnotationIndex index = null;
        index = typeId == null ? jcas.getAnnotationIndex() : jcas.getAnnotationIndex(typeId.intValue());
        for (Annotation current : index) {
            int address = current.getAddress();
            annotationMap.put(address, current);
        }
        return annotationMap;
    }

    public String convert2DTokenArrayToText(ArrayList<ArrayList<String>> arrayOfLines) {
        String DELIM = " ";
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        boolean isFirstLine = true;
        for (ArrayList<String> line : arrayOfLines) {
            if (!isFirstLine) {
                printer.println();
            }
            boolean isFirstTokenOnLine = true;
            for (String currentToken : line) {
                if (!isFirstTokenOnLine) {
                    printer.print(" ");
                }
                printer.print(currentToken);
                isFirstTokenOnLine = false;
            }
            isFirstLine = false;
        }
        printer.close();
        String output = writer.toString();
        return output;
    }
}

