/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.assertion.util.AssertionDepUtils;
import org.apache.ctakes.assertion.util.AssertionTreeUtils;
import org.apache.ctakes.assertion.util.SemanticClasses;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.TreeFeature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.util.CleartkInitializationException;

public class AssertionDependencyTreeExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    protected SemanticClasses sems = null;

    public AssertionDependencyTreeExtractor() throws CleartkInitializationException {
        try {
            this.sems = new SemanticClasses(FileLocator.getAsStream((String)"org/apache/ctakes/assertion/all_cues.txt"));
        }
        catch (Exception e) {
            throw new CleartkInitializationException((Throwable)e, "org/apache/ctakes/assertion/semantic_classes", "Could not find semantic classes resource.", new Object[0]);
        }
    }

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1) throws CleartkExtractorException {
        ArrayList feats = Lists.newArrayList();
        TreeFeature f1 = null;
        String treeString = null;
        List sents = JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)arg1.getBegin(), (int)arg1.getEnd());
        if (sents == null || sents.size() == 0) {
            treeString = "(S (no parse))";
        } else {
            Sentence sent = (Sentence)sents.get(0);
            List nodes = JCasUtil.selectCovered(ConllDependencyNode.class, (AnnotationFS)sent);
            SimpleTree tree = AssertionDepUtils.getTokenTreeString(jCas, nodes, (Annotation)arg1, 2);
            if (tree == null) {
                treeString = "(S (no parse))";
            } else {
                AssertionTreeUtils.replaceDependencyWordsWithSemanticClasses(tree, this.sems);
                treeString = tree.toString();
            }
        }
        f1 = new TreeFeature("TK_DW", (Object)treeString);
        feats.add(f1);
        return feats;
    }
}

