/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.snowball;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ReflectionUtil;
import org.tartarus.snowball.SnowballProgram;

public abstract class SnowballStemmer<TOKEN_TYPE extends Annotation>
extends JCasAnnotator_ImplBase {
    public static final String PARAM_STEMMER_NAME = "stemmerName";
    private static final String STEMMER_NAME_DESCRIPTION = "specifies which snowball stemmer to use. Possible values are: Danish, Dutch, English, Finnish, French, German2, German, Italian, Kp, Lovins, Norwegian, Porter, Portuguese, Russian, Spanish, Swedish";
    @ConfigurationParameter(name="stemmerName", description="specifies which snowball stemmer to use. Possible values are: Danish, Dutch, English, Finnish, French, German2, German, Italian, Kp, Lovins, Norwegian, Porter, Portuguese, Russian, Spanish, Swedish", mandatory=true)
    public String stemmerName;
    private SnowballProgram stemmer;
    private Class<? extends Annotation> tokenClass;
    private Type tokenType = null;
    private boolean typesInitialized = false;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        String className = String.format("org.tartarus.snowball.ext.%sStemmer", this.stemmerName);
        this.stemmer = (SnowballProgram)InitializableFactory.create(null, (String)className, SnowballProgram.class);
        this.tokenClass = (Class)ReflectionUtil.uncheckedCast((Object)ReflectionUtil.getTypeArgument(SnowballStemmer.class, (String)"TOKEN_TYPE", (Object)((Object)this)));
    }

    private void initializeTypes(JCas jCas) {
        if (this.tokenClass != null) {
            this.tokenType = JCasUtil.getType((JCas)jCas, this.tokenClass);
        }
        this.typesInitialized = true;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (!this.typesInitialized) {
            this.initializeTypes(jCas);
        }
        for (Annotation token : jCas.getAnnotationIndex(this.tokenType)) {
            this.stemmer.setCurrent(token.getCoveredText().toLowerCase());
            this.stemmer.stem();
            String stem = this.stemmer.getCurrent();
            this.setStem(token, stem);
        }
    }

    public abstract void setStem(TOKEN_TYPE var1, String var2);

    public void setStemmerName(String stemmerName) {
        this.stemmerName = stemmerName;
    }
}

