/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Person Coreference Annotator", description="Annotates coreferences between person mentions.", dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
public class PersonChainAnnotator
extends JCasAnnotator_ImplBase {
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        NonEmptyFSList ptList = new NonEmptyFSList(jcas);
        ptList.setHead(null);
        NonEmptyFSList weList = new NonEmptyFSList(jcas);
        weList.setHead(null);
        NonEmptyFSList drList = new NonEmptyFSList(jcas);
        drList.setHead(null);
        ArrayList<NonEmptyFSList> otherDrs = new ArrayList<NonEmptyFSList>();
        ArrayList words = new ArrayList(JCasUtil.select((JCas)jcas, WordToken.class));
        for (int i = 0; i < words.size(); ++i) {
            Markable ptMention;
            Markable drMention;
            WordToken word = (WordToken)words.get(i);
            String text = word.getCoveredText();
            if (word.getPartOfSpeech().startsWith("PRP")) {
                if (text.equalsIgnoreCase("I") || text.equalsIgnoreCase("me") || text.equalsIgnoreCase("my")) {
                    drMention = new Markable(jcas, word.getBegin(), word.getEnd());
                    PersonChainAnnotator.addToList(jcas, drList, drMention);
                    continue;
                }
                if (text.equalsIgnoreCase("we") || text.equalsIgnoreCase("us") || text.equalsIgnoreCase("our")) {
                    Markable weMention = new Markable(jcas, word.getBegin(), word.getEnd());
                    PersonChainAnnotator.addToList(jcas, weList, weMention);
                    continue;
                }
                if (text.equalsIgnoreCase("it")) continue;
                ptMention = new Markable(jcas, word.getBegin(), word.getEnd());
                PersonChainAnnotator.addToList(jcas, ptList, ptMention);
                continue;
            }
            if (text.equalsIgnoreCase("dr.")) {
                drMention = PersonChainAnnotator.getDoctorMarkable(jcas, word);
                PersonChainAnnotator.addToList(jcas, PersonChainAnnotator.getCorrectDoctor(jcas, drMention, otherDrs), drMention);
                continue;
            }
            if (text.equalsIgnoreCase("mrs.") || text.equalsIgnoreCase("mr.") || text.equalsIgnoreCase("ms.")) {
                ptMention = new Markable(jcas, word.getBegin(), ((WordToken)words.get(i + 1)).getEnd());
                PersonChainAnnotator.addToList(jcas, ptList, ptMention);
                continue;
            }
            if (!text.equalsIgnoreCase("patient") && !text.equalsIgnoreCase("pt")) continue;
            ptMention = new Markable(jcas, word.getBegin(), word.getEnd());
            PersonChainAnnotator.addToList(jcas, ptList, ptMention);
        }
        for (NonEmptyFSList otherDr : otherDrs) {
            if (otherDr.getHead() == null || otherDr.getTail() == null) continue;
            PersonChainAnnotator.endList(jcas, otherDr);
            CollectionTextRelation drChain = new CollectionTextRelation(jcas);
            drChain.setMembers((FSList)otherDr);
            drChain.addToIndexes();
        }
        if (drList.getHead() != null && drList.getTail() != null) {
            PersonChainAnnotator.endList(jcas, drList);
            CollectionTextRelation drChain = new CollectionTextRelation(jcas);
            drChain.setMembers((FSList)drList);
            drChain.addToIndexes();
        }
        if (ptList.getHead() != null && ptList.getTail() != null) {
            PersonChainAnnotator.endList(jcas, ptList);
            CollectionTextRelation ptChain = new CollectionTextRelation(jcas);
            ptChain.setMembers((FSList)ptList);
            ptChain.addToIndexes();
        }
        if (weList.getHead() != null && weList.getTail() != null) {
            PersonChainAnnotator.endList(jcas, weList);
            CollectionTextRelation weChain = new CollectionTextRelation(jcas);
            weChain.setMembers((FSList)weList);
            weChain.addToIndexes();
        }
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(PersonChainAnnotator.class, (Object[])new Object[0]);
    }

    private static void addToList(JCas jcas, NonEmptyFSList list, Markable arg) {
        arg.addToIndexes();
        if (list.getHead() == null) {
            list.setHead((TOP)arg);
        } else {
            NonEmptyFSList cur = list;
            while (cur.getTail() != null) {
                cur = (NonEmptyFSList)cur.getTail();
            }
            NonEmptyFSList tail = new NonEmptyFSList(jcas);
            tail.setHead((TOP)arg);
            cur.setTail((FSList)tail);
            tail.addToIndexes();
        }
    }

    private static void endList(JCas jcas, NonEmptyFSList list) {
        NonEmptyFSList cur = list;
        while (cur.getTail() != null) {
            cur = (NonEmptyFSList)cur.getTail();
        }
        EmptyFSList tail = new EmptyFSList(jcas);
        cur.setTail((FSList)tail);
        tail.addToIndexes();
    }

    private static NonEmptyFSList getCorrectDoctor(JCas jcas, Markable mention, List<NonEmptyFSList> drLists) {
        NonEmptyFSList correctDr;
        block4: {
            block3: {
                correctDr = null;
                if (mention.getCoveredText().length() >= 5) break block3;
                if (drLists.size() <= 0) break block4;
                correctDr = drLists.get(0);
                break block4;
            }
            String nameText = mention.getCoveredText().substring(4);
            Iterator<NonEmptyFSList> iterator = drLists.iterator();
            while (iterator.hasNext()) {
                NonEmptyFSList drList;
                NonEmptyFSList curNode = drList = iterator.next();
                do {
                    String otherName;
                    if ((otherName = ((Markable)curNode.getHead()).getCoveredText()).length() < 5 || !(otherName = otherName.substring(4)).contains(nameText) && !nameText.contains(otherName)) continue;
                    correctDr = drList;
                } while ((curNode = curNode.getTail()) instanceof NonEmptyFSList);
                if (correctDr == null) continue;
                break;
            }
        }
        if (correctDr == null) {
            correctDr = new NonEmptyFSList(jcas);
            correctDr.setHead(null);
            drLists.add(correctDr);
        }
        return correctDr;
    }

    private static Markable getDoctorMarkable(JCas jcas, WordToken drToken) {
        ConllDependencyNode nnpHead;
        Markable markable = null;
        try {
            for (nnpHead = DependencyUtility.getDependencyNode((JCas)jcas, (Annotation)drToken); nnpHead != null && nnpHead.getHead() != null && nnpHead.getHead().getId() != 0 && nnpHead.getHead().getPostag().equals("NNP"); nnpHead = nnpHead.getHead()) {
            }
        }
        catch (NullPointerException e) {
            System.err.print(".");
        }
        int start = drToken.getBegin();
        int end = nnpHead.getEnd();
        if (end < start) {
            end = drToken.getEnd();
        }
        markable = new Markable(jcas, start, end);
        return markable;
    }
}

