/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.cc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PreprocessAndWriteXmi {
    public static void main(String[] args) throws UIMAException, IOException, CmdLineException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        File outputRoot = options.outputRoot;
        String inputRoot = options.textRoot;
        AnalysisEngine ae = AnalysisEngineFactory.createEngineFromPath((String)"desc/analysis_engine/ODIESvmVectorCreator.xml", (Object[])new Object[0]);
        CollectionReader reader = CollectionReaderFactory.createReaderFromPath((String)"../ctakes-core/desc/collection_reader/FilesInDirectoryCollectionReader.xml", (Object[])new Object[]{"InputDirectory", inputRoot});
        AnalysisEngine serializer = AnalysisEngineFactory.createEngine(SerializeDocumentToXMI.class, (Object[])new Object[]{"OutputDirectory", outputRoot.getPath()});
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{ae, serializer});
    }

    public static class SerializeDocumentToXMI
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_OUTPUT_DIRECTORY = "OutputDirectory";
        @ConfigurationParameter(name="OutputDirectory", mandatory=true, description="Specifies the output directory in which to write xmi files")
        private File outputDirectory;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            try {
                JCas goldView = jCas;
                String documentID = DocumentIDAnnotationUtil.getDocumentID((JCas)goldView);
                if (documentID == null || documentID.equals("UnknownDocument")) {
                    throw new IllegalArgumentException("No documentID for CAS:\n" + jCas);
                }
                File outFile = new File(this.outputDirectory, documentID + ".xmi");
                ContentHandler handler = new XMLSerializer((OutputStream)new FileOutputStream(outFile)).getContentHandler();
                new XmiCasSerializer(jCas.getTypeSystem()).serialize(jCas.getCas(), handler);
            }
            catch (CASRuntimeException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class Options {
        @Option(name="-t", aliases={"--textRoot"}, usage="specify the directory contraining the textFiles (for example /NLP/Corpus/Relations/mipacq/text/train", required=true)
        public String textRoot;
        @Option(name="-o", aliases={"--outputRoot"}, usage="specify the directory to write out CAS XMI files", required=true)
        public File outputRoot;
    }
}

