/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.eval.helpers;

import org.apache.ctakes.coreference.eval.helpers.Span;

public class SpanAlignment {
    int[] id1;
    int[] id2;

    public SpanAlignment(Span[] s1, Span[] s2) {
        int k;
        int j;
        int i;
        int l1 = s1.length;
        int l2 = s2.length;
        double[][] scores = new double[l1 + 1][l2 + 1];
        int[][] track = new int[l1 + 1][l2 + 1];
        this.id1 = new int[l1];
        this.id2 = new int[l2];
        scores[0][0] = 0.0;
        track[0][0] = -1;
        for (i = 1; i <= l1; ++i) {
            scores[i][0] = s1[i - 1].gap() * (double)i;
            track[i][0] = 2;
        }
        for (i = 1; i <= l2; ++i) {
            scores[0][i] = s2[i - 1].gap() * (double)i;
            track[0][i] = 0;
        }
        for (i = 1; i <= l1; ++i) {
            for (j = 1; j <= l2; ++j) {
                double match = scores[i - 1][j - 1] + Span.score(s1[i - 1], s2[j - 1]);
                double gap1 = scores[i][j - 1] + s1[i - 1].gap();
                double gap2 = scores[i - 1][j] + s2[j - 1].gap();
                if (match >= gap1 && match >= gap2) {
                    scores[i][j] = match;
                    track[i][j] = 1;
                    continue;
                }
                if (gap1 >= match && gap1 >= gap2) {
                    scores[i][j] = gap1;
                    track[i][j] = 0;
                    continue;
                }
                scores[i][j] = gap2;
                track[i][j] = 2;
            }
        }
        i = l1;
        j = l2;
        int id = 0;
        while (i > 0 || j > 0) {
            int dir = track[i][j];
            switch (dir) {
                case 0: {
                    this.id2[--j] = id++;
                    break;
                }
                case 1: {
                    this.id1[--i] = id;
                    this.id2[--j] = id++;
                    break;
                }
                case 2: {
                    this.id1[--i] = id++;
                }
            }
        }
        for (k = 0; k < l1; ++k) {
            this.id1[k] = id - this.id1[k];
        }
        for (k = 0; k < l2; ++k) {
            this.id2[k] = id - this.id2[k];
        }
    }

    public int[] get1() {
        return this.id1;
    }

    public int get1(int i) {
        return this.id1[i];
    }

    public int[] get2() {
        return this.id2;
    }

    public int get2(int i) {
        return this.id2[i];
    }

    public int getMaxID() {
        int mid1 = this.id1.length > 0 ? this.id1[this.id1.length - 1] : 0;
        int mid2 = this.id2.length > 0 ? this.id2[this.id2.length - 1] : 0;
        return mid1 > mid2 ? mid1 : mid2;
    }
}

