/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.treekernel.training;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import libsvm.svm_node;
import org.apache.ctakes.coreference.treekernel.training.RowFillerThread;
import org.apache.ctakes.coreference.util.ThreadDelegator;
import org.apache.ctakes.utils.kernel.Kernel;
import org.apache.ctakes.utils.kernel.LinearKernel;
import org.apache.ctakes.utils.kernel.PolyKernel;
import org.apache.ctakes.utils.kernel.RBFKernel;

public class LinearKernelMatrixWriter
implements ThreadDelegator {
    static int NUMTHREADS = 4;
    private int busyThreads = 0;
    private String inputFile;
    private String outputFile;

    public LinearKernelMatrixWriter(String in, String out) {
        this.inputFile = in;
        this.outputFile = out;
    }

    public void run(Kernel kernel) {
        int lineNum = 1;
        ArrayList rows = new ArrayList();
        ArrayList<svm_node[]> vectors = new ArrayList<svm_node[]>();
        ArrayList<String> labels = new ArrayList<String>();
        try {
            Scanner scanner = new Scanner(new File(this.inputFile));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                String label = line.substring(0, 2).trim();
                labels.add(label);
                vectors.add(LinearKernelMatrixWriter.getNodes(line));
                rows.add(new ArrayList(lineNum));
                ++lineNum;
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            System.err.println("Could not open input file!");
            System.exit(1);
        }
        System.out.println("Input complete.");
        RowFillerThread.setObjects(vectors);
        RowFillerThread cur = null;
        for (int i = 0; i < vectors.size(); ++i) {
            if (i % 100 == 0) {
                System.out.println("Computing matrix row: " + i);
            }
            while (this.busyThreads >= NUMTHREADS) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            cur = new RowFillerThread(this, kernel, (ArrayList)rows.get(i), i);
            cur.start();
            ++this.busyThreads;
        }
        String format = "%1.6f";
        double max = 0.0;
        try {
            PrintWriter out = new PrintWriter(this.outputFile);
            for (int i = 0; i < rows.size(); ++i) {
                ArrayList entries = (ArrayList)rows.get(i);
                out.print((String)labels.get(i));
                out.print(" 0:");
                out.print(i + 1);
                for (int j = 0; j < rows.size(); ++j) {
                    out.print(" ");
                    out.print(j + 1);
                    out.print(":");
                    if (i >= j) {
                        out.printf(format, entries.get(j));
                        if (!((Double)entries.get(j) > max)) continue;
                        max = (Double)entries.get(j);
                        continue;
                    }
                    out.printf(format, ((ArrayList)rows.get(j)).get(i));
                }
                out.println();
            }
            out.flush();
            out.close();
            System.err.println("Max value of matrix is: " + max);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Error opening output file: " + this.outputFile);
        }
    }

    public static void main(String[] args) {
        RBFKernel rbf;
        if (args.length < 2) {
            System.err.println("Not enough arguments!");
            System.exit(1);
        }
        String dir = "/home/tmill/Projects/coref/training/";
        String config = "treeKernels";
        String path = dir + config;
        LinearKernel linear = new LinearKernel(false);
        PolyKernel poly = new PolyKernel(3, 0.0, false);
        RBFKernel kernel = rbf = new RBFKernel(0.5);
        LinearKernelMatrixWriter lkmw = new LinearKernelMatrixWriter(path + "/ne/training.downsampled.libsvm", path + "/ne/featRBFMatrix.downsampled.out");
        lkmw.run((Kernel)kernel);
    }

    @Override
    public synchronized void threadDone(RowFillerThread t) {
        --this.busyThreads;
    }

    private static svm_node[] getNodes(String nodeStr) {
        String[] vals = nodeStr.substring(2).split(" ");
        svm_node[] nodes = new svm_node[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            String[] map = vals[i].split(":");
            nodes[i] = new svm_node();
            nodes[i].index = Integer.parseInt(map[0]);
            nodes[i].value = Double.parseDouble(map[1]);
        }
        return nodes;
    }
}

