/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.treekernel.training;

import java.util.ArrayList;
import org.apache.ctakes.coreference.util.ThreadDelegator;
import org.apache.ctakes.utils.kernel.Kernel;

public class RowFillerThread
extends Thread {
    private ArrayList<Double> row = null;
    private static ArrayList<?> objects;
    private Kernel kernel = null;
    private ThreadDelegator parent = null;
    private int rowNum = 0;
    private long start;

    public RowFillerThread(ThreadDelegator parent, Kernel k, ArrayList<Double> row, int i) {
        this.kernel = k;
        this.row = row;
        this.rowNum = i;
        this.parent = parent;
    }

    @Override
    public void run() {
        super.run();
        if (this.rowNum % 100 == 0) {
            this.start = System.currentTimeMillis();
        }
        Object p1 = objects.get(this.rowNum);
        for (int j = 0; j <= this.rowNum; ++j) {
            Object p2 = objects.get(j);
            double sim = this.kernel.eval(p1, p2);
            this.row.add(sim);
        }
        if (this.rowNum % 100 == 0) {
            System.out.println("Row " + this.rowNum + " took " + (System.currentTimeMillis() - this.start) + "ms");
        }
        this.parent.threadDone(this);
    }

    public void setRow(ArrayList<Double> row, int i) {
        this.row = row;
        this.rowNum = i;
    }

    public static void setObjects(ArrayList<?> objects) {
        RowFillerThread.objects = objects;
    }

    public int getRowNum() {
        return this.rowNum;
    }
}

