/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.treekernel.training;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import opennlp.tools.parser.Parse;
import org.apache.ctakes.constituency.parser.treekernel.TreeKernel;
import org.apache.ctakes.coreference.treekernel.training.RowFillerThread;
import org.apache.ctakes.coreference.util.ThreadDelegator;
import org.apache.ctakes.utils.kernel.Kernel;

public class TreeKernelTrainer
implements ThreadDelegator {
    static int NUMTHREADS = 4;
    private int busyThreads = 0;
    private String inFile;
    private String outFile;

    public TreeKernelTrainer(String inputFile, String outputFile) {
        this.inFile = inputFile;
        this.outFile = outputFile;
    }

    public void run(TreeKernel kernel) {
        int lineNum = 1;
        ArrayList rows = new ArrayList();
        ArrayList<Parse> trees = new ArrayList<Parse>();
        ArrayList<String> labels = new ArrayList<String>();
        try {
            Scanner scanner = new Scanner(new File(this.inFile));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split(":", 2);
                String label = parts[0].trim();
                String treeStr = parts[1].trim();
                labels.add(label);
                trees.add(Parse.parseParse((String)treeStr));
                rows.add(new ArrayList(lineNum));
                ++lineNum;
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            System.err.println("Could not open input file!");
            System.exit(1);
        }
        System.out.println("Input complete.");
        RowFillerThread.setObjects(trees);
        RowFillerThread cur = null;
        for (int i = 0; i < trees.size(); ++i) {
            if (i % 100 == 0) {
                System.out.println("Computing matrix row: " + i);
            }
            while (this.busyThreads >= NUMTHREADS) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            cur = new RowFillerThread(this, (Kernel)kernel, (ArrayList)rows.get(i), i);
            cur.start();
            this.threadStarted();
        }
        System.err.println("Waiting for threads to finish...");
        while (this.busyThreads > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.err.println("Writing to file...");
        String format = "%1.4f";
        double max = 0.0;
        try {
            PrintWriter out = new PrintWriter(this.outFile);
            for (int i = 0; i < rows.size(); ++i) {
                ArrayList entries = (ArrayList)rows.get(i);
                out.print((String)labels.get(i));
                out.print(" 0:");
                out.print(i + 1);
                for (int j = 0; j < rows.size(); ++j) {
                    out.print(" ");
                    out.print(j + 1);
                    out.print(":");
                    if (i >= j) {
                        out.printf(format, entries.get(j));
                        if (!((Double)entries.get(j) > max)) continue;
                        max = (Double)entries.get(j);
                        continue;
                    }
                    out.printf(format, ((ArrayList)rows.get(j)).get(i));
                }
                out.println();
            }
            out.flush();
            out.close();
            System.err.println("Max value of matrix is: " + max);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Error opening output file: " + this.outFile);
        }
    }

    public void threadStarted() {
        this.changeNumThreads(1);
    }

    @Override
    public void threadDone(RowFillerThread t) {
        this.changeNumThreads(-1);
    }

    public synchronized void changeNumThreads(int i) {
        this.busyThreads += i;
    }

    public static void main(String[] args) {
        String dir = "/home/tmill/Projects/coref/training/";
        String config = "treeKernels";
        String path = dir + config;
        TreeKernel kernel = new TreeKernel(false);
        TreeKernelTrainer tkt = new TreeKernelTrainer(path + "/ne/trees.downsampled.txt", path + "/ne/matrix.downsampled.out");
        tkt.run(kernel);
    }
}

