/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.necontexts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.necontexts.ContextAnalyzer;
import org.apache.ctakes.necontexts.ContextHit;
import org.apache.ctakes.necontexts.ContextHitConsumer;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Context Annotator", description="Collects context for focus annotations for use by context consuming annotators.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN})
public class ContextAnnotator
extends JCasAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String MAX_LEFT_SCOPE_SIZE_PARAM = "MaxLeftScopeSize";
    public static final String MAX_RIGHT_SCOPE_SIZE_PARAM = "MaxRightScopeSize";
    public static final String SCOPE_ORDER_PARAM = "ScopeOrder";
    public static final String WINDOW_ANNOTATION_CLASS_PARAM = "WindowAnnotationClass";
    public static final String FOCUS_ANNOTATION_CLASS_PARAM = "FocusAnnotationClass";
    public static final String CONTEXT_ANNOTATION_CLASS_PARAM = "ContextAnnotationClass";
    public static final String CONTEXT_ANALYZER_CLASS_PARAM = "ContextAnalyzerClass";
    public static final String CONTEXT_HIT_CONSUMER_CLASS_PARAM = "ContextHitConsumerClass";
    public static final int LEFT_SCOPE = 1;
    public static final int MIDDLE_SCOPE = 2;
    public static final int RIGHT_SCOPE = 3;
    public static final int ALL_SCOPE = 4;
    @ConfigurationParameter(name="MaxLeftScopeSize", mandatory=false, description="", defaultValue={"7"})
    protected int leftScopeSize;
    @ConfigurationParameter(name="MaxRightScopeSize", mandatory=false, description="", defaultValue={"7"})
    protected int rightScopeSize;
    @ConfigurationParameter(name="ScopeOrder", mandatory=false, description="", defaultValue={"LEFT,RIGHT"})
    private String _scopeOrder;
    @ConfigurationParameter(name="WindowAnnotationClass", mandatory=false, description="Type of Lookup window to use", defaultValue={"org.apache.ctakes.typesystem.type.textspan.Sentence"})
    private String windowClassName;
    @ConfigurationParameter(name="FocusAnnotationClass", mandatory=false, description="", defaultValue={"org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation"})
    private String focusClassName;
    @ConfigurationParameter(name="ContextAnnotationClass", mandatory=false, description="", defaultValue={"org.apache.ctakes.typesystem.type.syntax.BaseToken"})
    private String contextClassName;
    @ConfigurationParameter(name="ContextAnalyzerClass", mandatory=false, description="", defaultValue={"org.apache.ctakes.necontexts.negation.NegationContextAnalyzer"})
    private String contextAnalyzerClassName;
    @ConfigurationParameter(name="ContextHitConsumerClass", mandatory=false, description="", defaultValue={"org.apache.ctakes.necontexts.negation.NegationContextHitConsumer"})
    private String contextConsumerClassName;
    protected List<Integer> scopes = new ArrayList<Integer>();
    protected ContextAnalyzer contextAnalyzer;
    protected ContextHitConsumer contextConsumer;
    int windowType;
    int focusType;
    int contextType;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            this.iv_logger.info((Object)("Using left , right scope sizes: " + this.leftScopeSize + " , " + this.rightScopeSize));
            this.iv_logger.info((Object)("Using scope order: " + this._scopeOrder));
            this.parseScopeOrder(this._scopeOrder);
            this.iv_logger.info((Object)("Using context analyzer: " + this.contextAnalyzerClassName));
            this.contextAnalyzer = (ContextAnalyzer)Class.forName(this.contextAnalyzerClassName).newInstance();
            this.contextAnalyzer.initialize(uimaContext);
            this.iv_logger.info((Object)("Using context consumer: " + this.contextConsumerClassName));
            this.contextConsumer = (ContextHitConsumer)Class.forName(this.contextConsumerClassName).newInstance();
            this.iv_logger.info((Object)("Using lookup window type: " + this.windowClassName));
            this.windowType = JCasUtil.getType((String)this.windowClassName);
            this.iv_logger.info((Object)("Using focus type: " + this.focusClassName));
            this.focusType = JCasUtil.getType((String)this.focusClassName);
            this.iv_logger.info((Object)("Using context type: " + this.contextClassName));
            this.contextType = JCasUtil.getType((String)this.contextClassName);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void parseScopeOrder(String scopeString) throws AnnotatorConfigurationException {
        this.parseScopeOrder(scopeString.split(","));
    }

    void parseScopeOrder(String[] scopeStrings) throws AnnotatorConfigurationException {
        this.scopes.clear();
        for (int i = 0; i < scopeStrings.length; ++i) {
            if (scopeStrings[i].equals("LEFT")) {
                this.scopes.add(new Integer(1));
                continue;
            }
            if (scopeStrings[i].equals("MIDDLE")) {
                this.scopes.add(new Integer(2));
                continue;
            }
            if (scopeStrings[i].equals("RIGHT")) {
                this.scopes.add(new Integer(3));
                continue;
            }
            if (scopeStrings[i].equals("ALL")) {
                this.scopes.add(new Integer(4));
                continue;
            }
            Exception e = new Exception("Invalid scope value: " + scopeStrings[i]);
            throw new AnnotatorConfigurationException((Throwable)e);
        }
        this.iv_logger.info((Object)("SCOPE ORDER: " + this.scopes));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            for (Annotation window : jCas.getAnnotationIndex(this.windowType)) {
                List<Annotation> focusList = this.constrainToWindow(jCas, this.focusType, window);
                Collections.reverse(focusList);
                for (int scope : this.scopes) {
                    for (Annotation focus : focusList) {
                        List<Annotation> scopeContextAnnotations = this.getScopeContextAnnotations(jCas, focus, window, scope);
                        ContextHit contextHit = this.contextAnalyzer.analyzeContext(scopeContextAnnotations, scope);
                        if (contextHit == null) continue;
                        this.contextConsumer.consumeHit(jCas, focus, scope, contextHit);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected List<Annotation> getScopeContextAnnotations(JCas jCas, Annotation focus, Annotation window, int scope) throws AnalysisEngineProcessException {
        List<Annotation> scopeContextAnnotations = new ArrayList<Annotation>();
        switch (scope) {
            case 1: {
                scopeContextAnnotations = this.getLeftScopeContextAnnotations(jCas, focus, window);
                break;
            }
            case 2: {
                scopeContextAnnotations = this.getMiddleScopeContextAnnotations(jCas, focus);
                break;
            }
            case 3: {
                scopeContextAnnotations = this.getRightScopeContextAnnotations(jCas, focus, window);
                break;
            }
            case 4: {
                scopeContextAnnotations.addAll(this.getLeftScopeContextAnnotations(jCas, focus, window));
                scopeContextAnnotations.addAll(this.getMiddleScopeContextAnnotations(jCas, focus));
                scopeContextAnnotations.addAll(this.getRightScopeContextAnnotations(jCas, focus, window));
            }
        }
        return scopeContextAnnotations;
    }

    protected List<Annotation> getLeftScopeContextAnnotations(JCas jCas, Annotation focus, Annotation window) throws AnalysisEngineProcessException {
        ArrayList<Annotation> scopeContextAnnotations = new ArrayList<Annotation>();
        if (focus.getBegin() < window.getBegin() || focus.getEnd() > window.getEnd()) {
            return scopeContextAnnotations;
        }
        FSIterator subiterator = jCas.getAnnotationIndex(this.contextType).subiterator((AnnotationFS)window);
        subiterator.moveTo((FeatureStructure)focus);
        subiterator.moveToNext();
        if (!subiterator.isValid()) {
            subiterator.moveTo((FeatureStructure)focus);
        }
        while (scopeContextAnnotations.size() < this.leftScopeSize) {
            subiterator.moveToPrevious();
            if (!subiterator.isValid()) break;
            Annotation contextAnnotation = (Annotation)subiterator.get();
            if (contextAnnotation.getEnd() > focus.getBegin()) continue;
            if (this.contextAnalyzer.isBoundary(contextAnnotation, 1)) break;
            scopeContextAnnotations.add(contextAnnotation);
        }
        Collections.reverse(scopeContextAnnotations);
        return scopeContextAnnotations;
    }

    protected List<Annotation> getRightScopeContextAnnotations(JCas jCas, Annotation focus, Annotation window) throws AnalysisEngineProcessException {
        ArrayList<Annotation> scopeContextAnnotations = new ArrayList<Annotation>();
        if (focus.getBegin() < window.getBegin() || focus.getEnd() > window.getEnd()) {
            return scopeContextAnnotations;
        }
        FSIterator subiterator = jCas.getAnnotationIndex(this.contextType).subiterator((AnnotationFS)window);
        subiterator.moveTo((FeatureStructure)focus);
        subiterator.moveToPrevious();
        if (!subiterator.isValid()) {
            subiterator.moveTo((FeatureStructure)focus);
        }
        while (scopeContextAnnotations.size() < this.rightScopeSize) {
            subiterator.moveToNext();
            if (!subiterator.isValid()) break;
            Annotation contextAnnotation = (Annotation)subiterator.get();
            if (contextAnnotation.getBegin() < focus.getEnd()) continue;
            if (this.contextAnalyzer.isBoundary(contextAnnotation, 3)) break;
            scopeContextAnnotations.add(contextAnnotation);
        }
        return scopeContextAnnotations;
    }

    protected List<Annotation> getMiddleScopeContextAnnotations(JCas jCas, Annotation focus) throws AnalysisEngineProcessException {
        Type subType;
        Type superType;
        TypeSystem typeSystem;
        ArrayList<Annotation> scopeContextAnnotations = new ArrayList<Annotation>();
        FSIterator subiterator = jCas.getAnnotationIndex(this.contextType).subiterator((AnnotationFS)focus);
        while (subiterator.hasNext()) {
            scopeContextAnnotations.add((Annotation)subiterator.next());
        }
        if (scopeContextAnnotations.size() == 0 && JCasUtil.getType(focus.getClass()) == this.contextType) {
            scopeContextAnnotations.add(focus);
        } else if (scopeContextAnnotations.size() == 0 && (typeSystem = jCas.getTypeSystem()).subsumes(superType = jCas.getType((int)this.focusType).casType, subType = focus.getType())) {
            scopeContextAnnotations.add(focus);
        }
        return scopeContextAnnotations;
    }

    private List<Annotation> constrainToWindow(JCas jCas, int type, Annotation window) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        FSIterator subiterator = jCas.getAnnotationIndex(type).subiterator((AnnotationFS)window);
        while (subiterator.hasNext()) {
            Annotation annot = (Annotation)subiterator.next();
            list.add(annot);
        }
        return list;
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ContextAnnotator.class, (Object[])new Object[0]);
    }
}

