/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.necontexts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.fsm.adapters.TextTokenAdapter;
import org.apache.ctakes.core.fsm.token.TextToken;
import org.apache.ctakes.necontexts.ContextAnalyzer;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class NamedEntityContextAnalyzer
implements ContextAnalyzer {
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private Set<String> _boundaryWordSet;

    @Override
    public void initialize(UimaContext annotatorContext) throws ResourceInitializationException {
        this.initBoundaryData();
    }

    private void initBoundaryData() {
        this.iv_logger.info((Object)"initBoundaryData() called for ContextInitializer");
        this._boundaryWordSet = new HashSet<String>();
        this._boundaryWordSet.add("but");
        this._boundaryWordSet.add("however");
        this._boundaryWordSet.add("nevertheless");
        this._boundaryWordSet.add("notwithstanding");
        this._boundaryWordSet.add("though");
        this._boundaryWordSet.add("although");
        this._boundaryWordSet.add("if");
        this._boundaryWordSet.add("when");
        this._boundaryWordSet.add("how");
        this._boundaryWordSet.add("what");
        this._boundaryWordSet.add("which");
        this._boundaryWordSet.add("while");
        this._boundaryWordSet.add("since");
        this._boundaryWordSet.add("then");
        this._boundaryWordSet.add("i");
        this._boundaryWordSet.add("he");
        this._boundaryWordSet.add("she");
        this._boundaryWordSet.add("they");
        this._boundaryWordSet.add("we");
        this._boundaryWordSet.add(";");
        this._boundaryWordSet.add(":");
        this._boundaryWordSet.add(".");
        this._boundaryWordSet.add(")");
    }

    @Override
    public boolean isBoundary(Annotation contextAnnotation, int scopeOrientation) throws AnalysisEngineProcessException {
        String lcText = contextAnnotation.getCoveredText().toLowerCase();
        return this._boundaryWordSet.contains(lcText);
    }

    protected List<TextToken> wrapAsFsmTokens(List<? extends Annotation> tokenList) {
        ArrayList<TextToken> fsmTokenList = new ArrayList<TextToken>();
        for (Annotation annotation : tokenList) {
            fsmTokenList.add((TextToken)new TextTokenAdapter(annotation));
        }
        fsmTokenList.add(new TextToken(){

            public String getText() {
                return "+DUMMY_TOKEN+";
            }

            public int getEndOffset() {
                return 0;
            }

            public int getStartOffset() {
                return 0;
            }
        });
        return fsmTokenList;
    }
}

