/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.libsvm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import libsvm.svm;
import libsvm.svm_model;
import org.apache.commons.io.IOUtils;
import org.cleartk.ml.libsvm.GenericLibSvmClassifierBuilder;
import org.cleartk.ml.libsvm.LibSvmClassifier;
import org.cleartk.ml.libsvm.util.LibSvmTrain;

public abstract class LibSvmClassifierBuilder<CLASSIFIER_TYPE extends LibSvmClassifier<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE, MODEL_TYPE>
extends GenericLibSvmClassifierBuilder<CLASSIFIER_TYPE, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE, svm_model> {
    public static final String SCALE_FEATURES_KEY = "scaleFeatures";
    public static final String SCALE_FEATURES_VALUE_NORMALIZEL2 = "normalizeL2";

    @Override
    public String getTrainingDataName() {
        return "training-data.libsvm";
    }

    @Override
    protected String getModelName() {
        return "model.libsvm";
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        args = Arrays.copyOf(args, args.length + 4);
        args[args.length - 4] = "-b";
        args[args.length - 3] = "1";
        args[args.length - 2] = this.getTrainingDataFile(dir).getPath();
        args[args.length - 1] = this.getModelFile(dir).getPath();
        LibSvmTrain.main(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected svm_model loadModel(InputStream inputStream) throws IOException {
        File tmpFile = File.createTempFile("tmp", ".mdl");
        FileOutputStream output = new FileOutputStream(tmpFile);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            svm_model svm_model2 = svm.svm_load_model((String)tmpFile.getPath());
            return svm_model2;
        }
        finally {
            output.close();
            tmpFile.delete();
        }
    }
}

