/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.tokenizer;

public class Token {
    private int begin;
    private int end;
    private String tokenText;

    public Token(int begin, int end, String tokenText) {
        if (end < begin) {
            throw new IllegalArgumentException(String.format("the end of a token must follow the beginning of a token: begin=%1$d, end=%2$d, token text='%3$s'", begin, end, tokenText));
        }
        this.begin = begin;
        this.end = end;
        String string = this.tokenText = tokenText == null ? "" : tokenText;
        if (this.tokenText.length() != end - begin) {
            throw new IllegalArgumentException(String.format("the length of the token text must equal the extent specified by begin and end: token text length=%1$d, (end - begin)=%2$d, token text='%3$s'", this.tokenText.length(), end - begin, tokenText));
        }
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public String getTokenText() {
        return this.tokenText;
    }

    public int hashCode() {
        return this.tokenText.hashCode();
    }

    public boolean equals(Object obj) {
        Token token;
        return obj instanceof Token && this.tokenText.equals((token = (Token)obj).getTokenText()) && this.begin == token.getBegin() && this.end == token.getEnd();
    }

    public String toString() {
        return this.tokenText + "[" + this.begin + "," + this.end + "]";
    }
}

