/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeClassifier;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeClassifierBuilder;
import org.cleartk.ml.tksvmlight.model.TreeKernelSvmModel;

@Beta
public class TkSvmLightBooleanOutcomeClassifierBuilder
extends TreeKernelSvmBooleanOutcomeClassifierBuilder<TreeKernelSvmBooleanOutcomeClassifier> {
    static Logger logger = UIMAFramework.getLogger(TkSvmLightBooleanOutcomeClassifierBuilder.class);
    public static String COMMAND_ARGUMENT = "--executable";
    private TreeKernelSvmModel model;

    public static void train(String filePath, String[] args) throws Exception {
        String executable = "tk_svm_learn";
        if (args.length > 0 && args[0].equals(COMMAND_ARGUMENT)) {
            executable = args[1];
            String[] tempArgs = new String[args.length - 2];
            System.arraycopy(args, 2, tempArgs, 0, tempArgs.length);
            args = tempArgs;
        }
        Object[] command = new String[args.length + 3];
        command[0] = executable;
        System.arraycopy(args, 0, command, 1, args.length);
        command[command.length - 2] = new File(filePath).getPath();
        command[command.length - 1] = new File(filePath + ".model").getPath();
        logger.log(Level.FINE, "training with tree kernel svmlight using the following command: " + Joiner.on((String)" ").join(command));
        Process process = Runtime.getRuntime().exec((String[])command);
        process.getOutputStream().close();
        ByteStreams.copy((InputStream)process.getInputStream(), (OutputStream)System.out);
        ByteStreams.copy((InputStream)process.getErrorStream(), (OutputStream)System.err);
        process.waitFor();
    }

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.svmlight");
    }

    private File getModelFile(File dir) {
        return new File(dir, "training-data.svmlight.model");
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        File trainingDataFile = dir.isDirectory() ? this.getTrainingDataFile(dir) : dir;
        TkSvmLightBooleanOutcomeClassifierBuilder.train(trainingDataFile.getPath(), args);
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"model.svmlight", (File)this.getModelFile(dir));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)"model.svmlight");
        this.model = TreeKernelSvmModel.fromInputStream(modelStream);
    }

    protected TreeKernelSvmBooleanOutcomeClassifier newClassifier() {
        return new TreeKernelSvmBooleanOutcomeClassifier((FeaturesEncoder<TreeFeatureVector>)this.featuresEncoder, (OutcomeEncoder<Boolean, Boolean>)this.outcomeEncoder, this.model);
    }
}

