/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.model.TreeKernelSvmModel;

@Beta
public class TreeKernelSvmStringOutcomeClassifier
extends Classifier_ImplBase<TreeFeatureVector, String, Integer> {
    Map<Integer, TreeKernelSvmModel> models;

    public TreeKernelSvmStringOutcomeClassifier(FeaturesEncoder<TreeFeatureVector> featuresEncoder, OutcomeEncoder<String, Integer> outcomeEncoder, Map<Integer, TreeKernelSvmModel> models) {
        super(featuresEncoder, outcomeEncoder);
        this.models = models;
    }

    public String classify(List<Feature> features) throws CleartkProcessingException {
        Map<String, Double> scores = this.score(features);
        Ordering byScore = Ordering.natural().onResultOf(Functions.forMap(scores));
        return (String)byScore.max(scores.keySet());
    }

    public Map<String, Double> score(List<Feature> features) throws CleartkProcessingException {
        TreeFeatureVector featureVector = (TreeFeatureVector)this.featuresEncoder.encodeAll(features);
        HashMap results = Maps.newHashMap();
        for (int i : this.models.keySet()) {
            double score = this.predict(featureVector, i);
            String name = (String)this.outcomeEncoder.decode((Object)i);
            results.put(name, score);
        }
        return results;
    }

    private double predict(TreeFeatureVector featureVector, int i) {
        return this.models.get(i).evaluate(featureVector);
    }
}

