/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.ClassifierBuilder_ImplBase;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeClassifierBuilder;
import org.cleartk.ml.tksvmlight.TreeKernelSvmStringOutcomeClassifier;
import org.cleartk.ml.tksvmlight.model.TreeKernelSvmModel;

@Beta
public abstract class TreeKernelSvmStringOutcomeClassifierBuilder
extends ClassifierBuilder_ImplBase<TreeKernelSvmStringOutcomeClassifier, TreeFeatureVector, String, Integer> {
    protected TreeMap<Integer, TreeKernelSvmModel> models;
    protected TreeKernelSvmBooleanOutcomeClassifierBuilder<?> builder = null;

    public abstract String getPackageName();

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data-allfalse." + this.getPackageName());
    }

    public File getTrainingDataFile(File dir, int label) {
        return new File(dir, String.format("training-data-%d.%s", label, this.getPackageName()));
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        for (File file : dir.listFiles()) {
            if (!file.getName().matches("training-data-\\d+." + this.getPackageName())) continue;
            this.builder.trainClassifier(file, args);
        }
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        File modelFile;
        super.packageClassifier(dir, modelStream);
        int label = 1;
        while ((modelFile = new File(dir, String.format("training-data-%d.%s.model", label, this.getPackageName()))).exists()) {
            String modelName = String.format("model-%d.%s", label, this.getPackageName());
            JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)modelName, (File)modelFile);
            ++label;
        }
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        TreeKernelSvmModel model;
        super.unpackageClassifier(modelStream);
        this.models = new TreeMap();
        int label = 1;
        while ((model = this.getNextModel(modelStream, label)) != null) {
            this.models.put(label, model);
            ++label;
        }
        if (this.models.isEmpty()) {
            throw new IOException(String.format("no models found in %s", modelStream));
        }
    }

    private TreeKernelSvmModel getNextModel(JarInputStream modelStream, int label) throws IOException {
        JarEntry entry = modelStream.getNextJarEntry();
        if (entry == null) {
            return null;
        }
        String expectedName = String.format("model-%d.%s", label, this.getPackageName());
        if (!entry.getName().equals(expectedName)) {
            throw new IOException(String.format("expected next jar entry to be %s, found %s", expectedName, entry.getName()));
        }
        TreeKernelSvmModel model = TreeKernelSvmModel.fromInputStream(modelStream);
        return model;
    }

    protected TreeKernelSvmStringOutcomeClassifier newClassifier() {
        return new TreeKernelSvmStringOutcomeClassifier((FeaturesEncoder<TreeFeatureVector>)this.featuresEncoder, (OutcomeEncoder<String, Integer>)this.outcomeEncoder, this.models);
    }
}

