/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.feature.syntax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.syntax.constituent.type.TreebankNode;

public class SiblingExtractor
implements FeatureExtractor1<TreebankNode> {
    private int offset;
    private String name;
    private FeatureExtractor1<TreebankNode> subExtractor;

    public SiblingExtractor(int offset, FeatureExtractor1<TreebankNode> subExtractor) {
        this.offset = offset;
        this.subExtractor = subExtractor;
        this.name = offset < 0 ? (Math.abs(offset) > 1 ? String.format("%dLeftSibling", new Object[0]) : "LeftSibling") : (offset > 0 ? (Math.abs(offset) > 1 ? String.format("%dRightSibling", new Object[0]) : "RightSibling") : "");
    }

    public List<Feature> extract(JCas jCas, TreebankNode node) throws CleartkExtractorException {
        TreebankNode parent = node.getParent();
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList children = Lists.newArrayList((Iterable)JCasUtil.select((FSArray)parent.getChildren(), TreebankNode.class));
        int index = children.indexOf(node);
        int siblingIndex = index + this.offset;
        if (siblingIndex < 0 || siblingIndex >= children.size()) {
            return Collections.emptyList();
        }
        TreebankNode sibling = (TreebankNode)children.get(siblingIndex);
        List features = this.subExtractor.extract(jCas, (Annotation)sibling);
        for (Feature feature : features) {
            feature.setName(Feature.createName((String[])new String[]{this.name, feature.getName()}));
        }
        return features;
    }
}

