/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.clinicalpipeline.ae;

import java.util.HashSet;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.WordTokenUtil;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.util.Pair;
import org.apache.ctakes.typesystem.type.util.Pairs;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Extraction Prepper", description="Assigns IDs and Canonical text to Identified Annotations.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class ExtractionPrepAnnotator
extends JCasAnnotator_ImplBase {
    private String iv_annotVerPropKey;
    private int iv_annotVer;

    public void initialize(UimaContext aCtx) throws ResourceInitializationException {
        super.initialize(aCtx);
        try {
            this.iv_annotVer = (Integer)aCtx.getConfigParameterValue("AnnotationVersion");
            this.iv_annotVerPropKey = (String)aCtx.getConfigParameterValue("AnnotationVersionPropKey");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.generateUidValues(jcas);
        this.generateTokenNormForms(jcas);
        this.assignNamedEntityFeats(jcas);
        this.storeAnnotationVersion(jcas);
    }

    private void storeAnnotationVersion(JCas jcas) {
        FSIterator itr = jcas.getJFSIndexRepository().getAllIndexedFS(Pairs.type);
        if (itr == null || !itr.hasNext()) {
            return;
        }
        Pairs props = (Pairs)itr.next();
        FSArray propArr = props.getPairs();
        FSArray newPropArr = new FSArray(jcas, propArr.size() + 1);
        for (int i = 0; i < propArr.size(); ++i) {
            newPropArr.set(i, propArr.get(i));
        }
        Pair annotVerProp = new Pair(jcas);
        annotVerProp.setAttribute(this.iv_annotVerPropKey);
        annotVerProp.setValue(String.valueOf(this.iv_annotVer));
        newPropArr.set(newPropArr.size() - 1, (FeatureStructure)annotVerProp);
        props.setPairs(newPropArr);
    }

    private void generateUidValues(JCas jcas) {
        int uid = 0;
        for (IdentifiedAnnotation idAnnot : jcas.getJFSIndexRepository().getAnnotationIndex(IdentifiedAnnotation.type)) {
            idAnnot.setId(uid);
            ++uid;
        }
    }

    private void generateTokenNormForms(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (Annotation annotation : indexes.getAnnotationIndex(BaseToken.type)) {
            if (!(annotation instanceof WordToken)) continue;
            ((WordToken)annotation).setNormalizedForm(WordTokenUtil.getCanonicalForm((WordToken)((WordToken)annotation)));
        }
    }

    private void assignNamedEntityFeats(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        HashSet segmentSet = new HashSet();
        FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
        while (segmentItr.hasNext()) {
            segmentSet.add(segmentItr.next());
        }
        for (IdentifiedAnnotation neAnnot : indexes.getAnnotationIndex(IdentifiedAnnotation.type)) {
            FSArray ocArr;
            for (Segment seg : segmentSet) {
                if (neAnnot.getBegin() < seg.getBegin() || neAnnot.getEnd() > seg.getEnd()) continue;
                neAnnot.setSegmentID(seg.getId());
                break;
            }
            if ((ocArr = neAnnot.getOntologyConceptArr()) == null) continue;
            for (int i = 0; i < ocArr.size(); ++i) {
                OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                String code = oc.getCode();
                String scheme = oc.getCodingScheme();
                StringBuffer oid = new StringBuffer();
                oid.append(code);
                oid.append("#");
                oid.append(scheme);
                oc.setOid(oid.toString());
            }
        }
    }
}

