/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.AbortCasProcessorException;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasDataConsumer;
import org.apache.uima.collection.base_cpm.CasDataProcessor;
import org.apache.uima.collection.base_cpm.CasDataStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasObjectProcessor;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.base_cpm.SkipCasException;
import org.apache.uima.collection.impl.CasConverter;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.container.CasObjectNetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.NetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPECasPool;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.WorkUnit;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.vinci.DATACasUtils;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class NonThreadedProcessingUnit {
    public int threadState = 0;
    protected CPECasPool casPool;
    protected boolean relaseCAS = false;
    protected CPMEngine cpm = null;
    protected BoundedWorkQueue workQueue = null;
    protected BoundedWorkQueue outputQueue = null;
    protected CasConverter mConverter;
    protected ProcessTrace processingUnitProcessTrace;
    protected LinkedList processContainers = new LinkedList();
    protected long numToProcess = 0L;
    protected CAS[] casList;
    protected ArrayList statusCbL = new ArrayList();
    protected boolean notifyListeners = false;
    protected CAS conversionCas = null;
    protected Object[] artifact = null;
    protected CAS[] conversionCasArray;
    protected UimaTimer timer;
    protected String threadId = null;
    protected CpeConfiguration cpeConfiguration = null;
    private CAS[] casCache = null;

    public NonThreadedProcessingUnit(CPMEngine acpm, BoundedWorkQueue aInputQueue, BoundedWorkQueue aOutputQueue) {
        this.cpm = acpm;
        try {
            this.cpeConfiguration = this.cpm.getCpeConfig();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.workQueue = aInputQueue;
        this.conversionCasArray = new CAS[1];
        this.mConverter = new CasConverter();
        this.outputQueue = aOutputQueue;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_initialize_pipeline__FINEST", new Object[]{Thread.currentThread().getName(), this.workQueue.getName(), String.valueOf(this.workQueue.getCurrentSize())});
        }
    }

    public NonThreadedProcessingUnit(CPMEngine acpm) {
        this.cpm = acpm;
        try {
            this.cpeConfiguration = this.cpm.getCpeConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conversionCasArray = new CAS[1];
        this.mConverter = new CasConverter();
    }

    public void setInputQueue(BoundedWorkQueue aInputQueue) {
        this.workQueue = aInputQueue;
    }

    public void setOutputQueue(BoundedWorkQueue aOutputQueue) {
        this.outputQueue = aOutputQueue;
    }

    public void setCPMEngine(CPMEngine acpm) {
        this.cpm = acpm;
    }

    public void cleanup() {
        this.casPool = null;
        this.cpm = null;
        this.workQueue = null;
        this.outputQueue = null;
        this.mConverter = null;
        this.processingUnitProcessTrace = null;
        this.processContainers.clear();
        this.processContainers = null;
        this.casList = null;
        this.conversionCas = null;
        this.artifact = null;
        this.statusCbL = null;
        this.conversionCasArray = null;
    }

    public void setNotifyListeners(boolean aDoNotify) {
        this.notifyListeners = aDoNotify;
    }

    public void addStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.statusCbL.add(aListener);
    }

    public ArrayList getCallbackListeners() {
        return this.statusCbL;
    }

    public void removeStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.statusCbL.remove(aListener);
    }

    public void setProcessingUnitProcessTrace(ProcessTrace aProcessingUnitProcessTrace) {
        this.processingUnitProcessTrace = aProcessingUnitProcessTrace;
    }

    public void setUimaTimer(UimaTimer aTimer) {
        this.timer = aTimer;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_timer_class__FINEST", new Object[]{Thread.currentThread().getName(), this.timer.getClass().getName()});
        }
    }

    public void setContainers(LinkedList processorList) {
        this.processContainers = processorList;
    }

    public void disableCasProcessor(int aCasProcessorIndex) {
        if (aCasProcessorIndex < 0 || aCasProcessorIndex > this.processContainers.size()) {
            return;
        }
        ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(aCasProcessorIndex);
        if (pc != null) {
            pc.setStatus(3);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), pc.getName()});
            }
        }
    }

    public void disableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.processContainers.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            pc.setStatus(3);
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), pc.getName()});
        }
    }

    public void enableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.processContainers.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.processContainers.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), pc.getName()});
            }
            pc.setStatus(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean analyze(Object[] aCasObjectList, ProcessTrace pTrTemp) throws Exception {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_start_analysis__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        CasProcessor processor = null;
        boolean doneAlready = false;
        if (aCasObjectList == null || aCasObjectList[0] == null) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_cas_reference__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
            return false;
        }
        Object casObjects = null;
        boolean isCasObject = aCasObjectList[0] instanceof CAS;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_entering_pipeline__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        ProcessingContainer container = null;
        String containerName = "";
        block5: for (int i = 0; this.processContainers != null && i < this.processContainers.size(); ++i) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_retrieve_container__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(i)});
            }
            if (this.containerDisabled(container = (ProcessingContainer)this.processContainers.get(i)) || this.filterOutTheCAS(container, isCasObject, aCasObjectList)) continue;
            containerName = container.getName();
            boolean retry = false;
            do {
                block63: {
                    block59: {
                        block56: {
                            block57: {
                                boolean bl;
                                block62: {
                                    block58: {
                                        if (System.getProperty("SHOW_MEMORY") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_memory__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().totalMemory() / 1024L), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
                                        }
                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkout_cp_from_container__FINEST", new Object[]{Thread.currentThread().getName(), containerName});
                                        }
                                        this.threadState = 2004;
                                        processor = container.getCasProcessor();
                                        if (processor == null) {
                                            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                                                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkout_null_cp_from_container__SEVERE", new Object[]{Thread.currentThread().getName(), containerName});
                                            }
                                            throw new ResourceProcessException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_component_reference__WARNING", new Object[]{Thread.currentThread().getName(), "CasProcessor", "NULL"}), null);
                                        }
                                        if (this.isProcessorReady(container.getStatus())) break block56;
                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_not_ready__FINEST", new Object[]{Thread.currentThread().getName(), containerName});
                                        }
                                        if (container.getStatus() != 5) break block57;
                                        container.releaseCasProcessor(processor);
                                        bl = false;
                                        if (retry) break block58;
                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                                        }
                                        if (this.isProcessorReady(container.getStatus())) {
                                            this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                        }
                                        break block62;
                                    }
                                    container.incrementRetryCount(1);
                                }
                                if (processor != null) {
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                    }
                                    this.doReleaseCasProcessor(container, processor);
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                    }
                                    processor = null;
                                }
                                return bl;
                            }
                            if (!retry) {
                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                                }
                                if (this.isProcessorReady(container.getStatus())) {
                                    this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                }
                            } else {
                                container.incrementRetryCount(1);
                            }
                            if (processor == null) continue block5;
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                            }
                            this.doReleaseCasProcessor(container, processor);
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                            }
                            processor = null;
                            continue block5;
                        }
                        try {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkedout_cp_from_container__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                            }
                            if (processor instanceof CasDataProcessor) {
                                this.invokeCasDataCasProcessor(container, processor, aCasObjectList, pTrTemp, isCasObject, retry);
                                isCasObject = false;
                            } else if (processor instanceof CasObjectProcessor) {
                                this.invokeCasObjectCasProcessor(container, processor, aCasObjectList, pTrTemp, isCasObject);
                                isCasObject = true;
                            }
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_analysis_successfull__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                            }
                            retry = false;
                            if (!this.cpm.dropCasOnException()) {
                                container.resetRestartCount();
                            }
                            if (retry) break block59;
                        }
                        catch (Exception e) {
                            block60: {
                                boolean bl;
                                block64: {
                                    block61: {
                                        try {
                                            retry = this.handleErrors(e, container, processor, pTrTemp, aCasObjectList, isCasObject);
                                            if (!this.cpm.dropCasOnException()) break block60;
                                            retry = false;
                                            bl = false;
                                            if (retry) break block61;
                                        }
                                        catch (Throwable throwable) {
                                            if (!retry) {
                                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                                                }
                                                if (this.isProcessorReady(container.getStatus())) {
                                                    this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                                }
                                            } else {
                                                container.incrementRetryCount(1);
                                            }
                                            if (processor != null) {
                                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                                }
                                                this.doReleaseCasProcessor(container, processor);
                                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                                }
                                                processor = null;
                                            }
                                            throw throwable;
                                        }
                                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                                        }
                                        if (this.isProcessorReady(container.getStatus())) {
                                            this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                        }
                                        break block64;
                                    }
                                    container.incrementRetryCount(1);
                                }
                                if (processor != null) {
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                    }
                                    this.doReleaseCasProcessor(container, processor);
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                                    }
                                    processor = null;
                                }
                                return bl;
                            }
                            if (!retry) {
                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                                }
                                if (this.isProcessorReady(container.getStatus())) {
                                    this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                                }
                            } else {
                                container.incrementRetryCount(1);
                            }
                            if (processor == null) continue;
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                            }
                            this.doReleaseCasProcessor(container, processor);
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                            }
                            processor = null;
                        }
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName()});
                        }
                        if (this.isProcessorReady(container.getStatus())) {
                            this.doEndOfBatch(container, processor, pTrTemp, aCasObjectList.length);
                        }
                        break block63;
                    }
                    container.incrementRetryCount(1);
                }
                if (processor == null) continue;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                }
                this.doReleaseCasProcessor(container, processor);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_ok_release_cp__FINEST", new Object[]{Thread.currentThread().getName(), containerName, processor.getClass().getName(), String.valueOf(this.casCache == null)});
                }
                processor = null;
            } while (retry);
        }
        this.postAnalysis(aCasObjectList, isCasObject, casObjects, pTrTemp, doneAlready);
        casObjects = null;
        return true;
    }

    public void setReleaseCASFlag(boolean aFlag) {
        this.relaseCAS = aFlag;
    }

    public void setCasPool(CPECasPool aPool) {
        this.casPool = aPool;
    }

    private void postAnalysis(Object[] aCasObjectList, boolean isCasObject, Object[] casObjects, ProcessTrace aProcessTr, boolean doneAlready) throws Exception {
        block20: {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pipeline_completed__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                if (!doneAlready && this.notifyListeners) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_notify_listeners__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    this.threadState = 2013;
                    EntityProcessStatusImpl aEntityProcStatus = new EntityProcessStatusImpl(aProcessTr);
                    this.notifyListeners(aCasObjectList, isCasObject, aEntityProcStatus);
                    this.threadState = 2014;
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_notify_listeners__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                }
                if (this.outputQueue == null || !this.cpm.isRunning() && (this.cpm.isRunning() || this.cpm.isHardKilled())) break block20;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cas_to_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.outputQueue.getName(), String.valueOf(this.outputQueue.getCurrentSize())});
                }
                WorkUnit workUnit = new WorkUnit(aCasObjectList);
                if (this.casCache != null && this.casCache[0] != null) {
                    workUnit.setCas(this.casCache);
                }
                this.threadState = 2015;
                this.outputQueue.enqueue(workUnit);
                this.casCache = null;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.outputQueue == null && casObjects != null && casObjects instanceof CasData[]) {
                        if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_with_cas__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
                        }
                        for (int i = 0; i < casObjects.length; ++i) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_local_cache__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casCache == null)});
                            }
                            casObjects[i] = null;
                            aCasObjectList[i] = null;
                            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_local_cache__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casCache == null)});
                        }
                        if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_total_memory__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (this.outputQueue == null && casObjects != null && casObjects instanceof CasData[]) {
            if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_with_cas__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
            }
            for (int i = 0; i < casObjects.length; ++i) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_local_cache__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casCache == null)});
                }
                casObjects[i] = null;
                aCasObjectList[i] = null;
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_local_cache__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casCache == null)});
            }
            if (System.getProperty("DEBUG_RELEASE") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_total_memory__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
            }
        }
        return;
    }

    private void doReleaseCasProcessor(ProcessingContainer aContainer, CasProcessor aCasProcessor) {
        if (aCasProcessor != null && aContainer != null) {
            aContainer.releaseCasProcessor(aCasProcessor);
        }
    }

    private void doEndOfBatch(ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTr, int howManyCases) {
        block3: {
            String containerName = aContainer.getName();
            try {
                aContainer.isEndOfBatch(aProcessor, howManyCases);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch_completed__FINEST", new Object[]{Thread.currentThread().getName(), containerName});
                }
            }
            catch (Exception ex) {
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break block3;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_end_of_batch_exception__SEVERE", new Object[]{Thread.currentThread().getName(), containerName, ex.getMessage()});
            }
        }
    }

    private boolean handleErrors(Throwable e, ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTrace, Object[] aCasObjectList, boolean isCasObject) throws Exception {
        boolean retry = true;
        String containerName = aContainer.getName();
        e.printStackTrace();
        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, Thread.currentThread().getName(), e);
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_handle_exception__SEVERE", new Object[]{Thread.currentThread().getName(), containerName, aProcessor.getClass().getName(), e.getMessage()});
        }
        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(aProcessTrace);
        enProcSt.addEventStatus("Process", "Failed", e);
        this.threadState = 2008;
        this.notifyListeners(aCasObjectList, isCasObject, enProcSt);
        this.threadState = 2009;
        if (this.cpm.dropCasOnException()) {
            if (this.casCache != null) {
                this.clearCasCache();
            }
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_drop_cas__WARNING", new Object[]{Thread.currentThread().getName(), containerName, aProcessor.getClass().getName()});
            this.cpm.invalidateCASes((CAS[])aCasObjectList);
            retry = false;
        }
        if (aProcessor instanceof CasObjectNetworkCasProcessorImpl && aContainer.isPaused()) {
            this.threadState = 2010;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_paused_do_retry__FINEST", new Object[]{Thread.currentThread().getName(), containerName});
            }
            return true;
        }
        if (e instanceof Exception && this.pauseContainer(aContainer, (Exception)e, this.threadId)) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pausing_container__FINEST", new Object[]{Thread.currentThread().getName(), containerName});
            }
            this.threadState = 2011;
            aContainer.pause();
            this.threadId = Thread.currentThread().getName();
        }
        try {
            aContainer.incrementCasProcessorErrors(e);
        }
        catch (AbortCPMException ex) {
            retry = false;
            if (aContainer.isPaused()) {
                aContainer.resume();
            }
            aContainer.setStatus(5);
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_abort_cpm__SEVERE", new Object[]{Thread.currentThread().getName(), aProcessor.getClass().getName()});
            }
            throw new AbortCPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_abort__WARNING", new Object[]{Thread.currentThread().getName(), containerName}));
        }
        catch (AbortCasProcessorException ex) {
            retry = false;
            if (aContainer.isPaused()) {
                aContainer.resume();
            }
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_cp__SEVERE", new Object[]{Thread.currentThread().getName(), aProcessor.getClass().getName()});
            }
            aContainer.setStatus(3);
        }
        catch (ServiceConnectionException ex) {
            aProcessTrace.startEvent(containerName, "Process", "");
            String status = "failure";
            try {
                this.threadState = 2012;
                this.handleServiceException(aContainer, aProcessor, aProcessTrace, ex);
                status = "success";
            }
            catch (ResourceProcessException rpe) {
                throw rpe;
            }
            catch (Exception rpe) {
                throw new ResourceProcessException((Throwable)rpe);
            }
            finally {
                aProcessTrace.endEvent(containerName, "Process", status);
            }
        }
        catch (SkipCasException ex) {
            try {
                this.handleSkipCasProcessor(aContainer, aCasObjectList, false);
                retry = false;
            }
            catch (Exception sEx) {
                throw new ResourceProcessException((Throwable)sEx);
            }
        }
        catch (Exception ex) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, Thread.currentThread().getName(), e);
            }
            retry = false;
            ex.printStackTrace();
        }
        return retry;
    }

    private void invokeCasObjectCasProcessor(ProcessingContainer container, CasProcessor processor, Object[] aCasObjectList, ProcessTrace pTrTemp, boolean isCasObject) throws Exception {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_memory__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().totalMemory() / 1024L), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invoke_cp_process__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
        }
        this.casList = new CAS[aCasObjectList.length];
        for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_initialize_cas__FINEST", new Object[]{Thread.currentThread().getName(), container.getName()});
            }
            if (aCasObjectList[casIndex] == null) {
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casobjectlist_is_null__SEVERE", new Object[]{Thread.currentThread().getName(), container.getName(), String.valueOf(casIndex)});
                break;
            }
            if (!isCasObject) {
                this.convertCasDataToCasObject(casIndex, container.getName(), aCasObjectList);
            } else {
                this.casList[casIndex] = (CAS)aCasObjectList[casIndex];
            }
            if (processor instanceof AnalysisEngine) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
                }
                this.threadState = 2005;
                pTrTemp.aggregate(((AnalysisEngine)processor).process(this.casList[casIndex]));
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process_completed__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
                continue;
            }
            pTrTemp.startEvent(container.getName(), "Process", "");
            this.threadState = 2006;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
            }
            ((CasObjectProcessor)processor).processCas(this.casList[casIndex]);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process_completed__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
            }
            pTrTemp.endEvent(container.getName(), "Process", "success");
        }
        aCasObjectList = this.casList;
    }

    private void convertCasDataToCasObject(int casIndex, String aContainerName, Object[] aCasObjectList) throws Exception {
        if (this.casCache == null || this.casCache[casIndex] == null) {
            this.casList[casIndex] = null;
            while (this.casList[casIndex] == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_get_cas_from_pool__FINEST", new Object[]{Thread.currentThread().getName(), aContainerName});
                }
                this.casList[casIndex] = this.casPool.getCas(0L);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_cas_from_pool__FINEST", new Object[]{Thread.currentThread().getName(), aContainerName});
            }
            if (this.casList[casIndex] != null) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cas_reset__FINEST", new Object[]{Thread.currentThread().getName(), aContainerName});
                }
                this.casList[casIndex].reset();
            }
        } else {
            this.casList[casIndex] = this.casCache[casIndex];
            this.casList[casIndex].reset();
            this.casCache[casIndex] = null;
        }
        this.mConverter.casDataToCasContainer((CasData)aCasObjectList[casIndex], this.casList[casIndex], true);
    }

    private void invokeCasDataCasProcessor(ProcessingContainer container, CasProcessor processor, Object[] aCasObjectList, ProcessTrace pTrTemp, boolean isCasObject, boolean retry) throws Exception {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invoke_cp_process__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
        }
        pTrTemp.startEvent(container.getName(), "Process", "");
        if (isCasObject) {
            CasData[] casDataObjects = new CasData[aCasObjectList.length];
            for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                casDataObjects[casIndex] = this.mConverter.casContainerToCasData((CAS)aCasObjectList[casIndex]);
                if ((CAS)aCasObjectList[casIndex] == null) continue;
                ((CAS)aCasObjectList[casIndex]).reset();
            }
            this.casCache = (CAS[])aCasObjectList;
            aCasObjectList = casDataObjects;
        }
        long byteCount = 0L;
        if (!retry) {
            for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                byteCount = this.getBytes(aCasObjectList[casIndex]);
                container.addBytesIn(byteCount);
            }
        }
        Object[] casObjects = aCasObjectList;
        long pStart = System.currentTimeMillis();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casobject_class__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), casObjects.getClass().getName()});
        }
        if (!(casObjects instanceof CasData[]) && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_expected_casdata_class__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), casObjects.getClass().getName()});
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
        }
        casObjects = ((CasDataProcessor)processor).process((CasData[])casObjects);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_process_completed__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), processor.getClass().getName()});
        }
        long pEnd = System.currentTimeMillis();
        container.incrementTotalTime(pEnd - pStart);
        if (casObjects != null) {
            if (processor instanceof CasDataConsumer) {
                container.addBytesOut(byteCount);
            } else {
                aCasObjectList = casObjects;
                if (!retry) {
                    for (int casIndex = 0; casIndex < aCasObjectList.length; ++casIndex) {
                        byteCount = this.getBytes(aCasObjectList[casIndex]);
                        container.addBytesOut(byteCount);
                    }
                }
            }
        }
        pTrTemp.endEvent(container.getName(), "Process", "success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containerDisabled(ProcessingContainer aContainer) {
        ProcessingContainer processingContainer = aContainer;
        synchronized (processingContainer) {
            if (!this.isProcessorReady(aContainer.getStatus())) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_not_ready__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName()});
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isProcessorReady(int aStatus) {
        return aStatus == 1 || aStatus == 2;
    }

    private boolean filterOutTheCAS(ProcessingContainer aContainer, boolean isCasObject, Object[] aCasObjectList) {
        if (!isCasObject && !aContainer.processCas(aCasObjectList)) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_skip_CAS__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName()});
            }
            aContainer.incrementFilteredCount(aCasObjectList.length);
            aContainer.logAbortedCases(aCasObjectList);
            return true;
        }
        return false;
    }

    protected void notifyListeners(Object aCas, boolean isCasObject, EntityProcessStatus aEntityProcStatus) {
        if (aCas instanceof Object[]) {
            for (int i = 0; i < ((Object[])aCas).length; ++i) {
                this.doNotifyListeners(((Object[])aCas)[i], isCasObject, aEntityProcStatus);
            }
        } else {
            this.doNotifyListeners(aCas, isCasObject, aEntityProcStatus);
        }
    }

    protected void doNotifyListeners(Object aCas, boolean isCasObject, EntityProcessStatus aEntityProcStatus) {
        Object casObjectCopy = aCas;
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
            if (statCL instanceof CasDataStatusCallbackListener) {
                if (isCasObject) {
                    casObjectCopy = this.mConverter.casContainerToCasData((CAS)casObjectCopy);
                }
                ((CasDataStatusCallbackListener)statCL).entityProcessComplete((CasData)casObjectCopy, aEntityProcStatus);
                continue;
            }
            if (!(statCL instanceof StatusCallbackListener)) continue;
            boolean casFromPool = false;
            if (!isCasObject) {
                this.conversionCas = null;
                if (this.casCache != null && this.casCache[0] != null) {
                    this.conversionCas = this.casCache[0];
                } else {
                    while (this.conversionCas == null) {
                        this.conversionCas = this.casPool.getCas(0L);
                    }
                    casFromPool = true;
                }
                try {
                    this.mConverter.casDataToCasContainer((CasData)casObjectCopy, this.conversionCas, true);
                }
                catch (CollectionException e) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_converting_CAS__WARNING", new Object[]{Thread.currentThread().getName()});
                }
                casObjectCopy = this.conversionCas;
            }
            CPMEngine.callEntityProcessCompleteWithCAS((StatusCallbackListener)statCL, (CAS)casObjectCopy, aEntityProcStatus);
            if (this.conversionCas == null) continue;
            if (casFromPool) {
                this.conversionCasArray[0] = this.conversionCas;
                this.cpm.releaseCASes(this.conversionCasArray);
            }
            this.conversionCas = null;
            if (this.casCache == null || this.casCache[0] == null) continue;
            this.casCache[0].reset();
        }
    }

    private void clearCasCache() {
        if (this.casCache != null) {
            for (int index = 0; index < this.casCache.length; ++index) {
                if (this.casCache[index] == null) continue;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cas_from_cache__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                this.casPool.releaseCas(this.casCache[index]);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_cas_from_cache_done__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            this.casCache = null;
        }
    }

    private boolean pauseContainer(ProcessingContainer aContainer, Exception aException, String aThreadId) {
        return aContainer.isRemote() && aContainer.isSingleFencedService() && aException.getCause() instanceof ServiceConnectionException && aThreadId == null;
    }

    private void handleServiceException(ProcessingContainer aContainer, CasProcessor aProcessor, ProcessTrace aProcessTr, Exception ex) throws Exception {
        if (aProcessor instanceof NetworkCasProcessorImpl) {
            ((NetworkCasProcessorImpl)aProcessor).collectionProcessComplete(aProcessTr);
        }
        aContainer.releaseCasProcessor(aProcessor);
        if (aContainer.isRemote() && aContainer.isSingleFencedService()) {
            if (Thread.currentThread().getName().equals(this.threadId)) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_connection_exception__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
                }
                aProcessTr.startEvent(aContainer.getName(), "Process", "");
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_redeploy_cp__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
                }
                this.cpm.redeployAnalysisEngine(aContainer);
                aContainer.resume();
                this.threadId = null;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_redeploy_cp_done__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
                }
            }
        } else {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_connection_exception__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
            }
            aProcessTr.startEvent(aContainer.getName(), "Process", "");
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_redeploy_cp__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
            }
            this.cpm.redeployAnalysisEngine(aContainer);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_redeploy_cp_done__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName(), aProcessor.getClass().getName()});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSkipCasProcessor(ProcessingContainer aContainer, Object[] aCasObjectList, boolean isLastCP) throws Exception {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_skip_CAS__FINEST", new Object[]{Thread.currentThread().getName(), aContainer.getName()});
        }
        if (aContainer.isPaused()) {
            aContainer.resume();
        }
        aContainer.incrementAbortCount(aCasObjectList.length);
        if (this.cpm.dropCasOnException()) return;
        try {
            aContainer.logAbortedCases(aCasObjectList);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseCases(this.casList, isLastCP, aContainer.getName());
                    throw throwable;
                }
                catch (Exception ex2) {
                    if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) throw throwable;
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_releasing_cas__SEVERE", new Object[]{Thread.currentThread().getName(), aContainer.getName()});
                    throw ex2;
                }
            }
        }
        try {
            this.releaseCases(this.casList, isLastCP, aContainer.getName());
            return;
        }
        catch (Exception ex2) {
            if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) return;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_releasing_cas__SEVERE", new Object[]{Thread.currentThread().getName(), aContainer.getName()});
            throw ex2;
        }
    }

    protected long getBytes(Object aCas) {
        try {
            if (aCas instanceof CasData) {
                return DATACasUtils.getByteCount((CasData)aCas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private void releaseCases(Object aCasList, boolean lastProcessor, String aName) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_releasing_cases__FINEST", new Object[]{Thread.currentThread().getName(), aName, String.valueOf(this.relaseCAS), String.valueOf(lastProcessor)});
        }
        if (aCasList == null) {
            return;
        }
        if (this.relaseCAS && lastProcessor) {
            if (aCasList instanceof CAS[]) {
                if (this.casCache != null) {
                    this.cpm.releaseCASes(this.casCache);
                    this.casCache = null;
                }
                this.cpm.releaseCASes((CAS[])aCasList);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_releasing_cases__FINEST", new Object[]{Thread.currentThread().getName(), aName});
                }
            } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casobject_class__FINEST", new Object[]{Thread.currentThread().getName(), aName, aCasList.getClass().getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCasProcessors(boolean kill) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_containers__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        for (int i = 0; this.processContainers != null && i < this.processContainers.size(); ++i) {
            ProcessingContainer container = (ProcessingContainer)this.processContainers.get(i);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_container_time__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), String.valueOf(container.getTotalTime())});
            }
            ProcessingContainer processingContainer = container;
            synchronized (processingContainer) {
                if (kill || !this.cpm.isRunning() && this.isProcessorReady(container.getStatus())) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_kill_cp__FINEST", new Object[]{Thread.currentThread().getName(), container.getName()});
                    }
                    container.setStatus(5);
                } else if (container.getStatus() != 3) {
                    container.setStatus(4);
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_status__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), String.valueOf(container.getStatus())});
                }
                ProcessTrace_impl pTrTemp = new ProcessTrace_impl(this.cpm.getPerformanceTuningSettings());
                pTrTemp.startEvent(container.getName(), "End of Batch", "");
                try {
                    CasProcessorDeployer deployer = container.getDeployer();
                    if (deployer != null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_undeploy_cp_instances__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), deployer.getClass().getName()});
                        }
                        deployer.undeploy();
                    }
                    container.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    pTrTemp.endEvent(container.getName(), "End of Batch", "");
                    if (this.processingUnitProcessTrace != null) {
                        this.processingUnitProcessTrace.aggregate((ProcessTrace)pTrTemp);
                    }
                }
                continue;
            }
        }
    }
}

