/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.util;

import java.util.Collection;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationTreeUtils {
    public static TopTreebankNode getAnnotationTree(JCas jcas, Annotation annot) {
        TopTreebankNode tree = null;
        Collection roots = JCasUtil.select((JCas)jcas, TopTreebankNode.class);
        for (TopTreebankNode root : roots) {
            if (root.getBegin() > annot.getBegin() || root.getEnd() < annot.getEnd()) continue;
            tree = root;
            break;
        }
        return tree;
    }

    public static TopTreebankNode getTreeCopy(JCas jcas, TopTreebankNode orig) {
        if (orig == null) {
            return null;
        }
        TopTreebankNode copy = new TopTreebankNode(jcas);
        copy.setNodeType(orig.getNodeType());
        copy.setBegin(orig.getBegin());
        copy.setEnd(orig.getEnd());
        copy.setParent(null);
        copy.setChildren(new FSArray(jcas, 1));
        copy.setTreebankParse(orig.getTreebankParse());
        if (orig.getChildren() == null || orig.getChildren().size() == 0) {
            System.err.println("WHAT?");
        }
        copy.setChildren(0, AnnotationTreeUtils.getTreeCopy(jcas, orig.getChildren(0)));
        copy.getChildren(0).setParent((TreebankNode)copy);
        return copy;
    }

    public static TreebankNode getTreeCopy(JCas jcas, TreebankNode orig) {
        TerminalTreebankNode copy = null;
        if (orig instanceof TerminalTreebankNode) {
            copy = new TerminalTreebankNode(jcas);
            copy.setLeaf(true);
            copy.setChildren(null);
        } else {
            copy = new TreebankNode(jcas);
            copy.setChildren(new FSArray(jcas, orig.getChildren().size()));
            for (int i = 0; i < orig.getChildren().size(); ++i) {
                copy.setChildren(i, AnnotationTreeUtils.getTreeCopy(jcas, orig.getChildren(i)));
                copy.getChildren(i).setParent((TreebankNode)copy);
            }
        }
        copy.setNodeType(orig.getNodeType());
        copy.setNodeValue(orig.getNodeValue());
        copy.setBegin(orig.getBegin());
        copy.setEnd(orig.getEnd());
        return copy;
    }

    public static TreebankNode annotationNode(JCas jcas, Annotation annot) {
        return AnnotationTreeUtils.annotationNode(jcas, annot.getBegin(), annot.getEnd());
    }

    public static TreebankNode annotationNode(JCas jcas, int a, int b) {
        TreebankNode lowestDom = null;
        int overage = Integer.MAX_VALUE;
        for (TreebankNode node : jcas.getJFSIndexRepository().getAnnotationIndex(TreebankNode.type)) {
            int tempOver;
            if (node.getBegin() == a && node.getEnd() == b) {
                try {
                    while (node.getParent() != null && node.getParent().getChildren().size() == 1 && !node.getParent().getNodeType().equals("TOP")) {
                        node = node.getParent();
                    }
                }
                catch (NullPointerException e) {
                    System.err.println("Null pointer exception in AttributeCalculator::markableNode()");
                }
                return node;
            }
            if (node.getBegin() > a || node.getEnd() < b || (tempOver = a - node.getBegin() + (node.getEnd() - b)) >= overage) continue;
            lowestDom = node;
            overage = tempOver;
        }
        return lowestDom;
    }

    public static TerminalTreebankNode getHead(TreebankNode n) {
        TerminalTreebankNode ttn = null;
        int headIndex = n.getHeadIndex();
        ttn = AnnotationTreeUtils.getRoot(n).getTerminals(headIndex);
        return ttn;
    }

    public static TopTreebankNode getRoot(TreebankNode n) {
        TopTreebankNode ret = null;
        while (!(n instanceof TopTreebankNode)) {
            n = n.getParent();
        }
        ret = (TopTreebankNode)n;
        return ret;
    }

    public static TreebankNode insertAnnotationNode(JCas jcas, TopTreebankNode root, Annotation arg1, String nodeType) {
        TopTreebankNode tree = root;
        TopTreebankNode lastTree = null;
        block0: do {
            lastTree = tree;
            if (tree.getLeaf()) continue;
            for (int i = 0; i < tree.getChildren().size(); ++i) {
                TreebankNode child = tree.getChildren(i);
                if (child.getBegin() > arg1.getBegin() || child.getEnd() < arg1.getEnd()) continue;
                tree = child;
                continue block0;
            }
        } while (tree != lastTree);
        TreebankNode newTree = null;
        if (tree.getBegin() == arg1.getBegin() && tree.getEnd() == arg1.getEnd()) {
            while (tree.getParent() != null && tree.getParent().getBegin() == arg1.getBegin() && tree.getParent().getEnd() == arg1.getEnd()) {
                tree = tree.getParent();
            }
            newTree = new TreebankNode(jcas, tree.getBegin(), tree.getEnd());
            newTree.setNodeType(nodeType);
            newTree.setChildren(new FSArray(jcas, 1));
            newTree.setChildren(0, (TreebankNode)tree);
            newTree.setParent(tree.getParent());
            TreeUtils.replaceChild(tree.getParent(), (TreebankNode)tree, newTree);
            tree.setParent(newTree);
        } else {
            int startChild = -1;
            int endChild = -1;
            if (!tree.getLeaf()) {
                for (int i = 0; i < tree.getChildren().size(); ++i) {
                    if (startChild == -1) {
                        if (tree.getChildren(i).getBegin() != arg1.getBegin()) continue;
                        startChild = i;
                        continue;
                    }
                    if (tree.getChildren(i).getEnd() != arg1.getEnd()) continue;
                    endChild = i;
                    break;
                }
            }
            if (startChild >= 0 && endChild >= 0) {
                int i;
                newTree = new TreebankNode(jcas, tree.getChildren(startChild).getBegin(), tree.getChildren(endChild).getEnd());
                newTree.setNodeType(nodeType);
                newTree.setParent((TreebankNode)tree);
                int numStolenChildren = endChild - startChild + 1;
                newTree.setChildren(new FSArray(jcas, numStolenChildren));
                for (int i2 = startChild; i2 <= endChild; ++i2) {
                    newTree.setChildren(i2 - startChild, tree.getChildren(i2));
                }
                FSArray children = new FSArray(jcas, tree.getChildren().size() - numStolenChildren + 1);
                for (i = 0; i < startChild; ++i) {
                    children.set(i, (FeatureStructure)tree.getChildren(i));
                }
                children.set(startChild, (FeatureStructure)newTree);
                for (i = endChild + 1; i < tree.getChildren().size(); ++i) {
                    children.set(i - numStolenChildren + 1, (FeatureStructure)tree.getChildren(i));
                }
                tree.setChildren(children);
            } else {
                newTree = new TreebankNode(jcas, tree.getBegin(), tree.getEnd());
                newTree.setNodeType(nodeType);
                newTree.setChildren(new FSArray(jcas, 1));
                newTree.setChildren(0, (TreebankNode)tree);
                newTree.setParent(tree.getParent());
                TreeUtils.replaceChild(tree.getParent(), (TreebankNode)tree, newTree);
                tree.setParent(newTree);
            }
        }
        return newTree;
    }

    public static void removeRightOfAnnotation(JCas jcas, TreebankNode node, Annotation annot) {
        if (node.getEnd() <= annot.getBegin() || node.getLeaf()) {
            return;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreebankNode child = node.getChildren(i);
            if (child.getEnd() <= annot.getBegin()) continue;
            if (child.getBegin() > annot.getEnd()) {
                FSArray newChildren = new FSArray(jcas, i);
                for (int j = 0; j < i; ++j) {
                    newChildren.set(j, (FeatureStructure)node.getChildren(j));
                }
                node.setChildren(newChildren);
                break;
            }
            AnnotationTreeUtils.removeRightOfAnnotation(jcas, child, annot);
        }
    }

    public static void removeLeftOfAnnotation(JCas jcas, TreebankNode node, Annotation annot) {
        if (node.getEnd() <= annot.getBegin() || node.getLeaf()) {
            return;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreebankNode child = node.getChildren(i);
            if (child.getEnd() < annot.getBegin() || child.getEnd() <= annot.getBegin()) continue;
            if (child.getBegin() < annot.getBegin()) {
                AnnotationTreeUtils.removeLeftOfAnnotation(jcas, child, annot);
            }
            if (i <= 0) break;
            FSArray newChildren = new FSArray(jcas, node.getChildren().size() - i);
            for (int j = i; j < node.getChildren().size(); ++j) {
                newChildren.set(j - i, (FeatureStructure)node.getChildren(j));
            }
            node.setChildren(newChildren);
            break;
        }
    }

    public static TreebankNode getCommonAncestor(TreebankNode node1, TreebankNode node2) {
        TreebankNode ancestor;
        if (node1 == null || node2 == null) {
            return null;
        }
        if (AnnotationTreeUtils.dominates(node1, node2)) {
            return node1;
        }
        if (AnnotationTreeUtils.dominates(node2, node1)) {
            return node2;
        }
        if (node1.getBegin() > node2.getBegin()) {
            TreebankNode temp = node1;
            node1 = node2;
            node2 = temp;
        }
        for (ancestor = node2; ancestor != null && ancestor.getBegin() > node1.getBegin(); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public static final boolean dominates(TreebankNode node1, TreebankNode node2) {
        return node1.getBegin() <= node2.getBegin() && node1.getEnd() >= node2.getEnd();
    }
}

