/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.JewelRuntimeException;
import com.lexicalscope.jewel.cli.ValidationFailure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ArgumentValidationException
extends JewelRuntimeException {
    private static final long serialVersionUID = -4781861924515211053L;
    static final ResourceBundle m_messages = ResourceBundle.getBundle("com.lexicalscope.jewel.cli.Messages", Locale.getDefault());
    private final List<ValidationFailure> validationFailures;

    public ArgumentValidationException() {
        this(new ArrayList<ValidationFailure>());
    }

    public ArgumentValidationException(String message, Throwable cause) {
        this(message, cause, new ArrayList<ValidationFailure>());
    }

    public ArgumentValidationException(String message) {
        this(message, new ArrayList<ValidationFailure>());
    }

    public ArgumentValidationException(Throwable cause) {
        this(cause, new ArrayList<ValidationFailure>());
    }

    public ArgumentValidationException(ValidationFailure validationError) {
        this(Arrays.asList(validationError));
    }

    public ArgumentValidationException(List<ValidationFailure> validationFailures) {
        this(ArgumentValidationException.createMessageFromErrors(validationFailures), validationFailures);
    }

    public ArgumentValidationException(String message, Throwable cause, List<ValidationFailure> validationFailures) {
        super(message, cause);
        this.validationFailures = validationFailures;
    }

    public ArgumentValidationException(String message, List<ValidationFailure> validationFailures) {
        super(message);
        this.validationFailures = validationFailures;
    }

    public ArgumentValidationException(Throwable cause, List<ValidationFailure> validationFailures) {
        this(ArgumentValidationException.createMessageFromErrors(validationFailures), cause, validationFailures);
    }

    public List<ValidationFailure> getValidationFailures() {
        return this.validationFailures;
    }

    private static String createMessageFromErrors(List<ValidationFailure> validationFailures) {
        StringBuilder message = new StringBuilder();
        String separator = "";
        for (ValidationFailure error : validationFailures) {
            message.append(separator).append(error.getMessage());
            separator = System.getProperty("line.separator");
        }
        return message.toString();
    }
}

