/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedMethod;
import java.util.Arrays;
import uk.co.flamingpenguin.jewel.cli.OptionAdapter;
import uk.co.flamingpenguin.jewel.cli.OptionAnnotationAdapter;
import uk.co.flamingpenguin.jewel.cli.OptionSpecificationBuilder;
import uk.co.flamingpenguin.jewel.cli.OptionSpecificationException;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecificationBuilder;
import uk.co.flamingpenguin.jewel.cli.Unparsed;
import uk.co.flamingpenguin.jewel.cli.UnparsedAnnotationAdapter;
import uk.co.flamingpenguin.jewel.cli.UnparsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.UnparsedOptionSpecificationBuilder;

class AbstractConvertMethodToOptionSpecification {
    protected final $ReflectedClass<?> klass;

    public AbstractConvertMethodToOptionSpecification($ReflectedClass<?> klass) {
        this.klass = klass;
    }

    protected UnparsedOptionSpecification createUnparsedOptionSpecificationFrom($ReflectedMethod method) {
        UnparsedOptionSpecificationBuilder optionSpecificationBuilder = new UnparsedOptionSpecificationBuilder(method);
        UnparsedAnnotationAdapter annotation = new UnparsedAnnotationAdapter(this.klass, method, method.annotation(Unparsed.class));
        this.configureSpecificationFromAnnotation(optionSpecificationBuilder, annotation);
        optionSpecificationBuilder.setValueName(annotation.name());
        return optionSpecificationBuilder.createOptionSpecification();
    }

    protected ParsedOptionSpecification createParsedOptionSpecificationFrom($ReflectedMethod method) {
        ParsedOptionSpecificationBuilder optionSpecificationBuilder = new ParsedOptionSpecificationBuilder(method);
        OptionAnnotationAdapter annotation = new OptionAnnotationAdapter(this.klass, method);
        optionSpecificationBuilder.setShortNames(annotation.shortName());
        optionSpecificationBuilder.setLongName(annotation.longName());
        optionSpecificationBuilder.setHelpRequest(annotation.helpRequest());
        this.configureSpecificationFromAnnotation(optionSpecificationBuilder, annotation);
        return optionSpecificationBuilder.createOptionSpecification();
    }

    private void configureSpecificationFromAnnotation(OptionSpecificationBuilder optionSpecificationBuilder, OptionAdapter annotation) {
        optionSpecificationBuilder.setDescription(annotation.description().trim());
        optionSpecificationBuilder.setPattern(annotation.pattern());
        optionSpecificationBuilder.setOptionalityMethod(annotation.correspondingOptionalityMethod());
        optionSpecificationBuilder.setType(annotation.getValueType());
        optionSpecificationBuilder.setMultiValued(annotation.isMultiValued());
        if (annotation.defaultToNull() && annotation.hasDefaultValue()) {
            throw new OptionSpecificationException("option cannot have null default and non-null default value: " + annotation.method());
        }
        if (annotation.defaultToNull()) {
            optionSpecificationBuilder.setDefaultToNull(true);
            if (annotation.isMultiValued()) {
                optionSpecificationBuilder.setDefaultValue(null);
            } else {
                optionSpecificationBuilder.setDefaultValue(Arrays.asList(new String[]{null}));
            }
        } else if (annotation.hasDefaultValue()) {
            optionSpecificationBuilder.setDefaultValue(Arrays.asList(annotation.defaultValue()));
        }
    }
}

