/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import uk.co.flamingpenguin.jewel.cli.CliSpecification;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.HelpMessage;
import uk.co.flamingpenguin.jewel.cli.HelpMessageBuilderImpl;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSummary;
import uk.co.flamingpenguin.jewel.cli.UnparsedOptionSpecification;

class OptionsSpecificationImpl<O>
implements OptionsSpecification<O>,
CliSpecification {
    private final $ReflectedClass<O> klass;
    private final SortedSet<ParsedOptionSpecification> options = new TreeSet<ParsedOptionSpecification>();
    private final Map<String, ParsedOptionSpecification> optionsByName = new TreeMap<String, ParsedOptionSpecification>();
    private final Map<$ReflectedMethod, ParsedOptionSpecification> optionsMethod = new HashMap<$ReflectedMethod, ParsedOptionSpecification>();
    private final Map<$ReflectedMethod, ParsedOptionSpecification> optionalOptionsMethod = new HashMap<$ReflectedMethod, ParsedOptionSpecification>();
    private final Map<$ReflectedMethod, UnparsedOptionSpecification> unparsedOptionsMethod = new HashMap<$ReflectedMethod, UnparsedOptionSpecification>();
    private final Map<$ReflectedMethod, UnparsedOptionSpecification> unparsedOptionalOptionsMethod = new HashMap<$ReflectedMethod, UnparsedOptionSpecification>();

    OptionsSpecificationImpl($ReflectedClass<O> klass, List<ParsedOptionSpecification> optionSpecifications, List<UnparsedOptionSpecification> unparsedSpecifications) {
        this.klass = klass;
        for (ParsedOptionSpecification parsedOptionSpecification : optionSpecifications) {
            this.addOption(parsedOptionSpecification);
        }
        for (UnparsedOptionSpecification unparsedOptionSpecification : unparsedSpecifications) {
            this.addUnparsedOption(unparsedOptionSpecification);
        }
    }

    @Override
    public boolean isSpecified(String key) {
        return this.optionsByName.containsKey(key);
    }

    @Override
    public ParsedOptionSpecification getSpecification(String key) {
        return this.optionsByName.get(key);
    }

    @Override
    public ParsedOptionSpecification getSpecification($ReflectedMethod method) {
        if (this.optionsMethod.containsKey(method)) {
            return this.optionsMethod.get(method);
        }
        return this.optionalOptionsMethod.get(method);
    }

    @Override
    public List<ParsedOptionSpecification> getMandatoryOptions() {
        ArrayList<ParsedOptionSpecification> result = new ArrayList<ParsedOptionSpecification>();
        for (ParsedOptionSpecification specification : this.options) {
            if (specification.isOptional() || specification.hasDefaultValue()) continue;
            result.add(specification);
        }
        return result;
    }

    @Override
    public Iterator<ParsedOptionSpecification> iterator() {
        return new ArrayList<ParsedOptionSpecification>(this.optionsByName.values()).iterator();
    }

    @Override
    public UnparsedOptionSpecification getUnparsedSpecification() {
        return this.unparsedOptionsMethod.values().iterator().next();
    }

    @Override
    public boolean hasUnparsedSpecification() {
        return !this.unparsedOptionsMethod.values().isEmpty();
    }

    private String applicationName() {
        String applicationName;
        if (this.klass.annotatedWith(CommandLineInterface.class) && (applicationName = this.klass.annotation(CommandLineInterface.class).application()) != null && !applicationName.trim().equals("")) {
            return applicationName.trim();
        }
        return null;
    }

    private void addOption(ParsedOptionSpecification optionSpecification) {
        for (String name : optionSpecification.getNames()) {
            this.optionsByName.put(name, optionSpecification);
        }
        this.options.add(optionSpecification);
        this.optionsMethod.put(optionSpecification.getMethod(), optionSpecification);
        if (optionSpecification.isOptional()) {
            this.optionalOptionsMethod.put(optionSpecification.getOptionalityMethod(), optionSpecification);
        }
    }

    private void addUnparsedOption(UnparsedOptionSpecification optionSpecification) {
        this.unparsedOptionsMethod.put(optionSpecification.getMethod(), optionSpecification);
        if (optionSpecification.isOptional()) {
            this.unparsedOptionalOptionsMethod.put(optionSpecification.getOptionalityMethod(), optionSpecification);
        }
    }

    @Override
    public void describeTo(HelpMessage helpMessage) {
        if (!this.hasCustomApplicationName() && !this.hasUnparsedSpecification()) {
            helpMessage.noUsageInformation();
        } else {
            if (this.hasCustomApplicationName()) {
                helpMessage.hasUsageInformation(this.applicationName());
            } else {
                helpMessage.hasUsageInformation();
            }
            if (this.getMandatoryOptions().isEmpty()) {
                helpMessage.hasOnlyOptionalOptions();
            } else {
                helpMessage.hasSomeMandatoryOptions();
            }
            if (this.hasUnparsedSpecification()) {
                if (this.getUnparsedSpecification().isMultiValued()) {
                    helpMessage.hasUnparsedMultiValuedOption(this.getUnparsedSpecification().getValueName());
                } else {
                    helpMessage.hasUnparsedOption(this.getUnparsedSpecification().getValueName());
                }
            }
        }
        helpMessage.startOfOptions();
        for (ParsedOptionSpecification specification : this.options) {
            new ParsedOptionSummary(specification).describeOptionTo(helpMessage.option());
        }
        helpMessage.endOfOptions();
    }

    private boolean hasCustomApplicationName() {
        return !OptionsSpecificationImpl.nullOrBlank(this.applicationName());
    }

    static boolean nullOrBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public String toString() {
        HelpMessageBuilderImpl helpMessage = new HelpMessageBuilderImpl();
        this.describeTo(helpMessage);
        return helpMessage.toString();
    }
}

