/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToMapUnicodeToAscii
extends Transformation
implements Cloneable {
    private static final String INFO = "Map Unicode to ASCII";
    private static final String NO_OPERATION = "NO";
    private static final String MAPPING = "MP";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, String> unicodeMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToMapUnicodeToAscii.MapUnicodeToAscii(in, unicodeMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Hashtable<Character, String> GetUnicodeMapFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_UNICODE_FILE");
        String line = null;
        Hashtable<Character, String> unicodeMap = new Hashtable<Character, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                StringTokenizer buf = new StringTokenizer(line, "|", true);
                char inChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                Character unicode = new Character(inChar);
                buf.nextToken();
                int nextTokenIndex = 0;
                String mapStr = new String();
                while (buf.hasMoreTokens()) {
                    String curToken = buf.nextToken();
                    if (!curToken.equals("|")) {
                        if (nextTokenIndex == 0) {
                            mapStr = curToken;
                            break;
                        }
                        for (int i = 0; i < nextTokenIndex - 1; ++i) {
                            mapStr = mapStr + "|";
                        }
                        break;
                    }
                    ++nextTokenIndex;
                }
                if (UnicodeUtil.IsAsciiChar(inChar) || !UnicodeUtil.IsAsciiStr(mapStr)) {
                    System.err.println("** Warning: Illegal format in Unicode file: '" + fName + "'.");
                    System.err.println(line);
                    continue;
                }
                unicodeMap.put(unicode, mapStr);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: problem of opening/reading Unicode file: '" + fName + "'.");
            System.err.println("Exception: " + e.toString());
        }
        return unicodeMap;
    }

    public static String MapUnicodeToAscii(char inChar, Hashtable<Character, String> unicodeMap) {
        String outStr = UnicodeUtil.CharToStr(inChar);
        if (unicodeMap.containsKey(Character.valueOf(inChar))) {
            outStr = unicodeMap.get(Character.valueOf(inChar));
        }
        return outStr;
    }

    public static void main(String[] args) {
        String testStr = ToMapUnicodeToAscii.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, String> unicodeMap = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToMapUnicodeToAscii.Mutate(in, unicodeMap, true, true);
        ToMapUnicodeToAscii.PrintResults(in, outs);
    }

    private static Vector<LexItem> MapUnicodeToAscii(LexItem in, Hashtable<Character, String> unicodeMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String opStr = NO_OPERATION + fs;
            Character key = new Character(curChar);
            if (unicodeMap.containsKey(key)) {
                buffer.append(unicodeMap.get(key));
                opStr = MAPPING + fs;
            } else {
                buffer.append(curChar);
            }
            if (!mutateFlag) continue;
            mutate = mutate + opStr;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToMapUnicodeToAscii.UpdateLexItem(in, term, 60, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }
}

