/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.Vector;

public abstract class Transformation {
    public static final int UPDATE = -1;
    public static final String NO_MUTATE_INFO = "none" + GlobalBehavior.GetInstance().GetFieldSeparator();

    public static String GetTestStr(String[] args, String defaultStr) {
        String testStr = defaultStr;
        StringBuffer buffer = new StringBuffer();
        if (args.length > 0) {
            buffer.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                buffer.append(" ");
                buffer.append(args[i]);
            }
            testStr = buffer.toString();
        }
        return testStr;
    }

    protected static void PrintResult(LexItem out, int flowNum, boolean mutateFlag) {
        System.out.println(LexItem.GetResultString(out, "", mutateFlag, 1, false, false, false, "|"));
    }

    protected static LexItem UpdateLexItem(LexItem in, String target, String flowName, long category, long inflection, String details, String mutateInfo, boolean appendFlowFlag) {
        StringBuffer buffer;
        LexItem out = new LexItem(in, false);
        out.SetTargetTerm(target);
        if (category == -1L) {
            if (out.GetSourceCategory().GetValue() == 0L) {
                out.SetTargetCategory(2047L);
            } else {
                out.SetTargetCategory(out.GetSourceCategory().GetValue());
            }
        } else {
            out.SetTargetCategory(category);
        }
        if (inflection == -1L) {
            if (out.GetSourceInflection().GetValue() == 0L) {
                out.SetTargetInflection(0xFFFFFFL);
            } else {
                out.SetTargetInflection(out.GetSourceInflection().GetValue());
            }
        } else {
            out.SetTargetInflection(inflection);
        }
        if (details != null) {
            String detailInformation = out.GetDetailInformation();
            buffer = new StringBuffer();
            if (detailInformation == null) {
                detailInformation = "---------------------------------------" + GlobalBehavior.LS_STR;
            }
            int index = flowName.lastIndexOf("+") + 1;
            String curFlowName = flowName.substring(index);
            buffer.append(detailInformation);
            buffer.append(out.GetFlowComponentNumber());
            buffer.append(". (");
            buffer.append(curFlowName);
            buffer.append("): ");
            buffer.append(out.GetSourceTerm());
            buffer.append(" (");
            buffer.append(out.GetSourceCategory().GetValue());
            buffer.append(", ");
            buffer.append(out.GetSourceInflection().GetValue());
            buffer.append(") --> ");
            buffer.append(out.GetTargetTerm());
            buffer.append(" (");
            buffer.append(out.GetTargetCategory().GetValue());
            buffer.append(", ");
            buffer.append(out.GetTargetInflection().GetValue());
            buffer.append("): ");
            buffer.append(details);
            buffer.append(GlobalBehavior.LS_STR);
            out.SetDetailInformation(buffer.toString());
        }
        if (mutateInfo != null) {
            out.SetMutateInformation(mutateInfo);
        }
        String flowHistory = out.GetFlowHistory();
        if (!appendFlowFlag) {
            flowHistory = flowName;
        } else if (flowHistory == null) {
            flowHistory = flowName;
        } else {
            buffer = new StringBuffer();
            buffer.append(flowHistory);
            buffer.append("+");
            buffer.append(flowName);
            flowHistory = buffer.toString();
        }
        out.SetFlowHistory(flowHistory);
        return out;
    }

    protected static LexItem UpdateLexItem(LexItem in, String target, int flowBit, long category, long inflection, String details, String mutateInfo) {
        int index = 1;
        String flowName = Flow.GetBitName(flowBit, index);
        LexItem out = Transformation.UpdateLexItem(in, target, flowName, category, inflection, details, mutateInfo, true);
        return out;
    }

    protected static LexItem UpdateLexItem(LexItem in, int flowBit, long category, long inflection, String details, String mutateInfo) {
        LexItem out = new LexItem(in, true);
        out.SetTargetCategory(category);
        out.SetTargetInflection(inflection);
        int index = 1;
        String flowName = Flow.GetBitName(flowBit, index);
        String detailInformation = "----------------------------------------" + GlobalBehavior.GetInstance().GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        buffer.append(detailInformation);
        buffer.append(out.GetFlowComponentNumber());
        buffer.append(". (");
        buffer.append(flowName);
        buffer.append("): ");
        buffer.append(out.GetSourceTerm());
        buffer.append(" (");
        buffer.append(out.GetSourceCategory().GetValue());
        buffer.append(", ");
        buffer.append(out.GetSourceInflection().GetValue());
        buffer.append(") --> ");
        buffer.append(out.GetTargetTerm());
        buffer.append(" (");
        buffer.append(out.GetTargetCategory().GetValue());
        buffer.append(", ");
        buffer.append(out.GetTargetInflection().GetValue());
        buffer.append("): ");
        buffer.append(details);
        buffer.append(GlobalBehavior.GetInstance().GetFieldSeparator());
        out.SetDetailInformation(buffer.toString());
        out.SetMutateInformation(mutateInfo);
        String flowHistory = flowName;
        out.SetFlowHistory(flowHistory);
        return out;
    }

    protected static void PrintResults(LexItem in, Vector<LexItem> outs) {
        System.out.println("-- in term: " + in.GetSourceTerm());
        System.out.println("-- outs.size: " + outs.size());
        System.out.println("======================================");
        String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
        for (int i = 0; i < outs.size(); ++i) {
            LexItem out = outs.elementAt(i);
            System.out.println(out.GetOriginalTerm() + fs + out.GetTargetTerm() + fs + out.GetTargetCategory().GetValue() + fs + out.GetTargetInflection().GetValue() + fs + out.GetFlowHistory() + fs);
            System.out.println(out.GetDetailInformation());
        }
    }
}

