/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.OutputPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.ListButtonPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ViewLexItemsDialog
extends JDialog {
    private static final int FIELD_NUM = 11;
    private static final String[] FIELD_STR = new String[]{"Original term", "Flow number", "Flow history", "Source term", "Target term", "Source category", "Target category", "Source inflection", "Target inflection", "Mutate information", "Detail information"};
    private static final int ORG_TERM = 0;
    private static final int FLOW_NUM = 1;
    private static final int FLOW_HIS = 2;
    private static final int SRC_TERM = 3;
    private static final int TAR_TERM = 4;
    private static final int SRC_CAT = 5;
    private static final int TAR_CAT = 6;
    private static final int SRC_INFL = 7;
    private static final int TAR_INFL = 8;
    private static final int MUTATE_INFO = 9;
    private static final int DETAIL_INFO = 10;
    private JLabel[] cb_ = new JLabel[11];
    private JTextField[] valueT_ = new JTextField[11];
    private int[] size_ = new int[11];
    private String[] defaults_ = new String[11];
    private JTextField indexT_ = null;
    private JTextArea detailArea_ = null;
    private JFrame owner_ = null;
    private int index_ = 0;
    private Vector<LexItem> lexItems_ = new Vector();
    private static final long serialVersionUID = 5L;

    public ViewLexItemsDialog(JFrame owner, Vector<LexItem> lexItems, String title, String label, int index) {
        super(owner, title, false);
        this.owner_ = owner;
        this.index_ = index;
        if (this.index_ < 0) {
            this.index_ = 0;
        } else if (this.index_ > lexItems.size() - 1) {
            this.index_ = lexItems.size() - 1;
        }
        this.lexItems_ = lexItems;
        this.Init();
        this.setLocationRelativeTo(owner);
        this.setSize(600, 530);
        JPanel topP = new JPanel();
        topP.add(new JLabel(label));
        JPanel centerP = new JPanel();
        centerP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output LexItem"));
        GridBagLayout gbl = new GridBagLayout();
        centerP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        GridBag.SetWeight(gbc, 100, 100);
        JButton srcCatB = new JButton("Details");
        JButton tarCatB = new JButton("Details");
        JButton srcInflB = new JButton("Details");
        JButton tarInflB = new JButton("Details");
        for (int i = 0; i < 11; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            centerP.add((Component)this.cb_[i], gbc);
            if (i == 10) {
                GridBag.SetPosSize(gbc, 1, i, 2, 1);
                JScrollPane scrollPane = new JScrollPane(this.detailArea_);
                centerP.add((Component)scrollPane, gbc);
                continue;
            }
            if (i == 5) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                centerP.add((Component)this.valueT_[i], gbc);
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                centerP.add((Component)srcCatB, gbc);
                continue;
            }
            if (i == 6) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                centerP.add((Component)this.valueT_[i], gbc);
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                centerP.add((Component)tarCatB, gbc);
                continue;
            }
            if (i == 7) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                centerP.add((Component)this.valueT_[i], gbc);
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                centerP.add((Component)srcInflB, gbc);
                continue;
            }
            if (i == 8) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                centerP.add((Component)this.valueT_[i], gbc);
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                centerP.add((Component)tarInflB, gbc);
                continue;
            }
            GridBag.SetPosSize(gbc, 1, i, 2, 1);
            centerP.add((Component)this.valueT_[i], gbc);
        }
        ListButtonPanel bottomP = new ListButtonPanel();
        JButton firstB = bottomP.GetFirstButton();
        JButton prevB = bottomP.GetPreviousButton();
        JButton nextB = bottomP.GetNextButton();
        JButton lastB = bottomP.GetLastButton();
        JButton goB = bottomP.GetGoButton();
        JButton closeB = bottomP.GetCloseButton();
        this.indexT_ = bottomP.GetIndexTextField();
        this.indexT_.setText(Integer.toString(this.index_ + 1));
        this.getContentPane().add((Component)topP, "North");
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)bottomP, "South");
        firstB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLexItemsDialog.this.index_ = 0;
                ViewLexItemsDialog.this.UpdatePage();
            }
        });
        prevB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLexItemsDialog.this.index_--;
                if (ViewLexItemsDialog.this.index_ < 0) {
                    ViewLexItemsDialog.this.index_ = 0;
                    Toolkit.getDefaultToolkit().beep();
                }
                ViewLexItemsDialog.this.UpdatePage();
            }
        });
        nextB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLexItemsDialog.this.index_++;
                int max = ViewLexItemsDialog.this.lexItems_.size() - 1;
                if (ViewLexItemsDialog.this.index_ > max) {
                    ViewLexItemsDialog.this.index_ = max;
                    Toolkit.getDefaultToolkit().beep();
                }
                ViewLexItemsDialog.this.UpdatePage();
            }
        });
        lastB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLexItemsDialog.this.index_ = ViewLexItemsDialog.this.lexItems_.size() - 1;
                ViewLexItemsDialog.this.UpdatePage();
            }
        });
        goB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ViewLexItemsDialog.this.index_ = Integer.parseInt(ViewLexItemsDialog.this.indexT_.getText()) - 1;
                }
                catch (Exception e) {
                    Toolkit.getDefaultToolkit().beep();
                }
                int max = ViewLexItemsDialog.this.lexItems_.size() - 1;
                if (ViewLexItemsDialog.this.index_ > max) {
                    ViewLexItemsDialog.this.index_ = max;
                    Toolkit.getDefaultToolkit().beep();
                } else if (ViewLexItemsDialog.this.index_ < 0) {
                    ViewLexItemsDialog.this.index_ = 0;
                    Toolkit.getDefaultToolkit().beep();
                }
                ViewLexItemsDialog.this.UpdatePage();
            }
        });
        closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLexItemsDialog.this.setVisible(false);
            }
        });
        srcCatB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = ViewLexItemsDialog.GetCategoryName(ViewLexItemsDialog.this.valueT_[5].getText());
                JOptionPane.showMessageDialog(ViewLexItemsDialog.this.owner_, name, "Category Details", 1);
            }
        });
        tarCatB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = ViewLexItemsDialog.GetCategoryName(ViewLexItemsDialog.this.valueT_[6].getText());
                JOptionPane.showMessageDialog(ViewLexItemsDialog.this.owner_, name, "Category Details", 1);
            }
        });
        srcInflB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = ViewLexItemsDialog.GetInflectionName(ViewLexItemsDialog.this.valueT_[7].getText());
                JOptionPane.showMessageDialog(ViewLexItemsDialog.this.owner_, name, "Inflection Details", 1);
            }
        });
        tarInflB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = ViewLexItemsDialog.GetInflectionName(ViewLexItemsDialog.this.valueT_[8].getText());
                JOptionPane.showMessageDialog(ViewLexItemsDialog.this.owner_, name, "Inflection Details", 1);
            }
        });
    }

    protected static String GetCategoryName(String in) {
        String out = new String();
        try {
            long value = Long.parseLong(in);
            out = "Value: " + in + "\nName: " + Category.ToName(value);
        }
        catch (Exception e) {
            out = "No detail information available!";
        }
        return out;
    }

    protected static String GetInflectionName(String in) {
        String out = new String();
        try {
            long value = Long.parseLong(in);
            out = "Value: " + in + "\nName: " + Inflection.ToName(value);
        }
        catch (Exception e) {
            out = "No detail information available!";
        }
        return out;
    }

    private void UpdatePage() {
        if (this.lexItems_ != null && this.index_ >= 0 && this.index_ < this.lexItems_.size()) {
            LexItem lexItem = this.lexItems_.elementAt(this.index_);
            this.defaults_[0] = lexItem.GetOriginalTerm();
            this.defaults_[1] = Integer.toString(lexItem.GetFlowNumber());
            this.defaults_[2] = lexItem.GetFlowHistory();
            this.defaults_[3] = lexItem.GetSourceTerm();
            this.defaults_[4] = lexItem.GetTargetTerm();
            this.defaults_[5] = Long.toString(lexItem.GetSourceCategory().GetValue());
            this.defaults_[6] = Long.toString(lexItem.GetTargetCategory().GetValue());
            this.defaults_[7] = Long.toString(lexItem.GetSourceInflection().GetValue());
            this.defaults_[8] = Long.toString(lexItem.GetTargetInflection().GetValue());
            this.defaults_[9] = lexItem.GetMutateInformation();
            this.defaults_[10] = lexItem.GetDetailInformation();
        }
        for (int i = 0; i < 11; ++i) {
            this.valueT_[i].setText(this.defaults_[i]);
        }
        this.detailArea_.setText(this.defaults_[10]);
        this.indexT_.setText(Integer.toString(this.index_ + 1));
        OutputPanel.SetSelectedIndex(this.index_);
    }

    public void Init() {
        if (this.lexItems_ != null && this.index_ >= 0 && this.index_ < this.lexItems_.size()) {
            LexItem lexItem = this.lexItems_.elementAt(this.index_);
            this.defaults_[0] = lexItem.GetOriginalTerm();
            this.defaults_[1] = Integer.toString(lexItem.GetFlowNumber());
            this.defaults_[2] = lexItem.GetFlowHistory();
            this.defaults_[3] = lexItem.GetSourceTerm();
            this.defaults_[4] = lexItem.GetTargetTerm();
            this.defaults_[5] = Long.toString(lexItem.GetSourceCategory().GetValue());
            this.defaults_[6] = Long.toString(lexItem.GetTargetCategory().GetValue());
            this.defaults_[7] = Long.toString(lexItem.GetSourceInflection().GetValue());
            this.defaults_[8] = Long.toString(lexItem.GetTargetInflection().GetValue());
            this.defaults_[9] = lexItem.GetMutateInformation();
            this.defaults_[10] = lexItem.GetDetailInformation();
        }
        this.size_[0] = 15;
        this.size_[1] = 2;
        this.size_[2] = 15;
        this.size_[3] = 15;
        this.size_[4] = 15;
        this.size_[5] = 4;
        this.size_[6] = 4;
        this.size_[7] = 8;
        this.size_[8] = 8;
        this.size_[9] = 35;
        this.size_[10] = 0;
        if (this.detailArea_ == null) {
            this.detailArea_ = new JTextArea(5, 35);
            this.detailArea_.setLineWrap(true);
            this.detailArea_.setWrapStyleWord(true);
            this.detailArea_.setEditable(false);
            this.detailArea_.setText(this.defaults_[10]);
        }
        for (int i = 0; i < 11; ++i) {
            this.cb_[i] = new JLabel(FIELD_STR[i] + ": ");
            this.valueT_[i] = new JTextField(this.defaults_[i], this.size_[i]);
            this.valueT_[i].setEditable(false);
        }
    }
}

