/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Lib.Category;
import java.util.StringTokenizer;

public class XeroxParc {
    private String tagger_ = null;
    private String term_ = null;
    private String category_ = null;
    private long categoryValue_ = 0L;
    private boolean legal_ = true;

    public XeroxParc(String tagger) {
        this.tagger_ = tagger;
        this.DecomposeTagger(this.tagger_);
    }

    public boolean IsLegal() {
        if (this.term_ == null || this.category_ == null) {
            return false;
        }
        return this.legal_;
    }

    public String GetTerm() {
        return this.term_;
    }

    public String GetCategory() {
        return this.category_;
    }

    public long GetCategoryValue() {
        return this.categoryValue_;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("** Usage: java XeroxParc <tag>");
        } else {
            String inTag = args[0];
            System.out.println("-- tagger: '" + inTag + "'");
            XeroxParc foo = new XeroxParc(inTag);
            System.out.println("-- term: [" + foo.GetTerm() + "]");
            System.out.println("-- category: [" + foo.GetCategory() + "]");
            System.out.println("-- categoryValue: [" + foo.GetCategoryValue() + "]");
        }
    }

    private void DecomposeTagger(String tagger) {
        this.legal_ = this.IsLegalXeroxParcFormat(tagger);
        if (!this.legal_) {
            return;
        }
        String delim = "[',]";
        StringTokenizer buf = new StringTokenizer(tagger, delim);
        this.term_ = null;
        this.category_ = null;
        while (buf.hasMoreTokens()) {
            String temp = buf.nextToken();
            if (temp == null) continue;
            if (this.term_ == null) {
                this.term_ = temp;
                continue;
            }
            if (this.category_ != null || Category.ToValue(temp) == 0L) continue;
            this.category_ = temp;
            this.categoryValue_ = Category.ToValue(this.category_);
            break;
        }
    }

    private boolean IsLegalXeroxParcFormat(String tagger) {
        boolean legalFormat = true;
        if (!tagger.startsWith("[") || !tagger.endsWith("]")) {
            return false;
        }
        return legalFormat;
    }
}

