/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public enum VocabularyStore {
    INSTANCE;

    private final Logger LOGGER = Logger.getLogger((String)"Vocabulary");
    private final Map<String, Class<?>> _vocabularyClasses = new HashMap();

    public static VocabularyStore getInstance() {
        return INSTANCE;
    }

    public Collection<String> getAllVocabularies() {
        return this._vocabularyClasses.keySet();
    }

    public Class<?> getVocabularyClass(String vocabulary) {
        return this._vocabularyClasses.get(vocabulary);
    }

    public void addVocabulary(String vocabulary, String code) {
        Class<?> vocabularyClass = this._vocabularyClasses.get(vocabulary);
        if (String.class.equals(vocabularyClass)) {
            return;
        }
        this._vocabularyClasses.put(vocabulary, VocabularyStore.getBestClass(code));
    }

    public String getJdbcClass(String vocabulary) {
        Class<?> vocabularyClass = this._vocabularyClasses.get(vocabulary);
        if (String.class.equals(vocabularyClass)) {
            return "VARCHAR(48)";
        }
        if (Double.class.equals(vocabularyClass)) {
            return "FLOAT";
        }
        if (Long.class.equals(vocabularyClass)) {
            return "BIGINT";
        }
        if (Integer.class.equals(vocabularyClass)) {
            return "INTEGER";
        }
        this.LOGGER.error((Object)("Could not derive database class for " + vocabularyClass.getName()));
        return "VARCHAR(48)";
    }

    public String getCtakesClass(String vocabulary) {
        Class<?> vocabularyClass = this._vocabularyClasses.get(vocabulary);
        if (String.class.equals(vocabularyClass)) {
            return "text";
        }
        if (Double.class.equals(vocabularyClass)) {
            return "double";
        }
        if (Long.class.equals(vocabularyClass)) {
            return "long";
        }
        if (Integer.class.equals(vocabularyClass)) {
            return "int";
        }
        this.LOGGER.error((Object)("Could not derive database class for " + vocabularyClass.getName()));
        return "text";
    }

    private static Class<?> getBestClassFuture(String code, Class<?> currentClass) {
        boolean haveDot = false;
        for (char c : code.toCharArray()) {
            if (Character.isDigit(c)) continue;
            if (c == '.') {
                if (haveDot) {
                    return String.class;
                }
                haveDot = true;
            }
            return String.class;
        }
        if (haveDot || Double.class.equals(currentClass)) {
            return Double.class;
        }
        if (code.length() > 9 || Long.class.equals(currentClass)) {
            return Long.class;
        }
        return Integer.class;
    }

    private static Class<?> getBestClass(String code) {
        for (char c : code.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return String.class;
        }
        return Long.class;
    }
}

